/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.ucerf3Rups.colorers;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.FileParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.simulators.RSQSimEvent;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.iden.EventIDsRupIden;
import org.opensha.sha.simulators.parsers.RSQSimFileReader;
import org.opensha.sha.simulators.utils.RSQSimSubSectionMapper;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.colorers.ColorerChangeListener;
import org.scec.vtk.commons.opensha.faults.colorers.FaultColorer;
import org.scec.vtk.plugins.opensha.ucerf3Rups.UCERF3RupSetChangeListener;

public class RSQSimRuptureMappingColorer
implements FaultColorer,
ParameterChangeListener,
UCERF3RupSetChangeListener {
    private FileParameter geomFileParam;
    private IntegerParameter eventIDParam;
    private DoubleParameter sectFractParam;
    private ParameterList params = new ParameterList();
    private ColorerChangeListener l;
    private List<SimulatorElement> elems;
    private RSQSimEvent event;
    private HashSet<Integer> sects;
    private List<? extends FaultSection> subSects;
    private RSQSimSubSectionMapper mapper;

    public RSQSimRuptureMappingColorer() {
        this.geomFileParam = new FileParameter("Geometry File");
        this.geomFileParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.geomFileParam);
        this.eventIDParam = new IntegerParameter("Event ID", Integer.valueOf(-1));
        this.eventIDParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.eventIDParam);
        this.sectFractParam = new DoubleParameter("Min Sect Fract", Double.valueOf(0.0));
        this.sectFractParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.sectFractParam);
    }

    public String getName() {
        return "RSQSim Rupture Mappings";
    }

    @Override
    public Color getColor(AbstractFaultSection fault) {
        if (this.sects != null && this.sects.contains(fault.getId())) {
            return Color.GREEN;
        }
        return null;
    }

    @Override
    public ParameterList getColorerParameters() {
        return this.params;
    }

    @Override
    public void setColorerChangeListener(ColorerChangeListener l) {
        this.l = l;
    }

    private void fireChangeEvent() {
        this.l.colorerChanged(this);
    }

    @Override
    public String getLegendLabel() {
        return null;
    }

    public void parameterChange(ParameterChangeEvent e) {
        if (e.getParameter() == this.geomFileParam) {
            try {
                this.elems = RSQSimFileReader.readGeometryFile((File)((File)this.geomFileParam.getValue()), (int)11, (char)'S');
                this.tryLoad();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else if (e.getParameter() == this.eventIDParam) {
            try {
                this.tryLoad();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else if (e.getParameter() == this.sectFractParam) {
            if (this.mapper != null) {
                this.mapper.setMinFractForInclusion(((Double)this.sectFractParam.getValue()).doubleValue());
            }
            this.tryBuildRupture();
            this.fireChangeEvent();
        }
    }

    private void tryLoad() throws IOException {
        this.sects = null;
        if (this.elems != null && (Integer)this.eventIDParam.getValue() >= 0 && this.subSects != null) {
            EventIDsRupIden loadIden = new EventIDsRupIden(new int[]{(Integer)this.eventIDParam.getValue()});
            ArrayList<EventIDsRupIden> loadIdens = new ArrayList<EventIDsRupIden>();
            loadIdens.add(loadIden);
            System.out.println("Loading events, looking for " + String.valueOf(this.eventIDParam.getValue()));
            List events = RSQSimFileReader.readEventsFile((File)((File)this.geomFileParam.getValue()).getParentFile(), this.elems, loadIdens);
            this.mapper = new RSQSimSubSectionMapper(this.subSects, this.elems, ((Double)this.sectFractParam.getValue()).doubleValue());
            if (events.size() == 1) {
                System.out.println("Found it!");
                this.event = (RSQSimEvent)events.get(0);
                this.tryBuildRupture();
            } else {
                System.out.println("Not found.");
            }
        }
        this.fireChangeEvent();
    }

    private void tryBuildRupture() {
        if (this.event == null || this.elems == null || this.subSects == null) {
            return;
        }
        List bundles = this.mapper.getFilteredSubSectionMappings((SimulatorEvent)this.event);
        if (bundles.isEmpty() && (Double)this.sectFractParam.getValue() > 0.0) {
            bundles = this.mapper.getAllSubSectionMappings((SimulatorEvent)this.event);
        }
        this.sects = new HashSet();
        for (List bundle : bundles) {
            for (RSQSimSubSectionMapper.SubSectionMapping mapping : bundle) {
                this.sects.add(mapping.getSubSect().getSectionId());
            }
        }
    }

    @Override
    public void setRupSet(FaultSystemRupSet rupSet, FaultSystemSolution sol) {
        if (rupSet == null) {
            this.subSects = null;
            this.mapper = null;
        } else {
            this.subSects = rupSet.getFaultSectionDataList();
        }
    }
}

