/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.opensha.ucerf3Rups.colorers;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.gui.plot.GraphWidget;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.ButtonParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.IDPairing;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.ClusterRupture;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.FaultSubsectionCluster;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureConnectionSearch;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.Surface3D;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCalculator;
import org.opensha.sha.simulators.stiffness.SubSectStiffnessCalculator;
import org.scec.vtk.commons.opensha.faults.AbstractFaultSection;
import org.scec.vtk.commons.opensha.faults.colorers.CPTBasedColorer;
import org.scec.vtk.commons.opensha.faults.faultSectionImpl.PrefDataSection;
import org.scec.vtk.commons.opensha.gui.EventManager;
import org.scec.vtk.commons.opensha.surfaces.FaultActorBundle;
import org.scec.vtk.commons.opensha.surfaces.FaultActorBundler;
import org.scec.vtk.commons.opensha.surfaces.FaultSectionActorList;
import org.scec.vtk.commons.opensha.surfaces.FaultSectionBundledActorList;
import org.scec.vtk.commons.opensha.surfaces.GeometryGenerator;
import org.scec.vtk.commons.opensha.surfaces.LineSurfaceGenerator;
import org.scec.vtk.commons.opensha.surfaces.PolygonSurfaceGenerator;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.plugins.opensha.ucerf3Rups.UCERF3RupSetChangeListener;
import org.scec.vtk.tools.picking.PickEnabledActor;
import org.scec.vtk.tools.picking.PickHandler;
import org.scec.vtk.tools.picking.PointPickEnabledActor;
import vtk.vtkActor;
import vtk.vtkCellPicker;
import vtk.vtkProp;

public class StiffnessColorer
extends CPTBasedColorer
implements PickHandler<AbstractFaultSection>,
UCERF3RupSetChangeListener,
ParameterChangeListener {
    private FaultSystemRupSet rupSet;
    private SectionDistanceAzimuthCalculator distAzCalc;
    private static final String AGG_1_NAME = "Patch-To-Patch Agg";
    private static final AggregatedStiffnessCalculator.AggregationMethod AGG_1_DEFAULT = AggregatedStiffnessCalculator.AggregationMethod.PASSTHROUGH;
    private EnumParameter<AggregatedStiffnessCalculator.AggregationMethod> agg1Param;
    private static final String AGG_2_NAME = "Sect-To-Sect Agg";
    private static final AggregatedStiffnessCalculator.AggregationMethod AGG_2_DEFAULT = AggregatedStiffnessCalculator.AggregationMethod.SUM;
    private EnumParameter<AggregatedStiffnessCalculator.AggregationMethod> agg2Param;
    private static final String AGG_3_NAME = "Sects-To-Sect Agg";
    private static final AggregatedStiffnessCalculator.AggregationMethod AGG_3_DEFAULT = AggregatedStiffnessCalculator.AggregationMethod.SUM;
    private EnumParameter<AggregatedStiffnessCalculator.AggregationMethod> agg3Param;
    private static final String AGG_4_NAME = "Sects-To-Sects Agg";
    private static final AggregatedStiffnessCalculator.AggregationMethod AGG_4_DEFAULT = AggregatedStiffnessCalculator.AggregationMethod.SUM;
    private EnumParameter<AggregatedStiffnessCalculator.AggregationMethod> agg4Param;
    private static final String PARENT_SECT_PARAM_NAME = "Parent Sections";
    private static final boolean PARENT_SECT_PARAM_DEFAULT = false;
    private BooleanParameter parentSectParam;
    private static final String PATCH_ALIGNMENT_PARAM_NAME = "Patch Alignment";
    private EnumParameter<SubSectStiffnessCalculator.PatchAlignment> alignmentParam;
    private static final String GRID_SPACING_PARAM_NAME = "Grid Spacing";
    private static final double GRID_SPACING_DEFAULT = 2.0;
    private static final double GRID_SPACING_MIN = 0.1;
    private static final double GRID_SPACING_MAX = 10.0;
    private DoubleParameter gridSpacingParam;
    private static final String TYPE_PARAM_NAME = "Type";
    private EnumParameter<SubSectStiffnessCalculator.StiffnessType> typeParam;
    public static ButtonParameter clearButton;
    private static final String SELF_STIFFNESS_PARAM_NAME = "Self-Stiffness Cap (Multiplier)";
    private static final double SELF_STIFFNESS_DEFAULT = 1.0;
    private static final double SELF_STIFFNESS_MIN = 0.0;
    private static final double SELF_STIFFNESS_MAX = 10.0;
    private DoubleParameter selfStiffParam;
    private static final String MAX_DIST_PARAM_NAME = "Max Distance";
    private static final String MAX_DIST_PARAM_UNITS = "km";
    private static final double MAX_DIST_DEFAULT = 100.0;
    private static final double MAX_DIST_MIN = 10.0;
    private static final double MAX_DIST_MAX = 1000.0;
    private DoubleParameter maxDistParam;
    private static final String LAME_PARAMS_UNITS = "MPa";
    private static final String LAMBDA_PARAM_NAME = "Lame Lambda";
    private static final double LAMBDA_DEFAULT = 30000.0;
    private static final double LAMBDA_MIN = 1000.0;
    private static final double LAMBDA_MAX = 100000.0;
    private DoubleParameter lambdaParam;
    private static final String MU_PARAM_NAME = "Lame Mu";
    private static final double MU_DEFAULT = 30000.0;
    private static final double MU_MIN = 1000.0;
    private static final double MU_MAX = 100000.0;
    private DoubleParameter muParam;
    private static final String COEF_OF_FRICTION_PARAM_NAME = "Coef. Of Friction";
    private static final double COEF_OF_FRICTION_DEFAULT = 0.5;
    private static final double COEF_OF_FRICTION_MIN = 0.0;
    private static final double COEF_OF_FRICTION_MAX = 1.0;
    private DoubleParameter coefOfFrictionParam;
    private static final String RUP_INDEX_PARAM_NAME = "Rupture Index";
    private IntegerParameter rupIndexParam;
    private static final String RUP_QUANTITY_PARAM_NAME = "Rupture Quantity";
    private EnumParameter<RupQuantity> rupQuantityParam;
    private static final String REUSE_RECEIVER_WINDOW_PARAM_NAME = "Reuse Receiver Window";
    private static final boolean REUSE_RECEIVER_WINDOW_PARAM_DEFAULT = true;
    private BooleanParameter reuseRecieverWindowParam;
    private GraphWindow receiverGW;
    private static final String SHOW_PATCHES_NAME = "Show Src/Receiver Patches";
    private static final boolean SHOW_PATCHES_PARAM_DEFAULT = false;
    private BooleanParameter showPatchesParam;
    private static final String SHOW_LINES_NAME = "Show Src/Receiver Lines";
    private static final boolean SHOW_LINES_PARAM_DEFAULT = false;
    private BooleanParameter showLinesParam;
    private ClusterRupture curRupture;
    private FaultSubsectionCluster startCluster;
    private RuptureConnectionSearch search;
    private ParameterList params = new ParameterList();
    private Color highlightColor = Color.GREEN.darker().darker();
    private SubSectStiffnessCalculator subSectCalc;
    private AggregatedStiffnessCalculator aggCalc;
    private ExecutorService exec;
    private Map<Integer, Double> faultResults;
    private Map<Integer, Double> rupResults;
    private Map<IDPairing, Double> distances;
    private List<FaultSection> sources = new ArrayList<FaultSection>();
    private List<FaultSection> receivers = new ArrayList<FaultSection>();
    private PluginActors pluginActors;
    private EventManager em;
    private HashSet<vtkActor> patchActors;
    private HashSet<vtkActor> lineActors;

    private static CPT getDefaultCPT() {
        CPT cpt = SubSectStiffnessCalculator.getPreferredPosNegCPT();
        cpt.setNanColor(Color.DARK_GRAY);
        return cpt;
    }

    private static CPT getFractCPT() {
        CPT cpt;
        try {
            cpt = GMT_CPT_Files.RAINBOW_UNIFORM.instance();
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException((Throwable)e);
        }
        cpt = cpt.rescale(0.0, 1.0);
        cpt.setNanColor(Color.LIGHT_GRAY);
        return cpt;
    }

    public StiffnessColorer(PluginActors pluginActors) {
        super(StiffnessColorer.getDefaultCPT(), false);
        this.pluginActors = pluginActors;
        this.agg1Param = new EnumParameter(AGG_1_NAME, EnumSet.allOf(AggregatedStiffnessCalculator.AggregationMethod.class), (Enum)AGG_1_DEFAULT, null);
        this.agg1Param.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter(this.agg1Param);
        this.agg2Param = new EnumParameter(AGG_2_NAME, EnumSet.allOf(AggregatedStiffnessCalculator.AggregationMethod.class), (Enum)AGG_2_DEFAULT, null);
        this.agg2Param.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter(this.agg2Param);
        this.agg3Param = new EnumParameter(AGG_3_NAME, EnumSet.allOf(AggregatedStiffnessCalculator.AggregationMethod.class), (Enum)AGG_3_DEFAULT, null);
        this.agg3Param.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter(this.agg3Param);
        this.agg4Param = new EnumParameter(AGG_4_NAME, EnumSet.allOf(AggregatedStiffnessCalculator.AggregationMethod.class), (Enum)AGG_4_DEFAULT, null);
        this.agg4Param.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter(this.agg4Param);
        this.showPatchesParam = new BooleanParameter(SHOW_PATCHES_NAME, Boolean.valueOf(false));
        this.showPatchesParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.showPatchesParam);
        this.showLinesParam = new BooleanParameter(SHOW_LINES_NAME, Boolean.valueOf(false));
        this.showLinesParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.showLinesParam);
        this.parentSectParam = new BooleanParameter(PARENT_SECT_PARAM_NAME, Boolean.valueOf(false));
        this.parentSectParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.parentSectParam);
        clearButton = new ButtonParameter("Selected Sources & Receivers", "Clear");
        clearButton.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)clearButton);
        this.typeParam = new EnumParameter(TYPE_PARAM_NAME, EnumSet.allOf(SubSectStiffnessCalculator.StiffnessType.class), (Enum)SubSectStiffnessCalculator.StiffnessType.CFF, null);
        this.typeParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter(this.typeParam);
        this.gridSpacingParam = new DoubleParameter(GRID_SPACING_PARAM_NAME, 0.1, 10.0);
        this.gridSpacingParam.setValue(2.0);
        this.gridSpacingParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.gridSpacingParam);
        this.selfStiffParam = new DoubleParameter(SELF_STIFFNESS_PARAM_NAME, 0.0, 10.0);
        this.selfStiffParam.setValue(1.0);
        this.selfStiffParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.selfStiffParam);
        this.alignmentParam = new EnumParameter(PATCH_ALIGNMENT_PARAM_NAME, EnumSet.allOf(SubSectStiffnessCalculator.PatchAlignment.class), (Enum)SubSectStiffnessCalculator.alignment_default, null);
        this.alignmentParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter(this.alignmentParam);
        this.maxDistParam = new DoubleParameter(MAX_DIST_PARAM_NAME, 10.0, 1000.0);
        this.maxDistParam.setUnits(MAX_DIST_PARAM_UNITS);
        this.maxDistParam.setValue(100.0);
        this.maxDistParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.maxDistParam);
        this.lambdaParam = new DoubleParameter(LAMBDA_PARAM_NAME, 1000.0, 100000.0);
        this.lambdaParam.setValue(30000.0);
        this.lambdaParam.setUnits(LAME_PARAMS_UNITS);
        this.lambdaParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.lambdaParam);
        this.muParam = new DoubleParameter(MU_PARAM_NAME, 1000.0, 100000.0);
        this.muParam.setValue(30000.0);
        this.muParam.setUnits(LAME_PARAMS_UNITS);
        this.muParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.muParam);
        this.coefOfFrictionParam = new DoubleParameter(COEF_OF_FRICTION_PARAM_NAME, 0.0, 1.0);
        this.coefOfFrictionParam.setValue(0.5);
        this.coefOfFrictionParam.addParameterChangeListener((ParameterChangeListener)this);
        this.params.addParameter((Parameter)this.coefOfFrictionParam);
        this.rupIndexParam = new IntegerParameter(RUP_INDEX_PARAM_NAME, Integer.valueOf(-1));
        this.rupQuantityParam = new EnumParameter(RUP_QUANTITY_PARAM_NAME, EnumSet.allOf(RupQuantity.class), (Enum)RupQuantity.SECTION_NET, null);
        this.reuseRecieverWindowParam = new BooleanParameter(REUSE_RECEIVER_WINDOW_PARAM_NAME, Boolean.valueOf(true));
        this.reuseRecieverWindowParam.setInfo("You can ctrl+click on a fault to set a receiver, which will pop up a plot of the value distribution. If this is selected, the graph window will be reused for each plot (otherwise a new window will pop up).");
        this.params.addParameter((Parameter)this.reuseRecieverWindowParam);
        this.faultResults = new HashMap<Integer, Double>();
        this.distances = new HashMap<IDPairing, Double>();
        this.rupResults = new HashMap<Integer, Double>();
    }

    public void setEventManager(EventManager em) {
        this.em = em;
    }

    public String getName() {
        return "Stiffness";
    }

    @Override
    public Color getColor(AbstractFaultSection fault) {
        if (this.curRupture != null) {
            if (this.rupQuantityParam.getValue() == RupQuantity.CLUSTER_PATH) {
                FaultSection sect = ((PrefDataSection)fault).getFaultSection();
                if (this.startCluster == null) {
                    if (this.curRupture.contains(sect)) {
                        return new Color(150, 255, 150);
                    }
                    return this.getCPT().getNanColor();
                }
                if (this.startCluster.contains(sect)) {
                    return this.highlightColor;
                }
            }
        } else if (this.sources != null) {
            for (FaultSection source : this.sources) {
                if (source.getSectionId() != fault.getId()) continue;
                return this.highlightColor;
            }
        }
        double value = this.getValue(fault);
        return super.getColorForValue(value);
    }

    @Override
    public double getValue(AbstractFaultSection fault) {
        if (this.curRupture == null) {
            int id = fault.getId();
            Double result = this.faultResults.get(id);
            if (result == null) {
                return Double.NaN;
            }
            return result;
        }
        Double value = this.rupResults.get(fault.getId());
        if (value == null) {
            return Double.NaN;
        }
        return value;
    }

    private void update() {
        this.faultResults.clear();
        this.rupResults.clear();
        this.curRupture = null;
        this.startCluster = null;
        this.clearPatches();
        if (this.rupSet == null) {
            return;
        }
        if (this.subSectCalc == null) {
            this.subSectCalc = new SubSectStiffnessCalculator(this.rupSet.getFaultSectionDataList(), ((Double)this.gridSpacingParam.getValue()).doubleValue(), ((Double)this.lambdaParam.getValue()).doubleValue(), ((Double)this.muParam.getValue()).doubleValue(), ((Double)this.coefOfFrictionParam.getValue()).doubleValue(), (SubSectStiffnessCalculator.PatchAlignment)this.alignmentParam.getValue(), ((Double)this.selfStiffParam.getValue()).doubleValue());
        }
        if (this.aggCalc == null) {
            this.aggCalc = new AggregatedStiffnessCalculator((SubSectStiffnessCalculator.StiffnessType)this.typeParam.getValue(), this.subSectCalc, false, new AggregatedStiffnessCalculator.AggregationMethod[]{(AggregatedStiffnessCalculator.AggregationMethod)this.agg1Param.getValue(), (AggregatedStiffnessCalculator.AggregationMethod)this.agg2Param.getValue(), (AggregatedStiffnessCalculator.AggregationMethod)this.agg3Param.getValue(), (AggregatedStiffnessCalculator.AggregationMethod)this.agg4Param.getValue()});
        }
        if ((Integer)this.rupIndexParam.getValue() < 0) {
            if (this.sources == null || this.sources.isEmpty()) {
                return;
            }
            if (this.sources.size() == 1) {
                System.out.println("Computing from " + this.sources.get(0).getName());
            } else {
                System.out.println("Computing from " + this.sources.size() + " sources");
            }
            if (this.exec == null) {
                int threads = Integer.min(32, Runtime.getRuntime().availableProcessors());
                if (threads >= 8) {
                    threads -= 2;
                }
                threads = Integer.max(1, threads);
                this.exec = Executors.newFixedThreadPool(threads);
            }
            List subSects = this.rupSet.getFaultSectionDataList();
            HashSet<FaultSection> calcReceiverPatches = null;
            if (((Boolean)this.showPatchesParam.getValue()).booleanValue()) {
                calcReceiverPatches = new HashSet<FaultSection>();
                if (this.receivers == null || this.receivers.isEmpty()) {
                    calcReceiverPatches.addAll(subSects);
                } else {
                    calcReceiverPatches.addAll(this.receivers);
                }
            }
            ArrayList<Future<CalcRunnable>> futures = new ArrayList<Future<CalcRunnable>>();
            if (((Boolean)this.parentSectParam.getValue()).booleanValue()) {
                Map<Integer, List<FaultSection>> parentSectsMap = subSects.stream().collect(Collectors.groupingBy(s -> s.getParentSectionId()));
                Iterator<Object> iterator = parentSectsMap.keySet().iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    futures.add(this.exec.submit(new CalcRunnable(this.sources, (List)parentSectsMap.get(n), calcReceiverPatches)));
                }
            } else {
                for (FaultSection receiver : subSects) {
                    futures.add(this.exec.submit(new CalcRunnable(this.sources, receiver, calcReceiverPatches)));
                }
            }
            System.out.println("Waiting on " + futures.size() + " futures...");
            HashMap<FaultSection, double[]> patchDists = null;
            if (calcReceiverPatches != null) {
                patchDists = new HashMap<FaultSection, double[]>();
            }
            for (Future future : futures) {
                try {
                    CalcRunnable run = (CalcRunnable)future.get();
                    if (patchDists == null || run.receiverPatchAgg == null) continue;
                    patchDists.putAll(run.receiverPatchAgg);
                }
                catch (Exception e) {
                    throw ExceptionUtils.asRuntimeException((Throwable)e);
                }
            }
            if (patchDists != null && !patchDists.isEmpty()) {
                System.out.println("Displaying patches for " + this.sources.size() + " source and " + patchDists.size() + " receiver sections");
                this.showPatches(this.sources, patchDists);
            }
        }
        System.out.println("Done calculating");
        this.fireColorerChangeEvent();
    }

    private synchronized void updateReceiver() {
        this.clearLines();
        if (this.sources == null || this.sources.isEmpty() || this.receivers == null || this.receivers.isEmpty() || this.subSectCalc == null) {
            return;
        }
        SubSectStiffnessCalculator.StiffnessDistribution plotDist = null;
        int sourceID = this.sources.size() > 1 ? this.sources.get(0).getSectionId() : -1;
        int receiverID = this.receivers.size() > 1 ? this.receivers.get(0).getSectionId() : -1;
        for (FaultSection source : this.sources) {
            for (FaultSection receiver : this.receivers) {
                SubSectStiffnessCalculator.StiffnessDistribution dist = this.subSectCalc.calcStiffnessDistribution(source, receiver);
                if (((Boolean)this.showLinesParam.getValue()).booleanValue()) {
                    this.showLines(dist, source, receiver);
                }
                if (((AggregatedStiffnessCalculator.AggregationMethod)this.agg1Param.getValue()).isTerminal()) {
                    dist = dist.receiverAggregate((AggregatedStiffnessCalculator.AggregationMethod)this.agg1Param.getValue());
                }
                if (plotDist == null) {
                    plotDist = dist;
                    continue;
                }
                plotDist = plotDist.add(dist);
            }
        }
        if (!((Boolean)this.reuseRecieverWindowParam.getValue()).booleanValue() || this.receiverGW == null || !this.receiverGW.isVisible()) {
            this.receiverGW = new GraphWindow(new GraphWidget());
        }
        SubSectStiffnessCalculator.LogDistributionPlot plot = this.subSectCalc.plotDistributionHistograms(plotDist, (SubSectStiffnessCalculator.StiffnessType)this.typeParam.getValue(), sourceID, receiverID);
        plot.plotInGW(this.receiverGW);
    }

    private synchronized void clearPatches() {
        if (this.patchActors == null || this.patchActors.isEmpty()) {
            return;
        }
        System.out.println("Clearing patches");
        for (vtkActor actor : this.patchActors) {
            this.pluginActors.removeActor((vtkProp)actor);
        }
        this.patchActors = null;
        this.em.updateViewer();
    }

    private void showPatches(Collection<FaultSection> sources, Map<FaultSection, double[]> faultPatchDists) {
        SwingUtilities.invokeLater(new PatchDisplayRunnable(sources, faultPatchDists));
    }

    private synchronized void clearLines() {
        if (this.lineActors == null || this.lineActors.isEmpty()) {
            return;
        }
        System.out.println("Clearing lines");
        for (vtkActor actor : this.lineActors) {
            this.pluginActors.removeActor((vtkProp)actor);
        }
        this.lineActors = null;
        this.em.updateViewer();
    }

    private void showLines(SubSectStiffnessCalculator.StiffnessDistribution dist, FaultSection source, FaultSection receiver) {
        SwingUtilities.invokeLater(new LineDisplayRunnable(dist, source, receiver));
    }

    @Override
    public synchronized void actorPicked(PickEnabledActor<AbstractFaultSection> actor, AbstractFaultSection reference, vtkCellPicker picker, MouseEvent e) {
        if (reference instanceof PatchSection) {
            System.out.println(((PatchSection)reference).getInfo());
        }
        if (reference instanceof PrefDataSection || reference instanceof PatchSection) {
            FaultSection sect = reference instanceof PrefDataSection ? ((PrefDataSection)reference).getFaultSection() : ((PatchSection)reference).sect;
            if (e.getButton() == 1 && e.isShiftDown()) {
                ArrayList<FaultSection> sectList = new ArrayList<FaultSection>();
                boolean isReceiver = e.isAltDown();
                String mode = isReceiver ? "RECEIVER" : "SOURCE";
                System.out.println("shift down, mode=" + mode + ", picked: " + sect.getName());
                if (e.isControlDown()) {
                    if (isReceiver) {
                        if (this.receivers != null) {
                            sectList.addAll(this.receivers);
                        }
                    } else if (this.sources != null) {
                        sectList.addAll(this.sources);
                    }
                    System.out.println("\twill add to " + sectList.size() + " previously selected");
                }
                if (sectList.contains(sect)) {
                    sectList.remove(sect);
                } else if (((Boolean)this.parentSectParam.getValue()).booleanValue()) {
                    for (FaultSection s : this.rupSet.getFaultSectionDataList().stream().filter(S -> S.getParentSectionId() == sect.getParentSectionId()).collect(Collectors.toList())) {
                        if (sectList.contains(s)) continue;
                        System.out.println("\tadding new section on parentID=" + s.getParentSectionId() + ": " + s.getName());
                        sectList.add(s);
                    }
                } else {
                    sectList.add(sect);
                }
                if (isReceiver) {
                    System.out.println("\tnow have " + sectList.size() + " receivers");
                    this.receivers = sectList;
                    this.updateReceiver();
                }
                if (!isReceiver || this.receivers != null && !this.receivers.isEmpty() && ((Boolean)this.showPatchesParam.getValue()).booleanValue()) {
                    System.out.println("\tnow have " + sectList.size() + " sources");
                    this.sources = sectList;
                    this.update();
                }
            }
        }
    }

    @Override
    public void setRupSet(FaultSystemRupSet rupSet, FaultSystemSolution sol) {
        this.rupSet = null;
        this.distances.clear();
        this.search = null;
        this.distAzCalc = null;
        this.subSectCalc = null;
        this.aggCalc = null;
        this.update();
        this.rupSet = rupSet;
        if (rupSet != null) {
            this.distAzCalc = new SectionDistanceAzimuthCalculator(rupSet.getFaultSectionDataList());
        }
        this.update();
    }

    public void parameterChange(ParameterChangeEvent event) {
        Parameter param = event.getParameter();
        if (param == this.agg1Param || param == this.agg2Param || param == this.agg3Param || param == this.agg4Param) {
            this.aggCalc = null;
            this.update();
            if (this.receivers != null && !this.receivers.isEmpty()) {
                this.updateReceiver();
            }
        } else if (param == this.gridSpacingParam || param == this.lambdaParam || param == this.muParam || param == this.rupIndexParam || param == this.selfStiffParam) {
            this.subSectCalc = null;
            this.aggCalc = null;
            if (param == this.gridSpacingParam || param == this.parentSectParam) {
                this.distances.clear();
            }
            if (param == this.rupIndexParam) {
                if ((Integer)this.rupIndexParam.getValue() >= 0) {
                    this.rupQuantityParam.getEditor().setEnabled(true);
                    if (this.typeParam.getValue() != SubSectStiffnessCalculator.StiffnessType.CFF) {
                        this.typeParam.removeParameterChangeListener((ParameterChangeListener)this);
                        this.typeParam.setValue((Object)SubSectStiffnessCalculator.StiffnessType.CFF);
                        this.typeParam.getEditor().refreshParamEditor();
                        this.typeParam.addParameterChangeListener((ParameterChangeListener)this);
                    }
                } else {
                    this.rupQuantityParam.getEditor().setEnabled(false);
                }
                this.rupQuantityParam.getEditor().refreshParamEditor();
            }
            this.update();
        } else if (param == this.parentSectParam) {
            this.distances.clear();
            this.update();
        } else if (param == this.typeParam || param == this.alignmentParam || param == this.showPatchesParam || param == this.rupQuantityParam) {
            this.update();
        } else if (param == this.showLinesParam) {
            this.updateReceiver();
        } else if (param == clearButton) {
            this.sources = null;
            this.receivers = null;
            this.update();
            this.updateReceiver();
        }
    }

    @Override
    public ParameterList getColorerParameters() {
        return this.params;
    }

    private static enum RupQuantity {
        SECTION_NET("Section Net"),
        CLUSTER_NET("Cluster Net"),
        CLUSTER_PATH("Cluster Path"),
        RUPTURE_NET("Rupture Net");

        private String name;

        private RupQuantity(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private class CalcRunnable
    implements Callable<CalcRunnable> {
        private List<FaultSection> sources;
        private List<FaultSection> receivers;
        private Map<FaultSection, double[]> receiverPatchAgg;
        private HashSet<FaultSection> calcReceiverPatches;

        public CalcRunnable(List<FaultSection> sources, FaultSection receiver, HashSet<FaultSection> calcReceiverPatches) {
            this.sources = sources;
            this.calcReceiverPatches = calcReceiverPatches;
            this.receivers = new ArrayList<FaultSection>();
            this.receivers.add(receiver);
        }

        public CalcRunnable(List<FaultSection> sources, List<FaultSection> receivers, HashSet<FaultSection> calcReceiverPatches) {
            this.sources = sources;
            this.receivers = receivers;
            this.calcReceiverPatches = calcReceiverPatches;
        }

        @Override
        public CalcRunnable call() {
            HashSet<Integer> sourceIDs = new HashSet<Integer>();
            for (FaultSection faultSection : this.sources) {
                sourceIDs.add(faultSection.getSectionId());
            }
            ArrayList<FaultSection> calcReceivers = new ArrayList<FaultSection>();
            for (FaultSection receiver : this.receivers) {
                if (sourceIDs.contains(receiver.getSectionId())) continue;
                calcReceivers.add(receiver);
            }
            if (calcReceivers.isEmpty()) {
                return this;
            }
            double d = (Double)StiffnessColorer.this.maxDistParam.getValue();
            double minDist = Double.POSITIVE_INFINITY;
            for (FaultSection source : this.sources) {
                FaultSection receiver;
                double dist;
                Iterator iterator = calcReceivers.iterator();
                while (iterator.hasNext() && !((minDist = Math.min(dist = StiffnessColorer.this.distAzCalc.getDistance(source, receiver = (FaultSection)iterator.next()), minDist)) <= d)) {
                }
                if (!(minDist <= d)) continue;
                break;
            }
            if (minDist > d) {
                return this;
            }
            if (this.calcReceiverPatches != null) {
                this.receiverPatchAgg = new HashMap<FaultSection, double[]>();
                for (FaultSection receiver : calcReceivers) {
                    if (!this.calcReceiverPatches.contains(receiver)) continue;
                    this.receiverPatchAgg.put(receiver, StiffnessColorer.this.aggCalc.calcReceiverPatchAgg(this.sources, receiver));
                }
            }
            double val = StiffnessColorer.this.aggCalc.calc(this.sources, calcReceivers);
            for (FaultSection receiver : calcReceivers) {
                StiffnessColorer.this.faultResults.put(receiver.getSectionId(), val);
            }
            return this;
        }
    }

    private class PatchDisplayRunnable
    implements Runnable {
        private Collection<FaultSection> sources;
        private Map<FaultSection, double[]> faultPatchDists;

        public PatchDisplayRunnable(Collection<FaultSection> sources, Map<FaultSection, double[]> faultPatchDists) {
            this.sources = sources;
            this.faultPatchDists = faultPatchDists;
        }

        @Override
        public void run() {
            PolygonSurfaceGenerator polyGen = new PolygonSurfaceGenerator();
            polyGen.setBundlerEneabled(true);
            polyGen.setFaultActorBundler(new PatchSectBundler());
            polyGen.setPickHandler(StiffnessColorer.this);
            polyGen.setOpacity(0.8);
            HashSet<FaultSection> allSects = new HashSet<FaultSection>(this.sources);
            allSects.addAll(this.faultPatchDists.keySet());
            for (FaultSection sect : allSects) {
                List patches = StiffnessColorer.this.subSectCalc.getPatches(sect);
                double[] patchVals = this.faultPatchDists.get(sect);
                if (patchVals != null) {
                    Preconditions.checkState((patches.size() == patchVals.length ? 1 : 0) != 0, (String)"Have %s patches on %s but have %s patch values", (Object)patches.size(), (Object)sect.getSectionId(), (Object)patchVals.length);
                }
                if (StiffnessColorer.this.patchActors == null) {
                    StiffnessColorer.this.patchActors = new HashSet();
                }
                for (int i = 0; i < patches.size(); ++i) {
                    double val;
                    Color c;
                    SubSectStiffnessCalculator.PatchLocation patch = (SubSectStiffnessCalculator.PatchLocation)patches.get(i);
                    if (patchVals == null) {
                        c = StiffnessColorer.this.highlightColor;
                        val = Double.NaN;
                    } else {
                        val = patchVals[i];
                        c = StiffnessColorer.this.getCPT().getColor((float)val);
                    }
                    LocationList outline = new LocationList();
                    Preconditions.checkState((patch.corners.length == 4 ? 1 : 0) != 0);
                    for (Location corner : patch.corners) {
                        outline.add((Object)corner);
                    }
                    FaultSectionActorList list = polyGen.buildSimplePolygon(outline, c, new PatchSection(sect, patch, i, val));
                    StiffnessColorer.this.em.displayActors(list, false);
                    if (list instanceof FaultSectionBundledActorList) {
                        FaultSectionBundledActorList bundled = (FaultSectionBundledActorList)list;
                        PointPickEnabledActor<AbstractFaultSection> actor = bundled.getBundle().getActor();
                        if (!StiffnessColorer.this.patchActors.contains(actor)) {
                            StiffnessColorer.this.patchActors.add(actor);
                        }
                        bundled.getBundle().setVisible(bundled, true);
                        continue;
                    }
                    for (vtkActor actor : list) {
                        StiffnessColorer.this.patchActors.add(actor);
                    }
                }
            }
            StiffnessColorer.this.em.updateViewer();
        }
    }

    private class LineDisplayRunnable
    implements Runnable {
        private SubSectStiffnessCalculator.StiffnessDistribution dist;
        private FaultSection source;
        private FaultSection receiver;

        private LineDisplayRunnable(SubSectStiffnessCalculator.StiffnessDistribution dist, FaultSection source, FaultSection receiver) {
            this.dist = dist;
            this.source = source;
            this.receiver = receiver;
        }

        @Override
        public void run() {
            double[][] fullVals = this.dist.get((SubSectStiffnessCalculator.StiffnessType)StiffnessColorer.this.typeParam.getValue());
            if (StiffnessColorer.this.lineActors == null) {
                StiffnessColorer.this.lineActors = new HashSet();
            }
            LineSurfaceGenerator lineGen = new LineSurfaceGenerator();
            lineGen.setBundlerEneabled(true);
            lineGen.setFaultActorBundler(new LineSectBundler());
            lineGen.setOpacity(0.75);
            for (int s = 0; s < this.dist.sourcePatches.size(); ++s) {
                SubSectStiffnessCalculator.PatchLocation source = (SubSectStiffnessCalculator.PatchLocation)this.dist.sourcePatches.get(s);
                double[] sourcePt = GeometryGenerator.getPointForLoc(source.center);
                for (int r = 0; r < this.dist.receiverPatches.size(); ++r) {
                    SubSectStiffnessCalculator.PatchLocation receiver = (SubSectStiffnessCalculator.PatchLocation)this.dist.receiverPatches.get(r);
                    double val = fullVals[r][s];
                    Color c = StiffnessColorer.this.getCPT().getColor((float)val);
                    LocationList line = new LocationList();
                    line.add((Object)source.center);
                    line.add((Object)receiver.center);
                    FaultSectionActorList list = lineGen.createFaultActors(line, c, (AbstractFaultSection)new LineSection(this.source, this.receiver, s, r, val));
                    StiffnessColorer.this.em.displayActors(list, false);
                    if (list instanceof FaultSectionBundledActorList) {
                        FaultSectionBundledActorList bundled = (FaultSectionBundledActorList)list;
                        vtkActor actor = bundled.getBundle().getActor();
                        if (!StiffnessColorer.this.lineActors.contains(actor)) {
                            StiffnessColorer.this.lineActors.add(actor);
                        }
                        bundled.getBundle().setVisible(bundled, true);
                        continue;
                    }
                    for (vtkActor actor : list) {
                        StiffnessColorer.this.lineActors.add(actor);
                    }
                }
            }
            StiffnessColorer.this.em.updateViewer();
        }
    }

    private class PatchSection
    extends AbstractFaultSection {
        private FaultSection sect;
        private SubSectStiffnessCalculator.PatchLocation patch;
        private int patchIndex;
        private double val;

        public PatchSection(FaultSection sect, SubSectStiffnessCalculator.PatchLocation patch, int patchIndex, double val) {
            super(sect.getName() + ", Patch " + patchIndex, 1000 * sect.getSectionId() + patchIndex);
            this.sect = sect;
            this.patch = patch;
            this.patchIndex = patchIndex;
            this.val = val;
        }

        @Override
        public String getInfo() {
            return this.sect.getSectionId() + ". " + this.sect.getName() + ", Patch " + this.patchIndex + ", value: " + this.val + ", parID=" + this.sect.getParentSectionId();
        }

        @Override
        public Surface3D createSurface(ParameterList faultRepresentationParams) {
            return null;
        }

        @Override
        public double getSlipRate() {
            return Double.NaN;
        }

        @Override
        public double getAvgRake() {
            return Double.NaN;
        }

        @Override
        public double getAvgStrike() {
            return Double.NaN;
        }

        @Override
        public double getAvgDip() {
            return Double.NaN;
        }
    }

    private class LineSectBundler
    implements FaultActorBundler {
        FaultActorBundle bundle;

        private LineSectBundler() {
        }

        @Override
        public FaultActorBundle getBundle(AbstractFaultSection fault) {
            if (!(fault instanceof LineSection)) {
                return null;
            }
            if (this.bundle == null) {
                System.out.println("Building a *new* line bundle");
                this.bundle = new FaultActorBundle();
            }
            return this.bundle;
        }

        @Override
        public void clearBundles() {
            this.bundle = null;
        }
    }

    private class LineSection
    extends AbstractFaultSection {
        private FaultSection source;
        private FaultSection receiver;
        private int sourceIndex;
        private int receiverIndex;
        private double val;

        public LineSection(FaultSection source, FaultSection receiver, int sourceIndex, int receiverIndex, double val) {
            super(source.getSectionId() + "[" + sourceIndex + "] => " + receiver.getSectionId() + "[" + receiverIndex + "]", source.getSectionId() * 10000 + receiver.getSectionId() * 1000 + sourceIndex * 100 + receiverIndex);
            this.source = source;
            this.receiver = receiver;
            this.sourceIndex = sourceIndex;
            this.receiverIndex = receiverIndex;
            this.val = val;
        }

        @Override
        public String getInfo() {
            return this.getName() + ", value: " + this.val;
        }

        @Override
        public Surface3D createSurface(ParameterList faultRepresentationParams) {
            return null;
        }

        @Override
        public double getSlipRate() {
            return Double.NaN;
        }

        @Override
        public double getAvgRake() {
            return Double.NaN;
        }

        @Override
        public double getAvgStrike() {
            return Double.NaN;
        }

        @Override
        public double getAvgDip() {
            return Double.NaN;
        }
    }

    private class PatchSectBundler
    implements FaultActorBundler {
        private Map<Integer, FaultActorBundle> bundleMap = new HashMap<Integer, FaultActorBundle>();

        private PatchSectBundler() {
        }

        @Override
        public FaultActorBundle getBundle(AbstractFaultSection fault) {
            if (!(fault instanceof PatchSection)) {
                return null;
            }
            PatchSection patchSect = (PatchSection)fault;
            Integer parentID = patchSect.sect.getParentSectionId();
            if (parentID < 0) {
                return null;
            }
            FaultActorBundle bundle = this.bundleMap.get(parentID);
            if (bundle == null) {
                System.out.println("Building a *new* bundle for " + patchSect.sect.getParentSectionName());
                bundle = new FaultActorBundle();
                this.bundleMap.put(parentID, bundle);
            }
            return bundle;
        }

        @Override
        public void clearBundles() {
            this.bundleMap.clear();
        }
    }
}

