/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.utils;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.URL;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.scec.vtk.plugins.utils.DataAccessor;
import org.scec.vtk.tools.Fixes;
import org.scec.vtk.tools.Prefs;

public abstract class AbstractDataAccessor
implements DataAccessor {
    private Logger log = Logger.getLogger(AbstractDataAccessor.class);
    private String objectClass;
    private String sourceFile;
    protected File attsFile;
    protected File dataFile;
    protected String displayName = "";
    private String sourceCite;
    private String sourceRef;
    private String objNotes;
    private boolean fromWeb;
    public boolean infoAdded = false;
    private boolean display = false;
    protected Element object_info;
    protected Document objectDocument;

    protected boolean newDocument() {
        SAXBuilder parser = new SAXBuilder();
        URL dataDoc = AbstractDataAccessor.class.getResource("components/resources/xml/object_template.xml");
        try {
            this.objectDocument = parser.build(dataDoc);
            this.object_info = this.objectDocument.getRootElement().getChild("object_info");
        }
        catch (Exception e) {
            this.log.debug((Object)"problem parsing XML");
            return false;
        }
        return true;
    }

    @Override
    public boolean readDataFile() {
        return false;
    }

    @Override
    public boolean writeDataFile() {
        return false;
    }

    @Override
    public void setInMemory(boolean load) {
    }

    @Override
    public boolean isInMemory() {
        return true;
    }

    @Override
    public void setDisplayed(boolean show) {
        this.display = show;
    }

    @Override
    public boolean isDisplayed() {
        return this.display;
    }

    public int compareTo(Object obj) throws ClassCastException {
        if (!(obj instanceof DataAccessor)) {
            throw new ClassCastException();
        }
        int compare = 0;
        try {
            compare = this.getDisplayName().compareTo(((DataAccessor)obj).getDisplayName());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        return compare;
    }

    @Override
    public boolean equals(Object obj) throws ClassCastException {
        if (obj instanceof DataAccessor) {
            return ((DataAccessor)obj).getAttributeFile() == null ? ((DataAccessor)obj).getDisplayName().equals(this.getDisplayName()) : ((DataAccessor)obj).getAttributeFile().equals(this.getAttributeFile());
        }
        if (obj instanceof File) {
            return ((File)obj).equals(this.getAttributeFile());
        }
        throw new ClassCastException();
    }

    @Override
    public boolean readAttributeFile(File file) {
        SAXBuilder parser = new SAXBuilder();
        try {
            this.objectDocument = parser.build(file);
            this.object_info = this.objectDocument.getRootElement().getChild("object_info");
        }
        catch (Exception e) {
            this.log.debug((Object)"problem parsing XML");
            return false;
        }
        this.objectClass = this.object_info.getChild("class").getText();
        this.sourceFile = Fixes.fixDirectory(this.object_info.getChild("source_file").getText());
        this.attsFile = new File(Fixes.fixDirectory(Prefs.getLibLoc() + this.object_info.getChild("attribute_file").getText()));
        this.setDataFile(Fixes.fixDirectory(this.object_info.getChild("data_file").getText()));
        this.displayName = this.object_info.getChild("display_name").getText();
        this.sourceRef = this.object_info.getChild("source_info").getChild("reference").getText();
        this.sourceCite = this.object_info.getChild("source_info").getChild("citation").getText();
        this.objNotes = this.object_info.getChild("notes").getText();
        return true;
    }

    @Override
    public boolean writeAttributeFile() {
        try {
            XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
            BufferedWriter xmlOut = new BufferedWriter(new FileWriter(this.attsFile));
            outputter.output(this.objectDocument, (Writer)xmlOut);
            xmlOut.close();
        }
        catch (Exception e) {
            this.log.debug((Object)"problem writing XML");
            return false;
        }
        return true;
    }

    public Color readColorElement(Element element) {
        Color c = null;
        if (element.getAttributeValue("r") != "null") {
            try {
                c = new Color(element.getAttribute("r").getFloatValue(), element.getAttribute("g").getFloatValue(), element.getAttribute("b").getFloatValue());
            }
            catch (Exception e) {
                this.log.debug((Object)"problem parsing XML");
                return c;
            }
        }
        return c;
    }

    public void writeColorElement(Element element, Color color) {
        if (color != null) {
            float[] colors = color.getRGBColorComponents(new float[3]);
            element.getAttribute("r").setValue(String.valueOf(colors[0]));
            element.getAttribute("g").setValue(String.valueOf(colors[1]));
            element.getAttribute("b").setValue(String.valueOf(colors[2]));
        } else {
            element.getAttribute("r").setValue("null");
            element.getAttribute("g").setValue("null");
            element.getAttribute("b").setValue("null");
        }
    }

    public String toString() {
        return this.displayName;
    }

    public void setObjectClass(String classname) {
        this.objectClass = classname;
        this.object_info.getChild("class").setText(classname);
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    public void setSourceFile(String filename) {
        this.sourceFile = filename;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setAttributeFile(String filename) {
        this.attsFile = new File(Prefs.getLibLoc() + filename);
    }

    @Override
    public File getAttributeFile() {
        return this.attsFile;
    }

    @Override
    public String getAttributeFileLibPath() {
        return this.object_info.getChild("attribute_file").getText();
    }

    public void setDataFile(String filename) {
        this.dataFile = new File(Prefs.getLibLoc() + filename);
        this.object_info.getChild("data_file").setText(filename);
    }

    @Override
    public File getDataFile() {
        return this.dataFile;
    }

    @Override
    public void setDisplayName(String name) {
        this.displayName = name;
        if (this.object_info != null) {
            this.object_info.getChild("display_name").setText(name);
        }
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setNotes(String notes) {
        this.objNotes = notes;
        this.object_info.getChild("notes").setText(notes);
    }

    @Override
    public String getNotes() {
        return this.objNotes;
    }

    @Override
    public String getCitation() {
        return this.sourceCite;
    }

    @Override
    public void setCitation(String citation) {
        this.sourceCite = citation;
        this.object_info.getChild("source_info").getChild("citation").setText(citation);
    }

    @Override
    public String getReference() {
        return this.sourceRef;
    }

    @Override
    public void setReference(String reference) {
        this.sourceRef = reference;
        this.object_info.getChild("source_info").getChild("reference").setText(reference);
    }
}

