/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.utils;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.scec.vtk.plugins.utils.DataAccessor;

public abstract class AbstractLibraryModel
extends AbstractTableModel {
    private Logger log = Logger.getLogger(AbstractLibraryModel.class);
    protected Vector<DataAccessor> data = new Vector();

    public Class<DataAccessor> getColumnClass(int col) {
        return DataAccessor.class;
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.getObjectAtRow(row);
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    public void clear() {
        this.data.clear();
        this.fireTableDataChanged();
    }

    public void setVisibilityForRow(boolean show, int row) {
        if (this.getLoadedStateForRow(row) && this.getVisibilityForRow(row) != show) {
            this.getObjectAtRow(row).setDisplayed(show);
            this.fireTableCellUpdated(row, 0);
        }
    }

    public void setVisibilityForRows(boolean show, int[] rows) {
        for (int i = 0; i < rows.length; ++i) {
            this.setVisibilityForRow(show, rows[i]);
        }
    }

    public void toggleVisibilityForRow(int row) {
        this.setVisibilityForRow(!this.getObjectAtRow(row).isDisplayed(), row);
    }

    public void toggleVisibilityForRows(int[] rows) {
        int i;
        boolean show = true;
        for (i = 0; i < rows.length; ++i) {
            if (!this.getLoadedStateForRow(rows[i])) continue;
            show = !this.getVisibilityForRow(rows[i]);
            break;
        }
        for (i = 0; i < rows.length; ++i) {
            this.setVisibilityForRow(show, rows[i]);
        }
    }

    public boolean getVisibilityForRow(int row) {
        return this.getObjectAtRow(row).isDisplayed();
    }

    public ArrayList<DataAccessor> getVisibleObjects() {
        ArrayList<DataAccessor> visibleObjects = new ArrayList<DataAccessor>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getVisibilityForRow(i)) continue;
            visibleObjects.add(this.getObjectAtRow(i));
        }
        return visibleObjects;
    }

    public boolean anyAreVisible() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getObjectAtRow(i).isDisplayed()) continue;
            return true;
        }
        return false;
    }

    public void setLoadedStateForRow(boolean load, int row) {
        this.getObjectAtRow(row).setInMemory(load);
        this.fireTableRowsUpdated(row, row);
    }

    public void setLoadedStateForRows(boolean load, int[] rows) {
        for (int i = 0; i < rows.length; ++i) {
            if (this.getLoadedStateForRow(rows[i]) == load) continue;
            this.setLoadedStateForRow(load, rows[i]);
        }
    }

    public boolean getLoadedStateForRow(int row) {
        return this.getObjectAtRow(row).isInMemory();
    }

    public ArrayList<DataAccessor> getLoadedObjects() {
        ArrayList<DataAccessor> loadedObjects = new ArrayList<DataAccessor>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getLoadedStateForRow(i)) continue;
            loadedObjects.add(this.getObjectAtRow(i));
        }
        return loadedObjects;
    }

    public ArrayList<DataAccessor> getAllObjects() {
        ArrayList<DataAccessor> loadedObjects = new ArrayList<DataAccessor>();
        for (int i = 0; i < this.getRowCount(); ++i) {
            loadedObjects.add(this.getObjectAtRow(i));
        }
        return loadedObjects;
    }

    public boolean anyAreLoaded() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getObjectAtRow(i).isInMemory()) continue;
            return true;
        }
        return false;
    }

    public boolean anyAreLoaded(int[] selectedRows) {
        for (int i = 0; i < selectedRows.length; ++i) {
            if (!this.getObjectAtRow(selectedRows[i]).isInMemory()) continue;
            return true;
        }
        return false;
    }

    public boolean allAreLoaded(int[] selectedRows) {
        for (int i = 0; i < selectedRows.length; ++i) {
            if (this.getObjectAtRow(selectedRows[i]).isInMemory()) continue;
            return false;
        }
        return true;
    }

    public boolean noneAreLoaded(int[] selectedRows) {
        for (int i = 0; i < selectedRows.length; ++i) {
            if (!this.getObjectAtRow(selectedRows[i]).isInMemory()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    public void saveDisplayProperties() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.getObjectAtRow(i).writeAttributeFile();
        }
    }

    public void addObject(DataAccessor object) {
        if (!this.contains(object)) {
            this.data.add(object);
            this.sort(this.data);
            this.fireTableDataChanged();
        }
    }

    public void addObjects(List objects) {
        if (objects.size() > 0) {
            for (int i = 0; i < objects.size(); ++i) {
                try {
                    DataAccessor obj = (DataAccessor)objects.get(i);
                    if (this.contains(obj)) continue;
                    this.data.add(obj);
                    continue;
                }
                catch (ClassCastException e) {
                    this.log.debug((Object)"Class cast exception while adding objects");
                }
            }
            this.sort(this.data);
            this.fireTableDataChanged();
        }
    }

    private void sort(List<DataAccessor> list) {
        Object[] a = list.toArray(new DataAccessor[0]);
        Arrays.sort(a);
        ListIterator<DataAccessor> i = list.listIterator();
        for (int j = 0; j < a.length; ++j) {
            i.next();
            i.set((DataAccessor)a[j]);
        }
    }

    public int deleteObjects(Component owner, int[] rows) {
        int delete = JOptionPane.showConfirmDialog(owner, "Are you sure you want to delete the selected object(s)?\n(All attribute and backing data will be deleted)", "Delete Object(s)", 0, 3);
        if (delete == 1 || delete == -1) {
            return delete;
        }
        for (int i = 0; i < rows.length; ++i) {
            if (this.getObjectAtRow(rows[i] - i).getAttributeFile() != null) {
                this.getObjectAtRow(rows[i] - i).getAttributeFile().delete();
            }
            if (this.getObjectAtRow(rows[i] - i).getDataFile() != null) {
                this.getObjectAtRow(rows[i] - i).getDataFile().delete();
            }
            this.removeObjectAtRow(rows[i] - i);
        }
        return delete;
    }

    public void removeObjectAtRow(int row) {
        DataAccessor obj = this.getObjectAtRow(row);
        if (obj.isDisplayed()) {
            obj.setDisplayed(false);
        }
        this.data.removeElementAt(row);
        this.fireTableRowsDeleted(row, row);
    }

    public DataAccessor findObject(File objSource) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getObjectAtRow(i).equals(objSource)) continue;
            return this.getObjectAtRow(i);
        }
        return null;
    }

    public boolean contains(DataAccessor object) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getObjectAtRow(i).equals(object)) continue;
            return true;
        }
        return false;
    }

    public int indexOf(Object object) {
        for (int i = 0; i < this.data.size(); ++i) {
            if (!this.getObjectAtRow(i).equals(object)) continue;
            return i;
        }
        return -1;
    }

    public DataAccessor getObjectAtRow(int row) {
        return this.data.get(row);
    }
}

