/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.utils.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.scec.vtk.plugins.utils.components.ColorButton;
import org.scec.vtk.plugins.utils.components.TreeNode;

public class CheckAllTable
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Object[][] DATA;
    private String TITLE;
    private static final int CHECK_COL = 0;
    private static final int COLOR_COL = 2;
    private DataModel dataModel;
    private JTable table;
    private DefaultListSelectionModel selectionModel;
    ControlPanel controlPanel;
    int hoverRow = 0;
    int hoverColumn = 0;
    private Filter filter;
    JTextField searchBar;
    MouseAdapter rightClickListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) || e.isControlDown()) {
                // empty if block
            }
        }
    };
    MouseMotionAdapter hoverListener = new MouseMotionAdapter(){

        @Override
        public void mouseMoved(MouseEvent e) {
            JTable aTable = (JTable)e.getSource();
            CheckAllTable.this.hoverRow = aTable.rowAtPoint(e.getPoint());
            CheckAllTable.this.hoverColumn = aTable.columnAtPoint(e.getPoint());
            aTable.repaint();
        }
    };
    DefaultTableCellRenderer textRenderer = new DefaultTableCellRenderer(){
        Border padding = BorderFactory.createEmptyBorder(0, 10, 0, 0);

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBorder(this.padding);
            return this;
        }
    };
    DefaultTableCellRenderer controlColumnRenderer = new DefaultTableCellRenderer(){
        Border padding = BorderFactory.createEmptyBorder(0, 0, 0, 0);

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setBorder(this.padding);
            this.setHorizontalAlignment(0);
            this.setFont(new Font("Monospaced", 1, 13));
            if (row == CheckAllTable.this.hoverRow && column == CheckAllTable.this.hoverColumn) {
                this.setForeground(new Color(127, 255, 0));
            } else {
                this.setForeground(Color.DARK_GRAY);
            }
            return this;
        }
    };
    KeyListener searchKeyListener = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            String text = CheckAllTable.this.searchBar.getText();
            CheckAllTable.this.filter.swapPrefix(text);
            CheckAllTable.this.table.getRowSorter().allRowsChanged();
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }
    };

    public CheckAllTable(ArrayList<String> data, String title, TableModelListener tableListener) {
        super(new BorderLayout());
        this.DATA = new Object[data.size()][3];
        for (int i = 0; i < data.size(); ++i) {
            this.DATA[i][0] = Boolean.FALSE;
            this.DATA[i][1] = data.get(i);
            this.DATA[i][2] = Color.white;
        }
        this.initTable(title, tableListener);
    }

    public CheckAllTable(Object[][] data, String title, TableModelListener tableListener) {
        super(new BorderLayout());
        this.DATA = data;
        this.initTable(title, tableListener);
    }

    public CheckAllTable(ArrayList<String> data, String title) {
        super(new BorderLayout());
        this.DATA = new Object[data.size()][3];
        for (int i = 0; i < data.size(); ++i) {
            this.DATA[i][0] = Boolean.FALSE;
            this.DATA[i][1] = data.get(i);
            this.DATA[i][2] = Color.white;
        }
        TableModelListener tableListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
            }
        };
        this.initTable(title, tableListener);
    }

    public CheckAllTable(Object[][] data, String title) {
        super(new BorderLayout());
        this.DATA = data;
        TableModelListener tableListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
            }
        };
        this.initTable(title, tableListener);
    }

    private void initTable(String title, TableModelListener tableListener) {
        this.TITLE = title;
        this.setLayout(new BorderLayout());
        Object[] COLUMN_HEADERS = new String[]{" < ", this.TITLE, ""};
        this.dataModel = new DataModel(this.DATA, COLUMN_HEADERS);
        this.controlPanel = new ControlPanel();
        this.add((Component)this.controlPanel, "North");
        this.table = new JTable(this.dataModel){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if (!this.isRowSelected(row) && column != 2) {
                    c.setBackground(row % 2 == 0 ? this.getBackground() : new Color(240, 254, 255));
                }
                return c;
            }
        };
        this.table.getModel().addTableModelListener(tableListener);
        this.selectionModel = (DefaultListSelectionModel)this.table.getSelectionModel();
        this.selectionModel.setSelectionMode(2);
        this.filter = new Filter();
        this.setTableProperties();
        JScrollPane tableScrollPane = new JScrollPane(this.table);
        tableScrollPane.setBorder(new EmptyBorder(3, 8, 0, 8));
        tableScrollPane.setOpaque(false);
        this.add((Component)tableScrollPane, "Center");
    }

    public void addColumn(ArrayList<String> columnData, String columnTitle) {
        Object[] cData = new Object[columnData.size()];
        for (int i = 0; i < columnData.size(); ++i) {
            cData[i] = columnData.get(i);
        }
        this.dataModel.addColumn((Object)columnTitle, cData);
        this.table.moveColumn(this.table.getColumnCount() - 1, this.table.getColumnCount() - 2);
        this.setTableProperties();
    }

    public void disableCheckboxes() {
        for (int i = 0; i < this.table.getRowCount(); ++i) {
            this.table.getModel().setValueAt("", i, 0);
        }
    }

    private void setTableProperties() {
        this.table.getColumnModel().getColumn(0).setMaxWidth(60);
        this.table.getColumnModel().getColumn(1).setCellRenderer(this.textRenderer);
        this.table.getColumnModel().getColumn(2).setMaxWidth(0);
        this.table.getColumnModel().getColumn(2).setMinWidth(0);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(0);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.setShowGrid(false);
        this.table.setRowHeight(25);
        this.table.setShowHorizontalLines(false);
        this.table.setPreferredScrollableViewportSize(new Dimension(250, 175));
        this.renderTableHeader();
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.table.getModel());
        sorter.setRowFilter(this.filter);
        sorter.setSortable(0, false);
        this.table.setRowSorter(sorter);
    }

    public void renderTableHeader() {
        ((DefaultTableCellRenderer)this.table.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.getTableHeader().setResizingAllowed(false);
    }

    public void addPopupMenu() {
        JFrame frame = new JFrame("PopupSample Example");
        frame.setDefaultCloseOperation(3);
        JPopupMenu popupMenu = new JPopupMenu("Title");
    }

    public void addControlColumn(MouseAdapter mouseListener, String controlSymbol, TreeNode<CheckAllTable> tableNode) {
        this.table.addMouseListener(mouseListener);
        Object[] controlSymbols = new Object[this.table.getRowCount()];
        for (int row = 0; row < this.table.getRowCount(); ++row) {
            controlSymbols[row] = this.hasSubTable(row, tableNode) || controlSymbol.equals("Load") ? controlSymbol : "";
        }
        this.dataModel.addColumn((Object)"", controlSymbols);
        this.table.getColumnModel().getColumn(this.table.getColumnCount() - 1).setCellRenderer(this.controlColumnRenderer);
        if (controlSymbol.equals("Load")) {
            this.table.getColumnModel().getColumn(this.table.getColumnCount() - 1).setMaxWidth(100);
        } else {
            this.table.getColumnModel().getColumn(this.table.getColumnCount() - 1).setMaxWidth(30);
        }
        this.table.addMouseMotionListener(this.hoverListener);
        this.setTableProperties();
    }

    public boolean hasSubTable(int row, TreeNode<CheckAllTable> tableNode) {
        for (TreeNode<CheckAllTable> treeNode : tableNode) {
            if (!((CheckAllTable)treeNode.data).getTitle().equals(this.table.getValueAt(row, 1))) continue;
            return true;
        }
        return false;
    }

    public JTable getTable() {
        return this.table;
    }

    public String getTitle() {
        return this.TITLE;
    }

    public void addColorButton(ActionListener actionListener) {
        ColorButton colorDrawingToolsButton = new ColorButton(actionListener, "Change color");
        colorDrawingToolsButton.setEnabled(true);
        this.controlPanel.buttonPanel.add((Component)colorDrawingToolsButton, 0);
    }

    public void clearSearchBar() {
        this.searchBar.setText("");
        this.filter.swapPrefix("");
        this.table.getRowSorter().allRowsChanged();
    }

    private class DataModel
    extends DefaultTableModel {
        public DataModel(Object[][] data, Object[] columnNames) {
            super(data, columnNames);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return this.getValueAt(0, 0).getClass();
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0 && !(this.getValueAt(row, 0) instanceof String);
        }
    }

    public class ControlPanel
    extends JPanel {
        JPanel buttonPanel;
        JPanel searchPanel;

        public ControlPanel() {
            this.setBorder(new EmptyBorder(4, 0, -3, 3));
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            this.buttonPanel = new JPanel(new FlowLayout(3));
            this.buttonPanel.setBorder(new EmptyBorder(4, 1, 4, 0));
            JButton selectButton = new JButton(new SelectionAction("Select All", true));
            JButton deselectButton = new JButton(new SelectionAction("Deselect All", false));
            this.buttonPanel.add((Component)selectButton, 0);
            this.buttonPanel.add((Component)deselectButton, 0);
            this.add((Component)this.buttonPanel, "Before");
            this.searchPanel = new JPanel(new BorderLayout());
            this.searchPanel.setPreferredSize(new Dimension(300, 10));
            this.searchPanel.setBorder(new EmptyBorder(10, 0, 9, 4));
            CheckAllTable.this.searchBar = new JTextField();
            CheckAllTable.this.searchBar.addKeyListener(CheckAllTable.this.searchKeyListener);
            this.searchPanel.add((Component)new JLabel("Search: "), "Before");
            this.searchPanel.add((Component)CheckAllTable.this.searchBar, "Center");
            this.add((Component)this.searchPanel, "After");
        }
    }

    private static class Filter
    extends RowFilter<TableModel, Integer> {
        private String includePrefix = "";

        private Filter() {
        }

        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
            return entry.getStringValue(1).toLowerCase().startsWith(this.includePrefix);
        }

        public void swapPrefix(String text) {
            this.includePrefix = text.toLowerCase();
        }
    }

    private class SelectionAction
    extends AbstractAction {
        boolean value;

        public SelectionAction(String name, boolean value) {
            super(name);
            this.value = value;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < CheckAllTable.this.dataModel.getRowCount(); ++i) {
                CheckAllTable.this.dataModel.setValueAt(this.value, CheckAllTable.this.table.convertRowIndexToModel(i), 0);
            }
        }
    }
}

