/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.utils.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class ColorDiscIcon
implements Icon {
    private static Color disabledColor = new Color(1.0f, 1.0f, 1.0f, 0.5f);
    private int width;
    private int height;
    private int colorWidth;
    private int colorHeight;
    private int compStartAngle = 90;
    private int extStartAngle = 270;
    private int relativeEndAngle = 180;
    private Color compColor = Color.RED;
    private Color extColor = Color.YELLOW;
    private int inset = 0;

    public ColorDiscIcon(Color inCompColor, Color inExtColor, int iconWidth, int iconHeight, int iconInset) {
        this.setInset(iconInset);
        this.setColor(inCompColor, inExtColor);
        this.setDimensions(iconWidth, iconHeight);
    }

    public void setColor(Color inCompColor, Color inExtColor) {
        this.compColor = inCompColor;
        this.extColor = inExtColor;
    }

    public Color[] getColor() {
        return new Color[]{this.compColor, this.extColor};
    }

    public void setDimensions(int iconWidth, int iconHeight) {
        this.width = iconWidth;
        this.height = iconHeight;
        if (this.inset > 0) {
            this.colorWidth = iconWidth - 2 * this.inset;
            this.colorHeight = iconHeight - 2 * this.inset;
        } else {
            this.colorWidth = iconWidth;
            this.colorHeight = iconHeight;
        }
    }

    public void setInset(int iconInset) {
        this.inset = iconInset;
    }

    @Override
    public int getIconWidth() {
        return this.inset > 0 ? this.width : this.width + 1;
    }

    @Override
    public int getIconHeight() {
        return this.inset > 0 ? this.height : this.height + 1;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int X = x + this.inset;
        int Y = y + this.inset;
        if (this.inset > 0) {
            g.setColor(Color.BLACK);
            g.drawArc(x, y, this.width, this.height, this.compStartAngle, this.relativeEndAngle);
            g.drawArc(x, y, this.width, this.height, this.extStartAngle, this.relativeEndAngle);
        }
        g.setColor(this.compColor);
        g.drawArc(X, Y, this.colorWidth, this.colorHeight, this.compStartAngle, this.relativeEndAngle);
        g.fillArc(X + 1, Y + 1, this.colorWidth - 1, this.colorHeight - 1, this.compStartAngle, this.relativeEndAngle);
        g.setColor(this.extColor);
        g.drawArc(X, Y, this.colorWidth, this.colorHeight, this.extStartAngle, this.relativeEndAngle);
        g.fillArc(X + 1, Y + 1, this.colorWidth - 1, this.colorHeight - 1, this.extStartAngle, this.relativeEndAngle);
        if (!c.isEnabled()) {
            g.setColor(disabledColor);
            g.fillArc(x, y, this.width + 1, this.height + 1, this.compStartAngle, this.relativeEndAngle);
            g.fillArc(x, y, this.width + 1, this.height + 1, this.extStartAngle, this.relativeEndAngle);
        }
    }
}

