/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.utils.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.Icon;

public class ColorWellIcon
implements Icon {
    private static Color disabledColor = new Color(1.0f, 1.0f, 1.0f, 0.5f);
    private int width;
    private int height;
    private int colorWidth;
    private int colorHeight;
    private Color color1 = Color.BLACK;
    private Color color2 = Color.WHITE;
    private int inset = 0;

    public ColorWellIcon(Color iconColor, int iconWidth, int iconHeight, int iconInset) {
        this.setInset(iconInset);
        this.setDimensions(iconWidth, iconHeight);
        this.setColor(iconColor, iconColor);
    }

    public ColorWellIcon(Color iconColor1, Color iconColor2, int iconWidth, int iconHeight, int iconInset) {
        this.setInset(iconInset);
        this.setColor(iconColor1, iconColor2);
        this.setDimensions(iconWidth, iconHeight);
    }

    public void setColor(Color c) {
        this.setColor(c, c);
    }

    public void setColor(Color c1, Color c2) {
        this.color1 = c1;
        this.color2 = c2;
    }

    public Color[] getColor() {
        return new Color[]{this.color1, this.color2};
    }

    public void setDimensions(int iconWidth, int iconHeight) {
        this.width = iconWidth;
        this.height = iconHeight;
        if (this.inset > 0) {
            this.colorWidth = iconWidth - 2 * this.inset;
            this.colorHeight = iconHeight - 2 * this.inset;
        } else {
            this.colorWidth = iconWidth;
            this.colorHeight = iconHeight;
        }
    }

    public void setInset(int iconInset) {
        this.inset = iconInset;
    }

    @Override
    public int getIconWidth() {
        return this.inset > 0 ? this.width : this.width + 1;
    }

    @Override
    public int getIconHeight() {
        return this.inset > 0 ? this.height : this.height + 1;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        int X = x + this.inset;
        int Y = y + this.inset;
        if (this.inset > 0) {
            g.setColor(Color.GRAY);
            g.drawRect(x, y, this.width, this.height);
        }
        if (this.color1.equals(this.color2)) {
            g.setColor(this.color1.darker());
            g.drawRect(X, Y, this.colorWidth, this.colorHeight);
            g.setColor(this.color1);
            g.fillRect(X + 1, Y + 1, this.colorWidth - 1, this.colorHeight - 1);
        } else {
            g.setColor(Color.DARK_GRAY);
            g.drawRect(X, Y, this.colorWidth, this.colorHeight);
            GradientPaint gp = new GradientPaint(X, Y, this.color1, this.colorWidth, Y, this.color2);
            ((Graphics2D)g).setPaint(gp);
            g.fillRect(X + 1, Y + 1, this.colorWidth - 1, this.colorHeight - 1);
        }
        if (!c.isEnabled()) {
            g.setColor(disabledColor);
            g.fillRect(x, y, this.width + 1, this.height + 1);
        }
    }
}

