/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.utils.components;

import java.awt.event.FocusEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;

public class DateTextField
extends JFormattedTextField {
    private static final long serialVersionUID = 1L;
    private SimpleDateFormat format;

    public DateTextField(SimpleDateFormat pattern, int columns) {
        this.format = pattern;
        this.setColumns(columns);
        DateFormatter formatter = new DateFormatter(pattern);
        DefaultFormatterFactory formatFactory = new DefaultFormatterFactory(formatter);
        this.setFormatterFactory(formatFactory);
    }

    public Date getDateValue() {
        try {
            return this.format.parse(this.getText());
        }
        catch (ParseException pe) {
            return null;
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1005 && this.getText().length() == 0) {
            this.setValue(null);
        }
        super.processFocusEvent(e);
    }
}

