/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.utils.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.DefaultColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.scec.vtk.plugins.utils.components.ColorWellIcon;
import org.scec.vtk.plugins.utils.components.ColorWellToggleButton;

public class GradientColorChooser
extends JDialog
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 1L;
    private JColorChooser colorChooser;
    private DefaultColorSelectionModel selectionModel;
    private Color inColor1;
    private Color inColor2;
    private Color outColor1 = Color.WHITE;
    private Color outColor2 = Color.BLACK;
    private JPanel buttonPanel;
    private JLabel gradientLabel;
    private ColorWellIcon gradient;
    private ColorWellToggleButton gradButt_1;
    private ColorWellToggleButton gradButt_2;
    private JButton cancel_button;
    private JButton ok_button;
    protected boolean cancelled;

    public GradientColorChooser(Component owner) {
        super(JOptionPane.getFrameForComponent(owner), "Catalog Color Picker", true);
        this.setDefaultCloseOperation(1);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                GradientColorChooser.this.cancelled = true;
            }
        });
        Container content = this.getContentPane();
        content.setLayout(new BoxLayout(content, 3));
        this.selectionModel = new DefaultColorSelectionModel();
        this.selectionModel.addChangeListener(this);
        this.colorChooser = new JColorChooser(this.selectionModel);
        AbstractColorChooserPanel swatchPanel = this.colorChooser.getChooserPanels()[0];
        swatchPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.ok_button = new JButton("OK");
        this.ok_button.addActionListener(this);
        this.ok_button.setEnabled(false);
        this.getRootPane().setDefaultButton(this.ok_button);
        this.cancel_button = new JButton("Cancel");
        this.cancel_button.addActionListener(this);
        this.gradButt_1 = new ColorWellToggleButton(this.outColor1, 18, 18);
        this.gradButt_1.addActionListener(this);
        this.gradButt_2 = new ColorWellToggleButton(this.outColor2, 18, 18);
        this.gradButt_2.addActionListener(this);
        this.gradient = new ColorWellIcon(this.outColor1, this.outColor2, 140, 10, 0);
        this.gradientLabel = new JLabel(this.gradient);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 2));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.gradButt_1);
        this.buttonPanel.add(Box.createHorizontalStrut(6));
        this.buttonPanel.add(this.gradientLabel);
        this.buttonPanel.add(Box.createHorizontalStrut(6));
        this.buttonPanel.add(this.gradButt_2);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.cancel_button);
        this.buttonPanel.add(this.ok_button);
        content.add(swatchPanel);
        content.add(new JSeparator());
        content.add(this.buttonPanel);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(owner);
    }

    private void processColorToIcons(Color c) {
        boolean b1 = this.gradButt_1.isSelected();
        boolean b2 = this.gradButt_2.isSelected();
        if (b1) {
            this.outColor1 = c;
            this.gradButt_1.setColor(c);
            this.gradient.setColor(c, this.outColor2);
        } else if (b2) {
            this.outColor2 = c;
            this.gradButt_2.setColor(c);
            this.gradient.setColor(this.outColor1, c);
        } else {
            this.outColor1 = c;
            this.outColor2 = c;
            this.gradButt_1.setColor(c);
            this.gradButt_2.setColor(c);
            this.gradient.setColor(c);
        }
        this.gradientLabel.repaint();
    }

    public Color[] getColors(Color c1, Color c2) {
        this.inColor1 = c1;
        this.outColor1 = c1;
        this.gradButt_1.setColor(c1);
        this.inColor2 = c2;
        this.outColor2 = c2;
        this.gradButt_2.setColor(c2);
        this.gradient.setColor(c1, c2);
        this.cancelled = false;
        this.setVisible(true);
        this.gradButt_1.setSelected(false);
        this.gradButt_2.setSelected(false);
        if (this.cancelled) {
            return null;
        }
        return new Color[]{this.outColor1, this.outColor2};
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src == this.selectionModel) {
            Color c = ((DefaultColorSelectionModel)src).getSelectedColor();
            this.processColorToIcons(c);
            this.ok_button.setEnabled(!this.inColor1.equals(this.outColor1) || !this.inColor2.equals(this.outColor2));
            this.buttonPanel.requestFocus();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.gradButt_1) {
            if (this.gradButt_1.isSelected()) {
                this.gradButt_2.setSelected(false);
            }
        } else if (src == this.gradButt_2) {
            if (this.gradButt_2.isSelected()) {
                this.gradButt_1.setSelected(false);
            }
        } else if (src == this.cancel_button) {
            this.cancelled = true;
            this.setVisible(false);
        } else if (src == this.ok_button) {
            this.setVisible(false);
        }
    }
}

