/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.plugins.utils.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.scec.vtk.plugins.utils.DataAccessor;

public class ObjectInfoDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static int a_l = 21;
    private static int a_r = 22;
    private static int f = 0;
    private static int h = 2;
    private static int b = 1;
    private JLabel nameLabel = new JLabel();
    private JTextField nameText = new JTextField();
    private JTextField citText = new JTextField();
    private JTextArea refText = new JTextArea();
    private JTextArea notesText = new JTextArea();
    private JButton ok = new JButton("OK");
    private JButton cancel = new JButton("Cancel");
    private TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "");
    private DataAccessor obj;
    public boolean isOpen = false;
    protected boolean cancelled;

    public ObjectInfoDialog(Component owner) {
        super(JOptionPane.getFrameForComponent(owner), false);
        this.setSize(440, 500);
        this.setDefaultCloseOperation(1);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                ObjectInfoDialog.this.cancelled = true;
            }
        });
        this.setResizable(false);
        this.setTitle("Object Information");
        JPanel textPanel = new JPanel(new GridBagLayout());
        textPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10), this.border));
        this.nameLabel.setText("Display name:");
        JLabel refLabel = new JLabel("Reference:");
        JLabel refHelp = new JLabel("[ full reference ]");
        JLabel citLabel = new JLabel("Citation:");
        JLabel citHelp = new JLabel("[ e.g. Shearer(2003) ]");
        JLabel notesLabel = new JLabel("Additional notes:");
        this.refText.setRows(5);
        this.refText.setLineWrap(true);
        this.refText.setWrapStyleWord(true);
        this.notesText.setLineWrap(true);
        this.notesText.setWrapStyleWord(true);
        JScrollPane refPane = new JScrollPane();
        refPane.setHorizontalScrollBarPolicy(31);
        refPane.setVerticalScrollBarPolicy(22);
        refPane.setViewportView(this.refText);
        JScrollPane notesPane = new JScrollPane();
        notesPane.setHorizontalScrollBarPolicy(31);
        notesPane.setVerticalScrollBarPolicy(22);
        notesPane.setViewportView(this.notesText);
        textPanel.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, a_l, f, new Insets(10, 10, 0, 10), 0, 0));
        textPanel.add((Component)this.nameText, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, a_l, h, new Insets(3, 10, 0, 10), 0, 0));
        textPanel.add((Component)citLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, a_l, f, new Insets(14, 10, 0, 0), 0, 0));
        textPanel.add((Component)citHelp, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, a_r, f, new Insets(14, 0, 0, 10), 0, 0));
        textPanel.add((Component)this.citText, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, a_l, h, new Insets(3, 10, 0, 10), 0, 0));
        textPanel.add((Component)refLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, a_l, f, new Insets(14, 10, 0, 0), 0, 0));
        textPanel.add((Component)refHelp, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, a_r, f, new Insets(14, 0, 0, 10), 0, 0));
        textPanel.add((Component)refPane, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, a_l, h, new Insets(3, 10, 0, 10), 0, 0));
        textPanel.add((Component)notesLabel, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, a_l, f, new Insets(14, 10, 0, 10), 0, 0));
        textPanel.add((Component)notesPane, new GridBagConstraints(0, 7, 2, 1, 1.0, 1.0, a_l, b, new Insets(3, 10, 10, 10), 0, 0));
        JPanel buttonPanel = new JPanel();
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 10, 10, 10));
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.cancel);
        buttonPanel.add(this.ok);
        this.getRootPane().setDefaultButton(this.ok);
        JPanel content = new JPanel(new BorderLayout());
        content.add((Component)textPanel, "Center");
        content.add((Component)buttonPanel, "Last");
        Container c = this.getContentPane();
        c.add(content);
        this.setLocationRelativeTo(owner);
    }

    public void showInfo(DataAccessor object, String panelTitle) {
        this.cancelled = false;
        this.obj = object;
        this.border.setTitle(" " + panelTitle + ": ");
        this.nameText.setEnabled(true);
        this.nameLabel.setEnabled(true);
        this.nameText.setText(this.obj.getDisplayName());
        this.citText.setText(this.obj.getCitation());
        this.refText.setText(this.obj.getReference());
        this.notesText.setText(this.obj.getNotes());
        this.setVisible(true);
        this.isOpen = true;
    }

    public void showInfo(String panelTitle) {
        this.cancelled = false;
        this.obj = null;
        this.border.setTitle(" " + panelTitle + ": ");
        this.nameText.setText("[ multiple files ]");
        this.citText.setText("");
        this.refText.setText("");
        this.notesText.setText("");
        this.nameText.setEnabled(false);
        this.nameLabel.setEnabled(false);
        this.setVisible(true);
        this.isOpen = true;
    }

    public String getDisplayName() {
        return this.nameText.getText();
    }

    public String getCitation() {
        return this.citText.getText();
    }

    public String getReference() {
        return this.refText.getText();
    }

    public String getNotes() {
        return this.notesText.getText();
    }

    public boolean windowWasCancelled() {
        return this.cancelled;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.ok && this.obj != null) {
            this.obj.setDisplayName(this.nameText.getText());
            this.obj.setCitation(this.citText.getText());
            this.obj.setReference(this.refText.getText());
            this.obj.setNotes(this.notesText.getText());
            this.isOpen = false;
        } else if (src == this.cancel) {
            this.cancelled = true;
            this.isOpen = false;
        }
        this.setVisible(false);
    }
}

