/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.politicalBoundaries;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.util.DBFReaderJGeom;
import oracle.spatial.util.ShapefileReaderJGeom;
import org.scec.vtk.drawingTools.DisplayAttributes;
import org.scec.vtk.drawingTools.DrawingTool;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.tools.Transform;
import vtk.vtkActor;
import vtk.vtkCell;
import vtk.vtkCellArray;
import vtk.vtkMapper;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkPolyLine;

public class PoliticalBoundariesFileParser {
    ArrayList<PresetLocationGroup> presetLocationGroups;
    private static String landmarksDataPath;
    private DisplayAttributes displayAttributes;

    public PoliticalBoundariesFileParser() {
        this.parseFiles(landmarksDataPath);
    }

    private void parseFiles(String dataPath) {
        this.presetLocationGroups = new ArrayList();
        File dataDirectory = new File(dataPath);
        if (dataDirectory.isDirectory()) {
            File[] files = dataDirectory.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if ((!files[i].isFile() || !files[i].getName().endsWith(".shp")) && (!files[i].getName().endsWith(".txt") || files[i].getName().equals("CA_Counties.txt") || files[i].getName().contains("popdensity.txt") || files[i].getName().contains("CA_Cities") || files[i].getName().contains("California_Interstates"))) continue;
                PresetLocationGroup group = new PresetLocationGroup();
                group.file = files[i];
                String tempName = files[i].getName();
                tempName = tempName.substring(0, tempName.lastIndexOf("."));
                group.name = tempName = tempName.replace('_', ' ');
                this.presetLocationGroups.add(group);
            }
        }
        this.parseHighwayFiles();
    }

    PresetLocationGroup loadCounties(PresetLocationGroup CACounties) {
        double[] p = null;
        String selectedFile = landmarksDataPath + "CA_Counties.txt";
        File highwaysFile = new File(selectedFile);
        String name = "";
        int arraySize = CACounties.locations.size();
        DrawingTool[] tempCounties = new DrawingTool[arraySize];
        ArrayList points = new ArrayList();
        try {
            BufferedReader inStream = new BufferedReader(new FileReader(highwaysFile));
            String line = inStream.readLine();
            StringTokenizer dataLine = new StringTokenizer(line);
            while (line != null) {
                vtkActor actor = new vtkActor();
                vtkPoints glbPoints = new vtkPoints();
                int ptCount = 0;
                vtkPoints linePts = new vtkPoints();
                vtkCellArray cells = new vtkCellArray();
                dataLine = new StringTokenizer(line);
                String coord = "";
                if (line.contains(":")) {
                    name = dataLine.nextToken(":");
                }
                line = inStream.readLine();
                dataLine = new StringTokenizer(line);
                while (coord != null) {
                    try {
                        String latitude = "";
                        String longitude = "";
                        coord = dataLine.nextToken();
                        coord = coord.substring(0, coord.length() - 3);
                        int i = coord.indexOf(44);
                        longitude = coord.substring(0, i);
                        latitude = coord.substring(i + 1, coord.length() - 1);
                        p = Transform.transformLatLon(Double.parseDouble(latitude), Double.parseDouble(longitude));
                        linePts.InsertNextPoint(p);
                    }
                    catch (Exception e) {
                        // empty catch block
                        break;
                    }
                }
                vtkPolyLine plyLine = new vtkPolyLine();
                plyLine.GetPointIds().SetNumberOfIds(linePts.GetNumberOfPoints());
                int j = 0;
                while ((long)j < linePts.GetNumberOfPoints()) {
                    glbPoints.InsertNextPoint(linePts.GetPoint((long)j));
                    plyLine.GetPointIds().SetId((long)j, (long)ptCount);
                    ++ptCount;
                    ++j;
                }
                cells.InsertNextCell((vtkCell)plyLine);
                vtkPolyData polyData = new vtkPolyData();
                polyData.SetPoints(glbPoints);
                polyData.SetLines(cells);
                vtkPolyDataMapper mapper = new vtkPolyDataMapper();
                mapper.SetInputData(polyData);
                actor.SetMapper((vtkMapper)mapper);
                linePts = new vtkPoints();
                DrawingTool highway = new DrawingTool(p[0], p[1], 0.0, name, this.displayAttributes, Color.WHITE, actor, null);
                highway.setSourceFile(selectedFile);
                highway.setDisplayName(highway.getTextString());
                if (CACounties.locationNames.indexOf(name) != -1) {
                    tempCounties[CACounties.locationNames.indexOf((Object)name)] = highway;
                }
                line = inStream.readLine();
            }
            inStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CACounties.counties = tempCounties;
        return CACounties;
    }

    private PresetLocationGroup parseHighwayFiles() {
        PresetLocationGroup highwayGroup = new PresetLocationGroup();
        Info.getMainGUI();
        String selectedFile = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + "GISLocationPlugin" + File.separator + "California_Interstates.txt";
        File highwaysFile = new File(selectedFile);
        String[] temp = new String[2];
        String nameOfSegment = "";
        vtkCellArray cells = new vtkCellArray();
        vtkActor actor = new vtkActor();
        double[] p = null;
        highwayGroup.locationNames = new ArrayList();
        highwayGroup.locations = new ArrayList();
        ArrayList<vtkPoints> segmentPoints = new ArrayList<vtkPoints>();
        try {
            BufferedReader inStream = new BufferedReader(new FileReader(highwaysFile));
            String line = inStream.readLine();
            StringTokenizer dataLine = new StringTokenizer(line);
            temp[0] = dataLine.nextToken();
            temp[1] = dataLine.nextToken();
            nameOfSegment = temp[1];
            vtkPoints linePts = new vtkPoints();
            while (line != null) {
                dataLine = new StringTokenizer(line);
                temp[0] = dataLine.nextToken();
                temp[1] = dataLine.nextToken();
                if (!temp[0].equals("segment")) {
                    p = Transform.transformLatLon(Double.parseDouble(temp[0]), Double.parseDouble(temp[1]));
                    linePts.InsertNextPoint(p);
                } else if (temp[1].equals(nameOfSegment)) {
                    if (linePts.GetNumberOfPoints() > 0L) {
                        segmentPoints.add(linePts);
                        linePts = new vtkPoints();
                    }
                } else {
                    if (linePts.GetNumberOfPoints() > 0L) {
                        segmentPoints.add(linePts);
                        linePts = new vtkPoints();
                    }
                    vtkPoints globalPoints = new vtkPoints();
                    cells = new vtkCellArray();
                    int pointCount = 0;
                    for (int i = 0; i < segmentPoints.size(); ++i) {
                        vtkPolyLine interstateLine = new vtkPolyLine();
                        interstateLine.GetPointIds().SetNumberOfIds(((vtkPoints)segmentPoints.get(i)).GetNumberOfPoints());
                        int j = 0;
                        while ((long)j < ((vtkPoints)segmentPoints.get(i)).GetNumberOfPoints()) {
                            globalPoints.InsertNextPoint(((vtkPoints)segmentPoints.get(i)).GetPoint((long)j));
                            interstateLine.GetPointIds().SetId((long)j, (long)pointCount++);
                            ++j;
                        }
                        cells.InsertNextCell((vtkCell)interstateLine);
                    }
                    vtkPolyData polyData = new vtkPolyData();
                    polyData.SetPoints(globalPoints);
                    polyData.SetLines(cells);
                    vtkPolyDataMapper mapper = new vtkPolyDataMapper();
                    mapper.SetInputData(polyData);
                    actor = new vtkActor();
                    actor.SetMapper((vtkMapper)mapper);
                    segmentPoints = new ArrayList();
                    DrawingTool highway = new DrawingTool(p[0], p[1], 0.0, nameOfSegment, this.displayAttributes, Color.WHITE, actor, null);
                    highway.setDisplayName(nameOfSegment);
                    highway.setSourceFile(selectedFile);
                    highwayGroup.locations.add(highway);
                    highwayGroup.locationNames.add(nameOfSegment);
                    nameOfSegment = temp[1];
                }
                line = inStream.readLine();
            }
            inStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        highwayGroup.name = "California Interstates";
        this.presetLocationGroups.add(highwayGroup);
        return highwayGroup;
    }

    public ArrayList<String> loadLandmarkGroups(String groupname) {
        ArrayList<String> groupNames = new ArrayList<String>();
        for (int i = 0; i < this.presetLocationGroups.size(); ++i) {
            if (groupname.equals("California")) {
                if (!this.presetLocationGroups.get((int)i).name.contains("CA") && !this.presetLocationGroups.get((int)i).name.contains("California") && !this.presetLocationGroups.get((int)i).name.contains("LA")) continue;
                groupNames.add(this.presetLocationGroups.get((int)i).name);
                continue;
            }
            if (!this.presetLocationGroups.get((int)i).name.contains(groupname)) continue;
            groupNames.add(this.presetLocationGroups.get((int)i).name);
        }
        return groupNames;
    }

    public PresetLocationGroup loadLandmarkData(String groupName) {
        for (int i = 0; i < this.presetLocationGroups.size(); ++i) {
            PresetLocationGroup tempGroup = this.presetLocationGroups.get(i);
            if (!tempGroup.name.equals(groupName)) continue;
            if (tempGroup.name.equals("California Interstates")) {
                tempGroup = this.parseHighwayFiles();
            } else {
                String selectedInputFile = tempGroup.file.getAbsolutePath();
                tempGroup = this.loadBuiltInFiles(selectedInputFile, tempGroup);
                if (tempGroup.name.equals("CA Counties")) {
                    tempGroup = this.loadCounties(tempGroup);
                }
            }
            return tempGroup;
        }
        return new PresetLocationGroup();
    }

    private PresetLocationGroup loadBuiltInFiles(String selectedInputFile, PresetLocationGroup group) {
        String selectedDbfFile = selectedInputFile.replace(".shp", ".dbf");
        File dbf = new File(selectedDbfFile);
        group.locations = new ArrayList();
        group.locationNames = new ArrayList();
        if (dbf.exists()) {
            try {
                DBFReaderJGeom dbfFile = new DBFReaderJGeom(selectedDbfFile);
                int nameColumn = 0;
                int fieldsCount = dbfFile.numFields();
                for (int i = 0; i < fieldsCount; ++i) {
                    String fieldName = dbfFile.getFieldName(i);
                    if (!fieldName.equalsIgnoreCase("Name_1") && !fieldName.equalsIgnoreCase("NameLSAD") && !fieldName.equalsIgnoreCase("FULLNAME")) continue;
                    nameColumn = i;
                }
                ShapefileReaderJGeom shpFile = new ShapefileReaderJGeom(selectedInputFile);
                int pointCount = shpFile.numRecords();
                for (int index = 0; index < pointCount; ++index) {
                    byte[] geometryBytes = shpFile.getGeometryBytes(index);
                    JGeometry point = ShapefileReaderJGeom.getGeometry((byte[])geometryBytes, (int)index);
                    double[] coordinates = point.getPoint();
                    byte[] record = dbfFile.getRecord(index);
                    String textStr = dbfFile.getFieldData(nameColumn, record);
                    DrawingTool tempLocation = new DrawingTool(coordinates[1], coordinates[0], 0.0, textStr, this.displayAttributes, Color.white, null, null);
                    group.locations.add(tempLocation);
                    String name = tempLocation.getTextString().replace('_', ' ');
                    group.locationNames.add(name);
                    tempLocation.setSourceFile(selectedInputFile);
                }
                return group;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            try {
                ShapefileReaderJGeom shpFile = new ShapefileReaderJGeom(selectedInputFile);
                int pointCount = shpFile.numRecords();
                for (int index = 0; index < pointCount; ++index) {
                    byte[] geometryBytes = shpFile.getGeometryBytes(index);
                    JGeometry point = ShapefileReaderJGeom.getGeometry((byte[])geometryBytes, (int)index);
                    double[] coordinates = point.getPoint();
                    DrawingTool tempLocation = new DrawingTool(coordinates[1], coordinates[0], 0.0, "", this.displayAttributes, Color.white, null, null);
                    group.locations.add(tempLocation);
                    String name = tempLocation.getTextString().replace('_', ' ');
                    group.locationNames.add(name);
                    tempLocation.setSourceFile(selectedInputFile);
                }
                return group;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    static {
        Info.getMainGUI();
        landmarksDataPath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + "GISLocationPlugin" + File.separator;
    }

    public class PresetLocationGroup {
        public ArrayList<DrawingTool> locations = null;
        public ArrayList<String> locationNames = null;
        public String name = null;
        public File file = null;
        public DrawingTool[] counties = null;
    }
}

