/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.politicalBoundaries;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.scec.vtk.drawingTools.DrawingTool;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.plugins.utils.components.CheckAllTable;
import org.scec.vtk.plugins.utils.components.ColorButton;
import org.scec.vtk.plugins.utils.components.SingleColorChooser;
import org.scec.vtk.plugins.utils.components.TreeNode;
import org.scec.vtk.politicalBoundaries.PoliticalBoundariesFileParser;
import org.scec.vtk.politicalBoundaries.PoliticalBoundariesRegion;
import org.scec.vtk.tools.Prefs;
import org.scec.vtk.tools.Transform;
import org.scec.vtk.tools.actors.AppendActors;
import vtk.vtkAbstractArray;
import vtk.vtkActor;
import vtk.vtkActor2D;
import vtk.vtkCell;
import vtk.vtkCellArray;
import vtk.vtkConeSource;
import vtk.vtkDataObject;
import vtk.vtkDoubleArray;
import vtk.vtkGlyph3D;
import vtk.vtkLabelPlacementMapper;
import vtk.vtkLine;
import vtk.vtkMapper;
import vtk.vtkMapper2D;
import vtk.vtkPointSetToLabelHierarchy;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkStringArray;

public class PoliticalBoundariesGUI
implements ActionListener {
    private JPanel mainPanel;
    private ArrayList<vtkActor> actorPoliticalBoundariesSegments;
    private ArrayList<String> allSubRegionNames;
    Dimension dMainPanel;
    public static vtkActor mainFocusReginActor = new vtkActor();
    PluginActors pluginActors = new PluginActors();
    AppendActors appendActors = new AppendActors();
    private ColorButton colorDrawingToolsButton;
    private SingleColorChooser colorChooser;
    private static final boolean render_as_poly = false;
    private Object[][] regionTableData = new Object[][]{{Boolean.FALSE, "Africa", Color.white}, {Boolean.FALSE, "Asia", Color.white}, {Boolean.FALSE, "Europe", Color.white}, {Boolean.FALSE, "North America", Color.white}, {Boolean.FALSE, "Oceania", Color.white}, {Boolean.FALSE, "South America", Color.white}, {Boolean.FALSE, "United States", Color.white}};
    private String[][] regionFileNames = new String[][]{{"United States", "us_complete.txt"}, {"Africa", "africa.txt"}, {"Asia", "asia.txt"}, {"Europe", "europe.txt"}, {"North America", "north_america.txt"}, {"Oceania", "oceania.txt"}, {"South America", "south_america.txt"}};
    TreeNode<CheckAllTable> root;
    PoliticalBoundariesFileParser fileParser;
    ArrayList<DrawingTool> allActiveDrawings;
    ArrayList<DrawingTool> countyDrawings;
    MouseAdapter backClickListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            JTable target = ((JTableHeader)e.getSource()).getTable();
            JViewport vp = (JViewport)target.getParent();
            JScrollPane sp = (JScrollPane)vp.getParent();
            CheckAllTable targetTable = (CheckAllTable)sp.getParent();
            TreeNode<CheckAllTable> currentTableNode = PoliticalBoundariesGUI.this.findTableNode(PoliticalBoundariesGUI.this.root, targetTable);
            int col = target.columnAtPoint(e.getPoint());
            if (col == 0) {
                PoliticalBoundariesGUI.this.mainPanel.remove(targetTable);
                ((CheckAllTable)currentTableNode.parent.data).renderTableHeader();
                PoliticalBoundariesGUI.this.mainPanel.add((Component)currentTableNode.parent.data);
                targetTable.clearSearchBar();
                PoliticalBoundariesGUI.this.mainPanel.revalidate();
                PoliticalBoundariesGUI.this.mainPanel.repaint();
            }
        }
    };
    MouseAdapter forwardClickListener = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            JTable target = (JTable)e.getSource();
            JViewport vp = (JViewport)target.getParent();
            JScrollPane sp = (JScrollPane)vp.getParent();
            CheckAllTable targetTable = (CheckAllTable)sp.getParent();
            TreeNode<CheckAllTable> currentTableNode = PoliticalBoundariesGUI.this.findTableNode(PoliticalBoundariesGUI.this.root, targetTable);
            int row = target.getSelectedRow();
            int col = target.columnAtPoint(e.getPoint());
            if (col != 0 && (e.getClickCount() == 2 || col == targetTable.getTable().getColumnCount() - 1)) {
                String subTableName = (String)target.getValueAt(row, 1);
                for (TreeNode<CheckAllTable> treeNode : currentTableNode) {
                    if (!((CheckAllTable)treeNode.data).getTitle().equals(subTableName)) continue;
                    PoliticalBoundariesGUI.this.mainPanel.remove(targetTable);
                    PoliticalBoundariesGUI.this.mainPanel.add((Component)treeNode.data);
                    ((CheckAllTable)treeNode.data).renderTableHeader();
                }
                targetTable.clearSearchBar();
                PoliticalBoundariesGUI.this.mainPanel.revalidate();
                PoliticalBoundariesGUI.this.mainPanel.repaint();
            }
        }
    };
    TableModelListener checkNextTableListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            int row = e.getFirstRow();
            int column = e.getColumn();
            if (column == 0) {
                TableModel model = (TableModel)e.getSource();
                String subTableName = (String)model.getValueAt(row, column + 1);
                Boolean checked = (Boolean)model.getValueAt(row, column);
                TreeNode<CheckAllTable> nextTableNode = PoliticalBoundariesGUI.this.findTableNodeByTitle(PoliticalBoundariesGUI.this.root, subTableName);
                for (int i = 0; i < ((CheckAllTable)nextTableNode.data).getTable().getRowCount(); ++i) {
                    ((CheckAllTable)nextTableNode.data).getTable().setValueAt(checked, i, 0);
                    ((CheckAllTable)nextTableNode.data).getTable().setValueAt(model.getValueAt(row, 2), i, 2);
                }
            }
        }
    };
    TableModelListener subRegionListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            int row = e.getFirstRow();
            int column = e.getColumn();
            if (column == 0) {
                TableModel model = (TableModel)e.getSource();
                String subRegionName = (String)model.getValueAt(row, column + 1);
                Boolean checked = (Boolean)model.getValueAt(row, column);
                Color subRegionColor = (Color)model.getValueAt(row, 2);
                if (PoliticalBoundariesGUI.this.allSubRegionNames.contains(subRegionName)) {
                    vtkActor actor = PoliticalBoundariesGUI.this.actorPoliticalBoundariesSegments.get(PoliticalBoundariesGUI.this.allSubRegionNames.indexOf(subRegionName));
                    if (checked.booleanValue()) {
                        PoliticalBoundariesGUI.this.actorPoliticalBoundariesSegments.get(PoliticalBoundariesGUI.this.allSubRegionNames.indexOf(subRegionName)).GetProperty().SetColor(Info.convertColor(subRegionColor));
                        actor.VisibilityOn();
                    } else {
                        actor.VisibilityOff();
                    }
                }
                Info.getMainGUI();
                MainGUI.updateRenderWindow();
            }
        }
    };

    public PoliticalBoundariesGUI(PluginActors pluginActors) {
        this.pluginActors = pluginActors;
        this.pluginActors.addActor((vtkProp)this.appendActors.getAppendedActor());
        this.createMainPanel();
        this.fileParser = new PoliticalBoundariesFileParser();
        this.allActiveDrawings = new ArrayList();
        this.countyDrawings = new ArrayList();
        this.actorPoliticalBoundariesSegments = new ArrayList();
        this.allSubRegionNames = new ArrayList();
    }

    public void createMainPanel() {
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setName("Political Boundaries");
        this.dMainPanel = new Dimension(Prefs.getPluginWidth(), Prefs.getPluginHeight());
        this.mainPanel.setPreferredSize(this.dMainPanel);
        this.mainPanel.setOpaque(false);
    }

    public JPanel loadAllRegions() {
        String name = "Regions";
        CheckAllTable regionTable = new CheckAllTable(this.regionTableData, name, this.checkNextTableListener);
        this.root = new TreeNode<CheckAllTable>(regionTable);
        this.mainPanel.add((Component)regionTable, "First");
        for (int i = 0; i < this.regionFileNames.length; ++i) {
            ArrayList<String> subRegions = this.loadRegion(this.regionFileNames[i][1], false);
            CheckAllTable subRegionTable = this.setUpTable(subRegions, this.regionFileNames[i][0], this.subRegionListener, new ColorListener(false));
            TreeNode<CheckAllTable> subRegionNode = this.root.addChild(subRegionTable);
            if (subRegionTable.getTitle() == "United States") {
                ((CheckAllTable)subRegionNode.data).getTable().getModel().setValueAt(true, 4, 0);
                this.loadLandmarks("California", subRegionNode);
            }
            if (subRegionTable.getTitle() == "North America") {
                this.loadLandmarks("Mexico", subRegionNode);
            }
            if (subRegionTable.getTitle() == "South America") {
                this.loadLandmarks("Chile", subRegionNode);
            }
            if (subRegionTable.getTitle() == "Oceania") {
                this.loadLandmarks("Indonesia", subRegionNode);
                this.loadLandmarks("New Zealand", subRegionNode);
            }
            if (subRegionTable.getTitle() == "Asia") {
                this.loadLandmarks("Japan", subRegionNode);
            }
            subRegionTable.addControlColumn(this.forwardClickListener, ">", subRegionNode);
        }
        regionTable.addControlColumn(this.forwardClickListener, ">", this.root);
        regionTable.addColorButton(new ColorListener(true));
        return this.mainPanel;
    }

    private void loadLandmarks(String groupName, TreeNode<CheckAllTable> subRegionNode) {
        ArrayList<String> landmarks = this.fileParser.loadLandmarkGroups(groupName);
        CheckAllTable landmarksTable = this.setUpTable(landmarks, groupName, this.checkNextTableListener, new ColorListener(true));
        TreeNode<CheckAllTable> landmarksNode = subRegionNode.addChild(landmarksTable);
        landmarksTable.getTable().getSelectionModel().setSelectionMode(0);
        for (int j = 0; j < landmarks.size(); ++j) {
            PoliticalBoundariesFileParser.PresetLocationGroup landmarkData = this.fileParser.loadLandmarkData(landmarks.get(j));
            CheckAllTable landmarkDataTable = this.setUpTable(landmarkData.locationNames, landmarks.get(j), new LandmarkListener(landmarkData), new ColorListener(false));
            landmarksNode.addChild(landmarkDataTable);
        }
        landmarksTable.addControlColumn(this.forwardClickListener, ">", landmarksNode);
    }

    public CheckAllTable setUpTable(ArrayList<String> tableData, String title, TableModelListener tableListener, ActionListener colorListener) {
        title = title.replace('_', ' ');
        CheckAllTable table = new CheckAllTable(tableData, title, tableListener);
        table.getTable().getTableHeader().addMouseListener(this.backClickListener);
        table.addColorButton(colorListener);
        return table;
    }

    public void addPoliticalBoundaryActors() {
        ArrayList<Object> actorPoliticalBoundariesSegments = new ArrayList();
        actorPoliticalBoundariesSegments = this.getPoliticalBoundaries();
        if (actorPoliticalBoundariesSegments.size() > 0) {
            for (int j = 0; j < actorPoliticalBoundariesSegments.size(); ++j) {
                vtkActor pbActor = (vtkActor)actorPoliticalBoundariesSegments.get(j);
                this.pluginActors.addActor((vtkProp)pbActor);
            }
        }
    }

    public void removeDrawingTool(DrawingTool drawingTool) {
        this.appendActors.getAppendedActor().RemovePart(drawingTool.getActorPin());
        this.appendActors.getAppendedActor().RemovePart(drawingTool.getActorText());
    }

    public DrawingTool addDrawingTool(DrawingTool drawingTool, String text) {
        if (drawingTool.getActorPin() != null) {
            this.appendActors.addToAppendedPolyData(drawingTool.getActorPin());
            if (drawingTool.getActorText() != null) {
                this.appendActors.addToAppendedPolyData(drawingTool.getActorText());
            }
            this.appendActors.getAppendedActor().Modified();
            return drawingTool;
        }
        double[] pt = new double[]{Transform.calcRadius(37.0), 37.0, -120.0};
        if (drawingTool.getTextString() != null) {
            text = drawingTool.getTextString();
            drawingTool.setDisplayName(drawingTool.getTextString());
            pt[0] = pt[0] + drawingTool.getaltitude();
            pt[1] = drawingTool.getLatitude();
            pt[2] = drawingTool.getLongitude();
        }
        vtkStringArray labels = new vtkStringArray();
        labels.SetName("labels");
        labels.SetNumberOfValues(1L);
        labels.SetValue(0L, text);
        vtkPoints labelPoints = new vtkPoints();
        labelPoints.InsertNextPoint(Transform.customTransform(pt));
        vtkPolyData pinPolydata = new vtkPolyData();
        pinPolydata.SetPoints(labelPoints);
        vtkConeSource conePin = new vtkConeSource();
        conePin.SetRadius(3.0);
        conePin.SetHeight(10.0);
        conePin.SetDirection(-Transform.customTransform(pt)[0], -Transform.customTransform(pt)[1], -Transform.customTransform(pt)[2]);
        conePin.SetResolution(10);
        vtkGlyph3D glyphPoints = new vtkGlyph3D();
        glyphPoints.SetInputData((vtkDataObject)pinPolydata);
        glyphPoints.SetSourceConnection(conePin.GetOutputPort());
        vtkPolyDataMapper pm = new vtkPolyDataMapper();
        pm.SetInputConnection(glyphPoints.GetOutputPort());
        vtkActor actorPin = new vtkActor();
        actorPin.SetMapper((vtkMapper)pm);
        vtkPolyData temp = new vtkPolyData();
        temp.SetPoints(labelPoints);
        temp.GetPointData().AddArray((vtkAbstractArray)labels);
        vtkPointSetToLabelHierarchy pointSetToLabelHierarchyFilter = new vtkPointSetToLabelHierarchy();
        pointSetToLabelHierarchyFilter.SetInputData((vtkDataObject)temp);
        pointSetToLabelHierarchyFilter.GetTextProperty().SetJustificationToLeft();
        pointSetToLabelHierarchyFilter.SetLabelArrayName("labels");
        pointSetToLabelHierarchyFilter.Update();
        pointSetToLabelHierarchyFilter.GetTextProperty().SetFontSize(22);
        pointSetToLabelHierarchyFilter.GetTextProperty().SetBold(1);
        vtkLabelPlacementMapper cellMapper = new vtkLabelPlacementMapper();
        cellMapper.SetInputConnection(pointSetToLabelHierarchyFilter.GetOutputPort());
        vtkActor2D actor = new vtkActor2D();
        actor.SetMapper((vtkMapper2D)cellMapper);
        if (drawingTool.getTextString() == null) {
            drawingTool = new DrawingTool(pt[1], pt[2], pt[0], text, null, Color.white, actorPin, actor);
            drawingTool.setDisplayName(text + " -");
        } else {
            drawingTool.setActors(actorPin, actor);
        }
        this.appendActors.addToAppendedPolyData((vtkProp)actorPin);
        this.appendActors.addToAppendedPolyData((vtkProp)actor);
        this.appendActors.getAppendedActor().Modified();
        HashMap<String, String> locData = new HashMap<String, String>();
        locData.put("Lat", String.format("%.1f", pt[1]));
        locData.put("Lon", String.format("%.1f", pt[2]));
        locData.put("Alt", "0");
        locData.put("pinH", "10");
        locData.put("pinR", "3");
        locData.put("fontSize", "15");
        drawingTool.setAttributes(locData);
        return drawingTool;
    }

    public ArrayList<String> loadRegion(String filename, boolean isSelected) {
        PoliticalBoundariesRegion subRegions = new PoliticalBoundariesRegion();
        Info.getMainGUI();
        String sourcePath = String.valueOf(MainGUI.getRootPluginDir()) + File.separator + "PoliticalBoundaries/sourcefiles/" + filename;
        ArrayList boundaries = subRegions.buildBoundaries(sourcePath);
        ArrayList<String> subRegionNames = subRegions.getUSStateNames();
        for (int i = 0; i < subRegionNames.size(); ++i) {
            subRegionNames.set(i, subRegionNames.get(i).replace('_', ' '));
            this.allSubRegionNames.add(subRegionNames.get(i));
        }
        vtkLine line = new vtkLine();
        int countpts = 0;
        for (int j = 0; j < boundaries.size(); ++j) {
            ArrayList vtkBoundaries = (ArrayList)boundaries.get(j);
            vtkDoubleArray latitude = new vtkDoubleArray();
            latitude.SetName("latitude");
            vtkDoubleArray longitude = new vtkDoubleArray();
            longitude.SetName("longitude");
            vtkPoints boundary = new vtkPoints();
            vtkCellArray lines = new vtkCellArray();
            vtkPolyData linesPolyData = new vtkPolyData();
            countpts = 0;
            Object lineSources = null;
            for (int k = 0; k < vtkBoundaries.size(); ++k) {
                vtkPoints segmentpoints = (vtkPoints)vtkBoundaries.get(k);
                int i = 0;
                while ((long)i < segmentpoints.GetNumberOfPoints()) {
                    double[] pt = segmentpoints.GetPoint((long)i);
                    boundary.InsertNextPoint(Transform.transformLatLon(pt[0], pt[1]));
                    ++i;
                }
                i = 0;
                while ((long)i < segmentpoints.GetNumberOfPoints() - 1L) {
                    line.GetPointIds().SetId(0L, (long)countpts);
                    line.GetPointIds().SetId(1L, (long)(countpts + 1));
                    lines.InsertNextCell((vtkCell)line);
                    ++countpts;
                    ++i;
                }
                ++countpts;
            }
            linesPolyData.SetPoints(boundary);
            linesPolyData.SetLines(lines);
            vtkPolyDataMapper mapper = new vtkPolyDataMapper();
            mapper.SetInputData(linesPolyData);
            vtkActor plyOutActor = new vtkActor();
            plyOutActor.SetMapper((vtkMapper)mapper);
            plyOutActor.GetProperty().SetColor(1.0, 1.0, 1.0);
            if (isSelected && j == 4) {
                plyOutActor.VisibilityOn();
                mainFocusReginActor = plyOutActor;
            } else {
                plyOutActor.VisibilityOff();
            }
            this.actorPoliticalBoundariesSegments.add(plyOutActor);
        }
        return subRegionNames;
    }

    private TreeNode<CheckAllTable> findTableNode(TreeNode<CheckAllTable> searchNode, final CheckAllTable targetTable) {
        Comparable<CheckAllTable> searchCriteria = new Comparable<CheckAllTable>(){

            @Override
            public int compareTo(CheckAllTable table) {
                if (table == null) {
                    return 1;
                }
                boolean nodeOk = table == targetTable;
                return nodeOk ? 0 : 1;
            }
        };
        return searchNode.findTreeNode(searchCriteria);
    }

    private TreeNode<CheckAllTable> findTableNodeByTitle(TreeNode<CheckAllTable> searchNode, final String title) {
        Comparable<CheckAllTable> searchCriteria = new Comparable<CheckAllTable>(){

            @Override
            public int compareTo(CheckAllTable table) {
                if (table == null) {
                    return 1;
                }
                boolean nodeOk = table.getTitle() == title;
                return nodeOk ? 0 : 1;
            }
        };
        return searchNode.findTreeNode(searchCriteria);
    }

    private void setVtkColors(JTable targetTable, String tableName, Color color) {
        if (this.allSubRegionNames.contains(tableName)) {
            this.actorPoliticalBoundariesSegments.get(this.allSubRegionNames.indexOf(tableName)).GetProperty().SetColor(Info.convertColor(color));
        }
        if (this.allActiveDrawings != null) {
            for (int k = 0; k < this.allActiveDrawings.size(); ++k) {
                if (!tableName.equals(this.allActiveDrawings.get(k).getTextString())) continue;
                this.allActiveDrawings.get(k).setColor(color);
                this.setColor(this.allActiveDrawings.get(k), color);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public void setColor(DrawingTool dr, Color newColor) {
        vtkActor2D actor = (vtkActor2D)dr.getActorText();
        vtkActor actorPin = (vtkActor)dr.getActorPin();
        double[] color = new double[]{(double)newColor.getRed() / 255.0, (double)newColor.getGreen() / 255.0, (double)newColor.getBlue() / 255.0};
        if (actor != null && actorPin != null) {
            ((vtkPointSetToLabelHierarchy)actor.GetMapper().GetInputAlgorithm()).GetTextProperty().SetColor(color);
            actorPin.GetProperty().SetColor(color);
        } else if (actorPin != null && actor == null) {
            actorPin.GetProperty().SetColor(color);
        }
    }

    public void setVisibility(DrawingTool dr, Integer visible) {
        vtkActor2D actor = (vtkActor2D)dr.getActorText();
        vtkActor actorPin = (vtkActor)dr.getActorPin();
        if (actor != null && actorPin != null) {
            actor.SetVisibility(visible.intValue());
            actorPin.SetVisibility(visible.intValue());
        } else if (actorPin != null && actor == null) {
            actorPin.SetVisibility(visible.intValue());
        }
    }

    public ArrayList<vtkActor> getPoliticalBoundaries() {
        return this.actorPoliticalBoundariesSegments;
    }

    public ArrayList<JCheckBox> getLowerCheckBoxButtons() {
        ArrayList<JCheckBox> lowerCheckBoxButtons = new ArrayList<JCheckBox>();
        return lowerCheckBoxButtons;
    }

    public ArrayList<JCheckBox> getUpperCheckBoxButtons() {
        ArrayList<JCheckBox> upperCheckBoxButtons = new ArrayList<JCheckBox>();
        return upperCheckBoxButtons;
    }

    class ColorListener
    implements ActionListener {
        private PoliticalBoundariesFileParser.PresetLocationGroup landmarkData;
        private boolean colorNextTable = false;

        public ColorListener(PoliticalBoundariesFileParser.PresetLocationGroup landmarkData) {
            this.landmarkData = landmarkData;
        }

        public ColorListener(boolean colorNextTable) {
            this.colorNextTable = colorNextTable;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Color newColor;
            ColorButton target = (ColorButton)e.getSource();
            JPanel jPanel = (JPanel)target.getParent();
            CheckAllTable.ControlPanel controlPanel = (CheckAllTable.ControlPanel)jPanel.getParent();
            CheckAllTable targetPanel = (CheckAllTable)controlPanel.getParent();
            JTable table = targetPanel.getTable();
            if (PoliticalBoundariesGUI.this.colorChooser == null) {
                PoliticalBoundariesGUI.this.colorChooser = new SingleColorChooser(PoliticalBoundariesGUI.this.colorDrawingToolsButton);
            }
            if ((newColor = PoliticalBoundariesGUI.this.colorChooser.getColor()) != null) {
                for (int i = 0; i < table.getModel().getRowCount(); ++i) {
                    if (!table.getSelectionModel().isSelectedIndex(i)) continue;
                    String subTableName = (String)table.getModel().getValueAt(table.convertRowIndexToModel(i), 1);
                    table.getModel().setValueAt(newColor, table.convertRowIndexToModel(i), 2);
                    if (!this.colorNextTable) {
                        PoliticalBoundariesGUI.this.setVtkColors(table, subTableName, newColor);
                        if (!PoliticalBoundariesGUI.this.allSubRegionNames.contains(subTableName)) continue;
                        table.getModel().setValueAt(newColor, table.convertRowIndexToModel(i), 2);
                        continue;
                    }
                    TreeNode<CheckAllTable> nextTableNode = PoliticalBoundariesGUI.this.findTableNodeByTitle(PoliticalBoundariesGUI.this.root, subTableName);
                    for (int j = 0; j < ((CheckAllTable)nextTableNode.data).getTable().getRowCount(); ++j) {
                        String nextTableName = (String)((CheckAllTable)nextTableNode.data).getTable().getModel().getValueAt(j, 1);
                        PoliticalBoundariesGUI.this.setVtkColors(table, nextTableName, newColor);
                        ((CheckAllTable)nextTableNode.data).getTable().getModel().setValueAt(newColor, ((CheckAllTable)nextTableNode.data).getTable().convertRowIndexToModel(j), 2);
                    }
                }
            }
            Info.getMainGUI();
            MainGUI.updateRenderWindow();
        }
    }

    class LandmarkListener
    implements TableModelListener {
        private PoliticalBoundariesFileParser.PresetLocationGroup landmarkData;

        public LandmarkListener(PoliticalBoundariesFileParser.PresetLocationGroup landmarkData) {
            this.landmarkData = landmarkData;
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            int row = e.getFirstRow();
            int column = e.getColumn();
            TableModel model = (TableModel)e.getSource();
            if (column == 0) {
                String landmarkName = (String)model.getValueAt(row, 1);
                Color landmarkColor = (Color)model.getValueAt(row, 2);
                Boolean checked = (Boolean)model.getValueAt(row, column);
                for (int k = 0; k < this.landmarkData.locationNames.size(); ++k) {
                    if (!this.landmarkData.locationNames.get(k).equals(landmarkName)) continue;
                    if (checked.booleanValue()) {
                        if (!PoliticalBoundariesGUI.this.allActiveDrawings.contains(this.landmarkData.locations.get(k))) {
                            PoliticalBoundariesGUI.this.allActiveDrawings.add(PoliticalBoundariesGUI.this.addDrawingTool(this.landmarkData.locations.get(k), ""));
                            if (this.landmarkData.counties != null && this.landmarkData.counties[k] != null) {
                                PoliticalBoundariesGUI.this.countyDrawings.add(PoliticalBoundariesGUI.this.addDrawingTool(this.landmarkData.counties[k], ""));
                            }
                        } else {
                            PoliticalBoundariesGUI.this.setVisibility(this.landmarkData.locations.get(k), 1);
                            if (this.landmarkData.counties != null && this.landmarkData.counties[k] != null) {
                                PoliticalBoundariesGUI.this.setVisibility(this.landmarkData.counties[k], 1);
                            }
                        }
                        PoliticalBoundariesGUI.this.setColor(this.landmarkData.locations.get(k), landmarkColor);
                        break;
                    }
                    if (PoliticalBoundariesGUI.this.allActiveDrawings.contains(this.landmarkData.locations.get(k))) {
                        PoliticalBoundariesGUI.this.setVisibility(PoliticalBoundariesGUI.this.allActiveDrawings.get(PoliticalBoundariesGUI.this.allActiveDrawings.indexOf(this.landmarkData.locations.get(k))), 0);
                    }
                    if (this.landmarkData.counties == null || this.landmarkData.counties[k] == null || !PoliticalBoundariesGUI.this.countyDrawings.contains(this.landmarkData.counties[k])) break;
                    PoliticalBoundariesGUI.this.setVisibility(PoliticalBoundariesGUI.this.countyDrawings.get(PoliticalBoundariesGUI.this.countyDrawings.indexOf(this.landmarkData.counties[k])), 0);
                    break;
                }
            }
            Info.getMainGUI();
            MainGUI.updateRenderWindow();
        }
    }
}

