/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.politicalBoundaries;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import vtk.vtkCellArray;
import vtk.vtkPoints;

public class PoliticalBoundariesRegion {
    vtkPoints currentBoundary = new vtkPoints();
    vtkCellArray vtkVertices = new vtkCellArray();
    Color traceColor1 = new Color(1.0f, 1.0f, 1.0f);
    ArrayList<String> usStateNames = new ArrayList();
    private int groupCount = 0;
    private int numBounds = 0;
    public String[] names;
    public int[] groupSize;
    ArrayList allBounds;
    ArrayList indSegments;
    public static double PIBy2 = 1.5707963267948966;

    public ArrayList buildBoundaries(String usBoundariesPath) {
        this.allBounds = null;
        this.allBounds = new ArrayList();
        this.indSegments = new ArrayList();
        this.usStateNames = new ArrayList();
        ArrayList<Double> lat = new ArrayList<Double>();
        ArrayList<Double> lg = new ArrayList<Double>();
        String[] temp = new String[2];
        String nameOfSegment = "";
        try {
            BufferedReader inStream = new BufferedReader(new FileReader(usBoundariesPath));
            String line = inStream.readLine();
            line = inStream.readLine();
            StringTokenizer dataLine = new StringTokenizer(line);
            temp[0] = dataLine.nextToken();
            temp[1] = dataLine.nextToken();
            if (temp[0].equals("segment")) {
                if (temp[1] != null) {
                    nameOfSegment = temp[1];
                    this.usStateNames.add(nameOfSegment);
                } else {
                    System.out.println("first boundary name missing");
                }
            } else {
                System.out.println("File does not start with \"segment\", see expected format");
            }
            line = inStream.readLine();
            while (line != null) {
                dataLine = new StringTokenizer(line);
                temp[0] = dataLine.nextToken();
                temp[1] = dataLine.nextToken();
                if (temp[0].equals("segment")) {
                    if (lat.size() > 0) {
                        this.addBoundarySegment(lat.size(), lat, lg);
                        lat.clear();
                        lg.clear();
                    } else {
                        System.out.println("segment contains no coordinates");
                    }
                    if (!nameOfSegment.equals(temp[1])) {
                        this.allBounds.add(this.indSegments);
                        ++this.numBounds;
                        nameOfSegment = temp[1];
                        this.usStateNames.add(nameOfSegment);
                        this.indSegments = new ArrayList();
                    }
                } else {
                    lat.add(Double.parseDouble(temp[0]));
                    lg.add(Double.parseDouble(temp[1]));
                }
                line = inStream.readLine();
            }
            if (lat.size() > 0) {
                this.addBoundarySegment(lat.size(), lat, lg);
            } else {
                System.out.println("0 vertices found");
            }
            ++this.numBounds;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        this.allBounds.add(this.indSegments);
        ++this.numBounds;
        return this.allBounds;
    }

    private void addBoundarySegment(int vertices, ArrayList<Double> x, ArrayList<Double> y) {
        float[] Latitude = new float[x.size()];
        float[] Longitude = new float[y.size()];
        this.currentBoundary = new vtkPoints();
        for (int i = 0; i < x.size(); ++i) {
            Latitude[i] = x.get(i).floatValue();
            Longitude[i] = y.get(i).floatValue();
            double[] latlon = new double[]{Latitude[i], Longitude[i], 0.0};
            double[] vertex = latlon;
            this.currentBoundary.InsertNextPoint(vertex);
        }
        this.indSegments.add(this.currentBoundary);
    }

    public ArrayList<String> getUSStateNames() {
        return this.usStateNames;
    }
}

