/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.timeline;

import com.google.common.base.Preconditions;
import com.jogamp.opengl.awt.GLJPanel;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.timeline.CueAnimatorListener;
import org.scec.vtk.timeline.Timeline;
import org.scec.vtk.timeline.render.Renderer;
import vtk.vtkAnimationCue;
import vtk.vtkAnimationScene;

public class CueAnimator {
    private static final boolean D = false;
    private static final boolean JAVA_COMPONENT_RENDER = true;
    private Timeline timeline;
    private vtkAnimationScene scene;
    private vtkAnimationCue cue;
    private CueAnimatorListener listener;
    private boolean rendering;
    private int renderWidth;
    private int renderHeight;
    private File outputFile;
    private Renderer renderer;
    private Dimension origDimensions;
    private Thread playThread;
    private static JFileChooser chooser = new JFileChooser();
    public static final int IMAGE_TYPE = 1;

    public CueAnimator(Timeline timeline, CueAnimatorListener listener) {
        this.timeline = timeline;
        this.listener = listener;
        this.scene = new vtkAnimationScene();
        this.scene.SetStartTime(0.0);
        this.scene.SetEndTime(timeline.getMaxTime());
        this.cue = new vtkAnimationCue();
        this.cue.SetStartTime(0.0);
        this.cue.SetEndTime(timeline.getMaxTime());
        this.cue.AddObserver("StartAnimationCueEvent", (Object)this, "startCue");
        this.cue.AddObserver("EndAnimationCueEvent", (Object)this, "endCue");
        this.cue.AddObserver("AnimationCueTickEvent", (Object)this, "tickCue");
        this.scene.AddCue(this.cue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean render() {
        if (this.renderer == null) {
            JFileChooser jFileChooser = chooser;
            synchronized (jFileChooser) {
                String ext = this.timeline.getRenderer().getExtension();
                chooser.setFileFilter(new FileNameExtensionFilter(ext.toUpperCase() + " File", ext));
                int ret = chooser.showSaveDialog(null);
                if (ret == 0) {
                    Dimension dims;
                    this.outputFile = chooser.getSelectedFile();
                    this.renderer = this.timeline.getRenderer();
                    if (!this.outputFile.getName().toLowerCase().endsWith("." + this.renderer.getExtension())) {
                        this.outputFile = new File(this.outputFile.getParentFile(), this.outputFile.getName() + "." + ext);
                    }
                    this.origDimensions = this.getCurrentSize();
                    if (this.timeline.getRenderDimensions() != null) {
                        dims = this.timeline.getRenderDimensions();
                        this.forceViewerSize(dims);
                    }
                    dims = this.getCurrentSize();
                    this.renderWidth = dims.width;
                    this.renderHeight = dims.height;
                    int count = (int)(this.timeline.getMaxTime() * this.timeline.getFamerate() + 0.5);
                    try {
                        this.renderer.init(this.outputFile, this.renderWidth, this.renderHeight, this.timeline.getFamerate(), count);
                    }
                    catch (IOException e) {
                        ExceptionUtils.throwAsRuntimeException((Throwable)e);
                    }
                } else {
                    return false;
                }
                this.rendering = true;
                this.scene.SetModeToSequence();
                this.scene.SetFrameRate(this.timeline.getFamerate());
                this.playThread = new PlayThread();
                this.playThread.start();
            }
        }
        Preconditions.checkState((boolean)this.rendering);
        Preconditions.checkNotNull((Object)this.outputFile);
        Preconditions.checkNotNull((Object)this.renderer);
        this.origDimensions = this.getCurrentSize();
        if (this.timeline.getRenderDimensions() != null) {
            Dimension dims = this.timeline.getRenderDimensions();
            this.forceViewerSize(dims);
        }
        this.playThread = new PlayThread();
        this.playThread.start();
        return true;
    }

    private void forceViewerSize(Dimension dims) {
        System.out.println("Force resizing viewer to " + dims.width + "x" + dims.height);
        JComponent comp = (JComponent)MainGUI.getRenderWindow().getComponent();
        comp.setSize(dims);
        comp.setPreferredSize(dims);
        comp.setMinimumSize(dims);
        comp.setMaximumSize(dims);
        int newViewerWidth = comp.getWidth();
        int newViewerHeight = comp.getHeight();
        System.out.println("Force resized. New dims: " + newViewerWidth + "x" + newViewerHeight);
    }

    private void clearForcedVeiwerSize(Dimension origDims) {
        JComponent comp = (JComponent)MainGUI.getRenderWindow().getComponent();
        comp.setPreferredSize(null);
        comp.setMinimumSize(null);
        comp.setMaximumSize(null);
        comp.setSize(origDims);
    }

    public boolean isRendering() {
        return this.rendering;
    }

    public boolean isScenePlaying() {
        return this.scene.IsInPlay() == 1;
    }

    public boolean isThreadAlive() {
        return this.playThread != null && this.playThread.isAlive();
    }

    public void play(double time) {
        this.rendering = false;
        if (DataUtils.getPercentDiff((double)time, (double)this.scene.GetEndTime()) < 1.0) {
            time = 0.0;
        }
        this.scene.SetModeToRealTime();
        this.scene.SetAnimationTime(time);
        this.playThread = new PlayThread();
        this.playThread.start();
    }

    public void pause() {
        if (this.isScenePlaying()) {
            this.scene.Stop();
        }
        if (this.rendering && this.timeline.getRenderDimensions() != null && this.origDimensions != null) {
            this.clearForcedVeiwerSize(this.origDimensions);
        }
    }

    public void startCue() {
        this.listener.animationStarted(this.isRendering());
    }

    private Dimension getCurrentSize() {
        JComponent component = (JComponent)MainGUI.getRenderWindow().getComponent();
        int width = component.getWidth();
        int height = component.getHeight();
        return new Dimension(width, height);
    }

    public void tickCue() {
        double animTime = this.cue.GetAnimationTime();
        Runnable run = this.isRendering() ? new TickRenderRunnable(animTime) : new TickPlayRunnable(animTime);
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (Exception e) {
                ExceptionUtils.asRuntimeException((Throwable)e);
            }
        }
    }

    public void endCue() {
        if (this.rendering) {
            try {
                this.renderer.finalize();
            }
            catch (IOException e) {
                ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
            if (this.timeline.getRenderDimensions() != null) {
                this.clearForcedVeiwerSize(this.origDimensions);
            }
        }
        this.listener.animationFinished(this.isRendering());
    }

    private class PlayThread
    extends Thread {
        private PlayThread() {
        }

        @Override
        public void run() {
            if (CueAnimator.this.scene.IsInPlay() == 1) {
                CueAnimator.this.scene.Stop();
            }
            CueAnimator.this.scene.Play();
            CueAnimator.this.scene.Stop();
            System.out.println("Thread done");
            CueAnimator.this.listener.animationPaused(CueAnimator.this.isRendering());
        }
    }

    private class TickRenderRunnable
    implements Runnable {
        private double animTime;

        public TickRenderRunnable(double animTime) {
            this.animTime = animTime;
        }

        @Override
        public void run() {
            CueAnimator.this.timeline.activateTime(this.animTime);
            Dimension dims = CueAnimator.this.getCurrentSize();
            Preconditions.checkState((dims.width == CueAnimator.this.renderWidth && dims.height == CueAnimator.this.renderHeight ? 1 : 0) != 0, (Object)"Render canvas size changed during render");
            BufferedImage image = new BufferedImage(dims.width, dims.height, 1);
            ((GLJPanel)MainGUI.getRenderWindow().getComponent()).paint(image.getGraphics());
            try {
                CueAnimator.this.renderer.processFrame(image);
            }
            catch (IOException e) {
                ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }
    }

    private class TickPlayRunnable
    implements Runnable {
        private double animTime;

        public TickPlayRunnable(double animTime) {
            this.animTime = animTime;
        }

        @Override
        public void run() {
            CueAnimator.this.timeline.activateTime(this.animTime);
        }
    }
}

