/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.timeline;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.util.ClassUtils;
import org.scec.vtk.plugins.PluginState;
import org.scec.vtk.timeline.KeyFrameChangeListener;

public class KeyFrame
implements Comparable<KeyFrame> {
    private double startTime;
    private PluginState state;
    private List<KeyFrameChangeListener> listeners = new ArrayList<KeyFrameChangeListener>();

    public KeyFrame(double startTime, PluginState state) {
        Preconditions.checkArgument((startTime >= 0.0 ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)state);
        this.startTime = startTime;
        this.state = state;
    }

    protected KeyFrame(double startTime) {
        Preconditions.checkArgument((startTime >= 0.0 ? 1 : 0) != 0);
        this.startTime = startTime;
    }

    public void addKeyFrameChangeListener(KeyFrameChangeListener l) {
        this.listeners.add(l);
    }

    public boolean removeKeyFrameChangeListener(KeyFrameChangeListener l) {
        return this.listeners.remove(l);
    }

    public PluginState getState() {
        return this.state;
    }

    public void load() {
        this.state.load();
    }

    @Override
    public int compareTo(KeyFrame o) {
        return Double.compare(this.startTime, o.startTime);
    }

    public double getStartTime() {
        return this.startTime;
    }

    public void setStartTime(double startTime) {
        Preconditions.checkArgument((startTime >= 0.0 ? 1 : 0) != 0);
        this.startTime = startTime;
        this.fireKeyChangedEvent();
    }

    protected void fireKeyChangedEvent() {
        for (KeyFrameChangeListener l : this.listeners) {
            l.keyChanged(this);
        }
    }

    public KeyFrame duplicate() {
        KeyFrame key = new KeyFrame(this.getStartTime(), this.getState().deepCopy());
        return key;
    }

    public String toString() {
        return ClassUtils.getClassNameWithoutPackage(this.getClass()) + "(" + this.getStartTime() + "s)";
    }
}

