/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.timeline;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.scec.vtk.timeline.KeyFrame;
import org.scec.vtk.timeline.KeyFrameChangeListener;

public class KeyFrameList
implements Iterable<KeyFrame>,
KeyFrameChangeListener {
    private ArrayList<KeyFrame> keys;
    private ArrayList<Double> startTimes;
    private List<KeyFrameChangeListener> listeners = new ArrayList<KeyFrameChangeListener>();

    public KeyFrameList() {
        this.keys = new ArrayList();
        this.startTimes = Lists.newArrayList();
    }

    @Override
    public Iterator<KeyFrame> iterator() {
        return this.keys.iterator();
    }

    public synchronized KeyFrame getCurrentFrame(double time) {
        if (this.keys.isEmpty()) {
            return null;
        }
        this.checkBuildStartTimes();
        int ind = Collections.binarySearch(this.startTimes, time);
        if (ind >= 0) {
            return this.keys.get(ind);
        }
        int insertionPoint = -(ind + 1);
        if (insertionPoint == 0) {
            return null;
        }
        return this.keys.get(insertionPoint - 1);
    }

    public synchronized void addKeyFrame(KeyFrame key) {
        this.checkBuildStartTimes();
        int ind = Collections.binarySearch(this.startTimes, key.getStartTime());
        int index = ind >= 0 ? ind + 1 : -(ind + 1);
        this.keys.add(index, key);
        this.startTimes.add(index, key.getStartTime());
        key.addKeyFrameChangeListener(this);
        this.fireKeyChanged(key);
    }

    public synchronized void removeKeyFrame(KeyFrame key) {
        int index = this.keys.indexOf(key);
        Preconditions.checkState((index >= 0 ? 1 : 0) != 0, (Object)"Keyframe not found");
        this.keys.remove(index);
        if (this.startTimes != null) {
            this.startTimes.remove(index);
        }
        key.removeKeyFrameChangeListener(this);
        this.fireKeyChanged(null);
    }

    public synchronized void clear() {
        this.startTimes = null;
        this.keys.clear();
        for (KeyFrame key : this.keys) {
            key.removeKeyFrameChangeListener(this);
        }
        this.fireKeyChanged(null);
    }

    private void checkBuildStartTimes() {
        if (this.startTimes == null) {
            this.startTimes = new ArrayList();
            Collections.sort(this.keys);
            for (KeyFrame key : this.keys) {
                this.startTimes.add(key.getStartTime());
            }
        }
    }

    @Override
    public synchronized void keyChanged(KeyFrame key) {
        this.startTimes = null;
        this.fireKeyChanged(key);
    }

    public void addKeyFrameChangeListener(KeyFrameChangeListener l) {
        this.listeners.add(l);
    }

    public boolean removeKeyFrameChangeListener(KeyFrameChangeListener l) {
        return this.listeners.remove(l);
    }

    private void fireKeyChanged(KeyFrame key) {
        for (KeyFrameChangeListener l : this.listeners) {
            l.keyChanged(key);
        }
    }

    public KeyFrame getKeyAt(int index) {
        return this.keys.get(index);
    }

    public int size() {
        return this.keys.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

