/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.timeline;

import com.google.common.base.Preconditions;
import org.scec.vtk.plugins.AnimatablePlugin;
import org.scec.vtk.plugins.PluginState;
import org.scec.vtk.timeline.KeyFrame;

public class RangeKeyFrame
extends KeyFrame {
    private double endTime;
    private double curFractionalTime;
    private AnimatablePlugin plugin;

    public RangeKeyFrame(double startTime, double endTime, PluginState state, AnimatablePlugin plugin) {
        super(startTime, state);
        Preconditions.checkArgument((endTime >= 0.0 ? 1 : 0) != 0);
        this.endTime = endTime;
        this.plugin = plugin;
    }

    public double getEndTime() {
        return this.endTime;
    }

    @Override
    public synchronized void setStartTime(double startTime) {
        double duration = this.getDuration();
        this.endTime = startTime + duration;
        super.setStartTime(startTime);
    }

    public double getDuration() {
        return this.getEndTime() - this.getStartTime();
    }

    public synchronized void setDuration(double duration) {
        this.endTime = this.getStartTime() + duration;
        this.fireKeyChangedEvent();
    }

    public double getCurFractionalTime() {
        return this.curFractionalTime;
    }

    void setRangeStarted() {
        this.curFractionalTime = 0.0;
        this.plugin.animationStarted();
    }

    void setRangeEnded() {
        this.curFractionalTime = 1.0;
        this.plugin.animationEnded();
    }

    void setRangeTime(double fractionalTime) {
        this.curFractionalTime = fractionalTime;
        this.plugin.animationTimeChanged(fractionalTime);
    }

    boolean isEnded() {
        return this.curFractionalTime >= 1.0;
    }

    @Override
    public RangeKeyFrame duplicate() {
        RangeKeyFrame key = new RangeKeyFrame(this.getStartTime(), this.getEndTime(), this.getState().deepCopy(), this.plugin);
        return key;
    }

    @Override
    public String toString() {
        return "RangeKeyFrame(" + this.getStartTime() + "-" + this.getEndTime() + "s)";
    }
}

