/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.timeline;

import com.google.common.base.Preconditions;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.Plugin;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.plugins.PluginState;
import org.scec.vtk.plugins.Stateful;
import org.scec.vtk.timeline.AnimationTimeListener;
import org.scec.vtk.timeline.KeyFrame;
import org.scec.vtk.timeline.KeyFrameList;
import org.scec.vtk.timeline.RangeKeyFrame;
import org.scec.vtk.timeline.TimelinePluginChangeListener;
import org.scec.vtk.timeline.TimelinePluginState;
import org.scec.vtk.timeline.VisibilityKeyFrame;
import org.scec.vtk.timeline.camera.CameraAnimator;
import org.scec.vtk.timeline.render.AnimatedGIFRenderer;
import org.scec.vtk.timeline.render.H264Renderer;
import org.scec.vtk.timeline.render.ImageSequenceRenderer;
import org.scec.vtk.timeline.render.MP4JPEGSequenceRenderer;
import org.scec.vtk.timeline.render.MP4PNGSequenceRenderer;
import org.scec.vtk.timeline.render.Renderer;

public class Timeline
implements Stateful {
    private static final boolean D = false;
    private KeyFrameList cameraKeys = new KeyFrameList();
    private CameraAnimator cameraAnim = new CameraAnimator(this.cameraKeys, CameraAnimator.SplineType.CARDINAL);
    public List<Plugin> plugins;
    private List<Boolean> pluginsDisplayed;
    private List<Boolean> pluginsFrozen;
    private List<PluginActors> pluginActors;
    private List<KeyFrameList> pluginKeyFrameLists;
    private List<KeyFrame> currentActivatedKeys;
    private ArrayList<String> pluginLayerIds;
    private List<AnimationTimeListener> timeListeners = new ArrayList<AnimationTimeListener>();
    private List<TimelinePluginChangeListener> pluginChangeListeners;
    private double maxTime = 15.0;
    private double fps = 30.0;
    private Renderer renderer;
    private List<Renderer> availableRenderers;
    private Dimension renderDimensions;
    private boolean isLive = true;
    private TimelinePluginState state;

    public Timeline() {
        this.addAnimationTimeListener(this.cameraAnim);
        this.plugins = new ArrayList<Plugin>();
        this.pluginsDisplayed = new ArrayList<Boolean>();
        this.pluginsFrozen = new ArrayList<Boolean>();
        this.pluginActors = new ArrayList<PluginActors>();
        this.pluginKeyFrameLists = new ArrayList<KeyFrameList>();
        this.currentActivatedKeys = new ArrayList<KeyFrame>();
        this.pluginChangeListeners = new ArrayList<TimelinePluginChangeListener>();
        this.availableRenderers = new ArrayList<Renderer>();
        this.availableRenderers.add(new H264Renderer());
        this.availableRenderers.add(new MP4PNGSequenceRenderer());
        this.availableRenderers.add(new MP4JPEGSequenceRenderer());
        this.availableRenderers.add(ImageSequenceRenderer.getPNG());
        this.availableRenderers.add(ImageSequenceRenderer.getJPEG());
        this.availableRenderers.add(new AnimatedGIFRenderer());
        this.availableRenderers = Collections.unmodifiableList(this.availableRenderers);
        this.renderer = this.availableRenderers.get(0);
    }

    public synchronized void addPlugin(Plugin p, PluginActors actors) {
        Preconditions.checkNotNull((Object)p);
        Preconditions.checkNotNull((Object)actors);
        if (this.isDouble(p).booleanValue()) {
            return;
        }
        this.plugins.add(p);
        System.out.println("****************ADDED PLUGIN: " + p.getMetadata().getName());
        this.pluginsDisplayed.add(true);
        this.pluginsFrozen.add(false);
        this.pluginActors.add(actors);
        this.pluginKeyFrameLists.add(new KeyFrameList());
        this.currentActivatedKeys.add(null);
        this.fireTimelinePluginsChanged();
    }

    public Boolean isDouble(Plugin p) {
        for (int i = 0; i < this.plugins.size(); ++i) {
            if (p != this.plugins.get(i)) continue;
            return true;
        }
        return false;
    }

    public synchronized void removePlugin(Plugin p) {
        int index = this.indexForPlugin(p);
        if (index < 0) {
            return;
        }
        System.out.println("timeline removePlugins index: " + index);
        Preconditions.checkState((index >= 0 ? 1 : 0) != 0, (Object)"Plugin not found in timeline!");
        this.plugins.remove(index);
        this.pluginsDisplayed.remove(index);
        this.pluginsFrozen.remove(index);
        this.pluginActors.remove(index);
        this.pluginKeyFrameLists.remove(index);
        this.currentActivatedKeys.remove(index);
        this.fireTimelinePluginsChanged();
    }

    private int indexForPlugin(Plugin p) {
        return this.plugins.indexOf(p);
    }

    public synchronized void addKeyFrame(Plugin p, KeyFrame key) {
        this.addKeyFrame(this.indexForPlugin(p), key);
    }

    public synchronized void addKeyFrame(int index, KeyFrame key) {
        Preconditions.checkState((index >= 0 && index < this.plugins.size() ? 1 : 0) != 0);
        this.pluginKeyFrameLists.get(index).addKeyFrame(key);
    }

    public synchronized void removeKeyFrame(int index, KeyFrame key) {
        Preconditions.checkState((index >= 0 && index < this.plugins.size() ? 1 : 0) != 0);
        this.pluginKeyFrameLists.get(index).removeKeyFrame(key);
    }

    public synchronized void clearKeys(Plugin plugin) {
        int index = this.indexForPlugin(plugin);
        Preconditions.checkState((index >= 0 && index < this.plugins.size() ? 1 : 0) != 0);
        KeyFrameList keys = this.pluginKeyFrameLists.get(index);
        keys.clear();
    }

    public synchronized void clearCameraKeys() {
        if (this.cameraKeys == null) {
            return;
        }
        this.cameraKeys.clear();
    }

    public synchronized void addCameraKeyFrame(KeyFrame key) {
        this.cameraKeys.addKeyFrame(key);
    }

    public synchronized void removeCameraKeyFrame(KeyFrame key) {
        this.cameraKeys.removeKeyFrame(key);
    }

    public KeyFrameList getCameraKeys() {
        return this.cameraKeys;
    }

    public CameraAnimator.SplineType getCameraSplineType() {
        return this.cameraAnim.getSplineType();
    }

    public synchronized void setCameraSplineType(CameraAnimator.SplineType type) {
        this.cameraAnim.setSplineType(type);
    }

    public synchronized void activateTime(double time) {
        if (time > this.maxTime) {
            time = this.maxTime;
        }
        if (time < 0.0) {
            time = 0.0;
        }
        for (int index = 0; index < this.plugins.size(); ++index) {
            if (this.pluginsFrozen.get(index).booleanValue() || !this.pluginsDisplayed.get(index).booleanValue()) continue;
            KeyFrameList keys = this.pluginKeyFrameLists.get(index);
            KeyFrame cur = this.currentActivatedKeys.get(index);
            KeyFrame newKey = keys.getCurrentFrame(time);
            try {
                boolean currentlyDone;
                RangeKeyFrame range;
                if (newKey != cur) {
                    if (cur instanceof RangeKeyFrame && !(range = (RangeKeyFrame)cur).isEnded()) {
                        range.setRangeEnded();
                    }
                    if (newKey != null) {
                        newKey.load();
                        if (!(newKey instanceof VisibilityKeyFrame)) {
                            this.pluginActors.get(index).visibilityOn();
                        }
                    }
                    this.currentActivatedKeys.set(index, newKey);
                }
                if (!(newKey instanceof RangeKeyFrame)) continue;
                range = (RangeKeyFrame)newKey;
                double f = (time - range.getStartTime()) / range.getDuration();
                boolean previouslyEnded = range.isEnded();
                boolean justLoaded = newKey != cur;
                boolean bl = currentlyDone = f >= 1.0;
                if (justLoaded || !currentlyDone && previouslyEnded) {
                    range.setRangeStarted();
                }
                if (currentlyDone) {
                    if (previouslyEnded) continue;
                    range.setRangeTime(f);
                    range.setRangeEnded();
                    continue;
                }
                range.setRangeTime(f);
                continue;
            }
            catch (Exception e) {
                System.err.println("WARNING: Error activating KeyFrame (new: " + String.valueOf(newKey) + ", prev: " + String.valueOf(cur) + ")");
                e.printStackTrace();
            }
        }
        this.fireAnimationTimeChanged(time);
        if (this.isLive) {
            MainGUI.updateRenderWindow();
        }
    }

    public void setDisplayed(Plugin plugin, boolean displayed) {
        this.setDisplayed(this.indexForPlugin(plugin), displayed);
    }

    public synchronized void setDisplayed(int index, boolean displayed) {
        Preconditions.checkState((index >= 0 && index < this.plugins.size() ? 1 : 0) != 0);
        this.pluginsDisplayed.set(index, displayed);
        this.currentActivatedKeys.set(index, null);
        if (displayed) {
            this.pluginActors.get(index).visibilityOn();
        } else {
            this.pluginActors.get(index).visibilityOff();
        }
        MainGUI.updateRenderWindow();
    }

    public boolean isDisplayed(Plugin plugin) {
        return this.isDisplayed(this.indexForPlugin(plugin));
    }

    public boolean isDisplayed(int index) {
        Preconditions.checkState((index >= 0 && index < this.plugins.size() ? 1 : 0) != 0);
        return this.pluginsDisplayed.get(index);
    }

    public void setFrozen(Plugin plugin, boolean frozen) {
        this.setFrozen(this.indexForPlugin(plugin), frozen);
    }

    public synchronized void setFrozen(int index, boolean frozen) {
        Preconditions.checkState((index >= 0 && index < this.plugins.size() ? 1 : 0) != 0);
        this.pluginsFrozen.set(index, frozen);
    }

    public boolean isFrozen(Plugin plugin) {
        return this.isFrozen(this.indexForPlugin(plugin));
    }

    public boolean isFrozen(int index) {
        Preconditions.checkState((index >= 0 && index < this.plugins.size() ? 1 : 0) != 0);
        return this.pluginsFrozen.get(index);
    }

    public void setLive(boolean isLive) {
        this.isLive = isLive;
    }

    public boolean isLive() {
        return this.isLive;
    }

    public void setRenderDimensions(Dimension renderDimensions) {
        this.renderDimensions = renderDimensions;
    }

    public Dimension getRenderDimensions() {
        return this.renderDimensions;
    }

    public int getNumPlugins() {
        return this.plugins.size();
    }

    public Plugin getPluginAt(int index) {
        return this.plugins.get(index);
    }

    public Plugin getPluginWith(String id) {
        for (int i = 0; i < this.plugins.size(); ++i) {
            if (!this.plugins.get(i).getId().equals(id)) continue;
            return this.plugins.get(i);
        }
        return null;
    }

    public void saveLayerIDs(ArrayList<String> pluginLayerIds) {
        this.pluginLayerIds = pluginLayerIds;
    }

    public ArrayList<String> getLayerIDs() {
        return this.pluginLayerIds;
    }

    public KeyFrameList getKeysForPlugin(int index) {
        return this.pluginKeyFrameLists.get(index);
    }

    public PluginActors getActorsForPlugin(Plugin plugin) {
        return this.getActorsForPlugin(this.indexForPlugin(plugin));
    }

    public PluginActors getActorsForPlugin(int index) {
        return this.pluginActors.get(index);
    }

    public void addAnimationTimeListener(AnimationTimeListener l) {
        this.timeListeners.add(l);
    }

    public boolean removeAnimationTimeListener(AnimationTimeListener l) {
        return this.timeListeners.remove(l);
    }

    private void fireAnimationTimeChanged(double time) {
        for (AnimationTimeListener l : this.timeListeners) {
            l.animationTimeChanged(time);
        }
    }

    public void addTimelinePluginChangeListener(TimelinePluginChangeListener l) {
        this.pluginChangeListeners.add(l);
    }

    public boolean removeTimelinePluginChangeListener(TimelinePluginChangeListener l) {
        return this.pluginChangeListeners.remove(l);
    }

    private void fireTimelinePluginsChanged() {
        for (TimelinePluginChangeListener l : this.pluginChangeListeners) {
            l.timelinePluginsChanged();
        }
    }

    public double getMaxTime() {
        return this.maxTime;
    }

    public synchronized void setMaxTime(double maxTime) {
        this.maxTime = maxTime;
        for (AnimationTimeListener l : this.timeListeners) {
            l.animationBoundsChanged(maxTime);
        }
    }

    public double getFamerate() {
        return this.fps;
    }

    public void setFramerate(double fps) {
        Preconditions.checkState((fps > 0.0 ? 1 : 0) != 0);
        this.fps = fps;
    }

    public void setRenderer(Renderer renderer) {
        Preconditions.checkState((boolean)this.availableRenderers.contains(renderer), (String)"Unknown renderer: %s", (Object)renderer);
        this.renderer = renderer;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public List<Renderer> getAvailableRenderers() {
        return this.availableRenderers;
    }

    @Override
    public PluginState getState() {
        if (this.state == null) {
            this.state = new TimelinePluginState(this);
        }
        return this.state;
    }
}

