/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.timeline;

import java.util.ArrayList;
import java.util.Iterator;
import org.dom4j.Element;
import org.scec.vtk.plugins.AnimatablePlugin;
import org.scec.vtk.plugins.Plugin;
import org.scec.vtk.plugins.PluginState;
import org.scec.vtk.plugins.StatefulPlugin;
import org.scec.vtk.timeline.KeyFrame;
import org.scec.vtk.timeline.KeyFrameList;
import org.scec.vtk.timeline.RangeKeyFrame;
import org.scec.vtk.timeline.Timeline;
import org.scec.vtk.timeline.VisibilityKeyFrame;
import org.scec.vtk.timeline.camera.CameraAnimator;
import org.scec.vtk.timeline.camera.CameraKeyFrame;
import vtk.vtkCamera;

public class TimelinePluginState
implements PluginState {
    private Timeline parent;
    ArrayList<String> pluginLayerId;
    ArrayList<ArrayList<PluginState>> pluginStateArray;
    ArrayList<ArrayList<Double>> startTimeArray;
    ArrayList<ArrayList<Double>> endTimeArray;
    ArrayList<ArrayList<Double>> durationArray;
    int numPlugins;
    private KeyFrameList cameraKeyArray;
    private ArrayList<CameraKeyFrame> cameraAtKeyframe;
    private ArrayList<Double> cameraTimeAtKeyframe;
    private ArrayList<Boolean> pluginIsFrozen;
    private ArrayList<Boolean> pluginIsDisplayed;
    private double frameRate;
    private double totalAnimationDuration;
    private String splineIndex;
    private ArrayList<ArrayList<Boolean>> visibilityArray;
    private ArrayList<ArrayList<String>> keyFrameTypeArray;

    public TimelinePluginState(Timeline timeline) {
        this.parent = timeline;
        this.pluginLayerId = new ArrayList();
        this.pluginStateArray = new ArrayList();
        this.startTimeArray = new ArrayList();
        this.cameraAtKeyframe = new ArrayList();
        this.cameraTimeAtKeyframe = new ArrayList();
        this.endTimeArray = new ArrayList();
        this.durationArray = new ArrayList();
        this.visibilityArray = new ArrayList();
        this.keyFrameTypeArray = new ArrayList();
        this.pluginIsDisplayed = new ArrayList();
        this.pluginIsFrozen = new ArrayList();
        this.frameRate = 0.0;
        this.numPlugins = 0;
        this.totalAnimationDuration = 0.0;
        this.splineIndex = "";
    }

    @Override
    public void load() {
        this.parent.setMaxTime(this.totalAnimationDuration);
        this.parent.setCameraSplineType(CameraAnimator.SplineType.valueOf(this.splineIndex));
        for (int i = 0; i < this.pluginLayerId.size(); ++i) {
            System.out.println("pluginLayerid: " + this.pluginLayerId.get(i) + " should be equivalent to: " + this.parent.getPluginWith(this.pluginLayerId.get(i)).getId());
            Plugin plugin = this.parent.getPluginWith(this.pluginLayerId.get(i));
            this.parent.setDisplayed(plugin, (boolean)this.pluginIsDisplayed.get(i));
            this.parent.setFrozen(plugin, (boolean)this.pluginIsFrozen.get(i));
        }
        this.parent.saveLayerIDs(this.pluginLayerId);
    }

    @Override
    public void toXML(Element stateEl) {
        this.copyLatestDetials();
        this.createElement(stateEl);
    }

    private void createElement(Element stateEl) {
        Element timeLinePropertyElement = stateEl.addElement("TimelineProperty");
        timeLinePropertyElement.addElement("frameRate").addText(Double.toString(this.frameRate));
        timeLinePropertyElement.addElement("cameraSplineType").addText(this.splineIndex);
        timeLinePropertyElement.addElement("maxTime").addText(Double.toString(this.totalAnimationDuration));
        for (int j = 0; j < this.cameraKeyArray.size(); ++j) {
            Element pluginKeyFrameElement = stateEl.addElement("CameraKeyFrame");
            pluginKeyFrameElement.addElement("index").addText(Integer.toString(j));
            pluginKeyFrameElement.addElement("camPositon").addText(this.cameraAtKeyframe.get(j).getCam().GetPosition()[0] + "," + this.cameraAtKeyframe.get(j).getCam().GetPosition()[1] + "," + this.cameraAtKeyframe.get(j).getCam().GetPosition()[2]);
            pluginKeyFrameElement.addElement("camViewUp").addText(this.cameraAtKeyframe.get(j).getCam().GetViewUp()[0] + "," + this.cameraAtKeyframe.get(j).getCam().GetViewUp()[1] + "," + this.cameraAtKeyframe.get(j).getCam().GetViewUp()[2]);
            pluginKeyFrameElement.addElement("camLookAt").addText(this.cameraAtKeyframe.get(j).getCam().GetFocalPoint()[0] + "," + this.cameraAtKeyframe.get(j).getCam().GetFocalPoint()[1] + "," + this.cameraAtKeyframe.get(j).getCam().GetFocalPoint()[2]);
            pluginKeyFrameElement.addElement("camTime").addText(Double.toString(this.cameraTimeAtKeyframe.get(j)));
            pluginKeyFrameElement.addElement("paused").addText(Boolean.toString(this.cameraAtKeyframe.get(j).isPause()));
        }
        for (int i = 0; i < this.numPlugins; ++i) {
            Element timelineElement = stateEl.addElement("TimelineLayer");
            timelineElement.addElement("pluginIndex").addText(Integer.toString(i));
            System.out.println(this.pluginLayerId.get(i));
            System.out.println(this.parent.getPluginWith(this.pluginLayerId.get(i)).getId());
            timelineElement.addElement("pluginId").addText(this.parent.getPluginWith(this.pluginLayerId.get(i)).getId());
            timelineElement.addElement("isFrozen").addText(Boolean.toString(this.pluginIsFrozen.get(i)));
            timelineElement.addElement("isDisplayed").addText(Boolean.toString(this.pluginIsDisplayed.get(i)));
            timelineElement.addElement("pluginNumKeyFrames").addText(Integer.toString(this.keyFrameTypeArray.get(i).size()));
            for (int j = 0; j < this.keyFrameTypeArray.get(i).size(); ++j) {
                Element pluginKeyFrameElement = timelineElement.addElement("Keyframe");
                pluginKeyFrameElement.addElement("index").addText(Integer.toString(j));
                pluginKeyFrameElement.addElement("startTime").addText(Double.toString(this.startTimeArray.get(i).get(j)));
                pluginKeyFrameElement.addElement("type").addText(this.keyFrameTypeArray.get(i).get(j));
                if (this.keyFrameTypeArray.get(i).get(j).equals("Visibility")) {
                    pluginKeyFrameElement.addElement("visiblity").addText(Boolean.toString(this.visibilityArray.get(i).get(j)));
                    continue;
                }
                if (this.keyFrameTypeArray.get(i).get(j).equals("Range")) {
                    if (this.durationArray.get(i).get(j) > 0.0) {
                        pluginKeyFrameElement.addElement("endTime").addText(Double.toString(this.endTimeArray.get(i).get(j)));
                        pluginKeyFrameElement.addElement("duration").addText(Double.toString(this.durationArray.get(i).get(j)));
                    }
                    this.pluginStateArray.get(i).get(j).load();
                    this.pluginStateArray.get(i).get(j).toXML(pluginKeyFrameElement);
                    continue;
                }
                this.pluginStateArray.get(i).get(j).load();
                this.pluginStateArray.get(i).get(j).toXML(pluginKeyFrameElement);
            }
        }
    }

    @Override
    public void fromXML(Element stateEl) {
        Element eSub;
        this.pluginLayerId.clear();
        this.pluginStateArray.clear();
        this.startTimeArray.clear();
        this.cameraAtKeyframe.clear();
        this.cameraTimeAtKeyframe.clear();
        this.endTimeArray.clear();
        this.durationArray.clear();
        this.visibilityArray.clear();
        this.keyFrameTypeArray.clear();
        this.pluginIsDisplayed.clear();
        this.pluginIsFrozen.clear();
        this.frameRate = 0.0;
        this.numPlugins = 0;
        this.totalAnimationDuration = 0.0;
        this.splineIndex = "";
        Iterator i = stateEl.elementIterator("TimelineProperty");
        while (i.hasNext()) {
            eSub = (Element)i.next();
            this.frameRate = Double.parseDouble(eSub.elementText("frameRate"));
            this.splineIndex = eSub.elementText("cameraSplineType");
            this.totalAnimationDuration = Double.parseDouble(eSub.elementText("maxTime"));
        }
        Iterator j = stateEl.elementIterator("CameraKeyFrame");
        while (j.hasNext()) {
            eSub = (Element)j.next();
            vtkCamera cam = new vtkCamera();
            String[] pos = eSub.elementText("camPositon").split(",");
            cam.SetPosition(Double.parseDouble(pos[0]), Double.parseDouble(pos[1]), Double.parseDouble(pos[2]));
            String[] viewUp = eSub.elementText("camViewUp").split(",");
            cam.SetViewUp(Double.parseDouble(viewUp[0]), Double.parseDouble(viewUp[1]), Double.parseDouble(viewUp[2]));
            String[] focalPoint = eSub.elementText("camLookAt").split(",");
            cam.SetFocalPoint(Double.parseDouble(focalPoint[0]), Double.parseDouble(focalPoint[1]), Double.parseDouble(focalPoint[2]));
            CameraKeyFrame key = new CameraKeyFrame(Double.parseDouble(eSub.elementText("camTime")), cam, Boolean.parseBoolean(eSub.elementText("paused")));
            this.parent.addCameraKeyFrame(key);
        }
        this.numPlugins = 0;
        i = stateEl.elementIterator("TimelineLayer");
        while (i.hasNext()) {
            Element e = (Element)i.next();
            this.pluginLayerId.add(e.elementText("pluginId"));
            System.out.println("LayerID: " + this.pluginLayerId.get(this.numPlugins));
            Plugin plugin = this.parent.getPluginWith(this.pluginLayerId.get(this.numPlugins));
            this.pluginIsDisplayed.add(Boolean.parseBoolean(e.elementText("isDisplayed")));
            this.pluginIsFrozen.add(Boolean.parseBoolean(e.elementText("isFrozen")));
            int keyFrameListSize = Integer.parseInt(e.elementText("pluginNumKeyFrames"));
            ArrayList<PluginState> pluginStateAtKeyframe = new ArrayList<PluginState>();
            ArrayList<Double> startTimeAtKeyframe = new ArrayList<Double>();
            ArrayList<Double> endTimeAtKeyframe = new ArrayList<Double>();
            ArrayList<Double> durationAtKeyframe = new ArrayList<Double>();
            ArrayList visibilityAtKeyframe = new ArrayList();
            ArrayList<String> typeOfKeyFrame = new ArrayList<String>();
            Iterator j2 = e.elementIterator("Keyframe");
            while (j2.hasNext()) {
                Element eSub2 = (Element)j2.next();
                startTimeAtKeyframe.add(Double.parseDouble(eSub2.elementText("startTime")));
                typeOfKeyFrame.add(eSub2.elementText("type"));
                if (eSub2.elementText("type").equals("Visibility")) {
                    VisibilityKeyFrame key = new VisibilityKeyFrame(Double.parseDouble(eSub2.elementText("startTime")), this.parent.getActorsForPlugin(plugin), Boolean.parseBoolean(eSub2.elementText("visiblity")));
                    this.parent.addKeyFrame(this.parent.getPluginAt(this.numPlugins), (KeyFrame)key);
                }
                if (eSub2.elementText("type").equals("Range")) {
                    double duration = Double.parseDouble(eSub2.elementText("duration"));
                    if (duration < 0.0) {
                        return;
                    }
                    if (duration == 0.0) {
                        pluginStateAtKeyframe.add(this.loadAndCreateStateKeyFrame(eSub2, plugin));
                    } else {
                        endTimeAtKeyframe.add(Double.parseDouble(eSub2.elementText("endTime")));
                        durationAtKeyframe.add(Double.parseDouble(eSub2.elementText("duration")));
                        PluginState state = ((StatefulPlugin)plugin).getState().deepCopy();
                        state.fromXML(eSub2);
                        RangeKeyFrame key = new RangeKeyFrame(Double.parseDouble(eSub2.elementText("startTime")), Double.parseDouble(eSub2.elementText("endTime")), state, (AnimatablePlugin)plugin);
                        this.parent.addKeyFrame(this.parent.getPluginAt(this.numPlugins), (KeyFrame)key);
                        pluginStateAtKeyframe.add(state);
                    }
                }
                if (!eSub2.elementText("type").equals("State")) continue;
                pluginStateAtKeyframe.add(this.loadAndCreateStateKeyFrame(eSub2, plugin));
            }
            this.keyFrameTypeArray.add(typeOfKeyFrame);
            this.pluginStateArray.add(pluginStateAtKeyframe);
            this.startTimeArray.add(startTimeAtKeyframe);
            this.endTimeArray.add(endTimeAtKeyframe);
            this.durationArray.add(durationAtKeyframe);
            this.visibilityArray.add(visibilityAtKeyframe);
            ++this.numPlugins;
        }
    }

    private PluginState loadAndCreateStateKeyFrame(Element eSub, Plugin plugin) {
        Element pluginStateElement = eSub;
        PluginState state = ((StatefulPlugin)plugin).getState().deepCopy();
        state.fromXML(pluginStateElement);
        KeyFrame key = new KeyFrame(Double.parseDouble(eSub.elementText("startTime")), state);
        this.parent.addKeyFrame(this.parent.getPluginAt(this.numPlugins), key);
        return state;
    }

    @Override
    public PluginState deepCopy() {
        TimelinePluginState state = new TimelinePluginState(this.parent);
        state.copyLatestDetials();
        return state;
    }

    private void copyLatestDetials() {
        int i;
        this.pluginLayerId.clear();
        this.pluginStateArray.clear();
        this.startTimeArray.clear();
        this.cameraAtKeyframe.clear();
        this.cameraTimeAtKeyframe.clear();
        this.endTimeArray.clear();
        this.durationArray.clear();
        this.visibilityArray.clear();
        this.keyFrameTypeArray.clear();
        this.pluginIsDisplayed.clear();
        this.pluginIsFrozen.clear();
        this.frameRate = 0.0;
        this.numPlugins = 0;
        this.totalAnimationDuration = 0.0;
        this.splineIndex = "";
        this.cameraKeyArray = this.parent.getCameraKeys();
        for (i = 0; i < this.cameraKeyArray.size(); ++i) {
            this.cameraAtKeyframe.add((CameraKeyFrame)this.cameraKeyArray.getKeyAt(i));
            this.cameraTimeAtKeyframe.add(this.cameraKeyArray.getKeyAt(i).getStartTime());
        }
        this.numPlugins = this.parent.getNumPlugins();
        this.frameRate = this.parent.getFamerate();
        this.totalAnimationDuration = this.parent.getMaxTime();
        this.splineIndex = this.parent.getCameraSplineType().name();
        for (i = 0; i < this.numPlugins; ++i) {
            KeyFrameList keyFrameList = this.parent.getKeysForPlugin(i);
            Plugin plugin = this.parent.getPluginAt(i);
            this.pluginLayerId.add(this.parent.getPluginAt(i).getId());
            this.pluginIsDisplayed.add(this.parent.isDisplayed(i));
            this.pluginIsFrozen.add(this.parent.isFrozen(i));
            ArrayList<PluginState> pluginStateAtKeyframe = new ArrayList<PluginState>();
            ArrayList<Double> startTimeAtKeyframe = new ArrayList<Double>();
            ArrayList<Double> endTimeAtKeyframe = new ArrayList<Double>();
            ArrayList<Double> durationAtKeyframe = new ArrayList<Double>();
            ArrayList<Boolean> visibilityAtKeyframe = new ArrayList<Boolean>();
            ArrayList<String> typeOfKeyFrame = new ArrayList<String>();
            for (int j = 0; j < keyFrameList.size(); ++j) {
                KeyFrame key = keyFrameList.getKeyAt(j);
                startTimeAtKeyframe.add(keyFrameList.getKeyAt(j).getStartTime());
                if (key instanceof VisibilityKeyFrame) {
                    typeOfKeyFrame.add("Visibility");
                    visibilityAtKeyframe.add(((VisibilityKeyFrame)keyFrameList.getKeyAt(j)).isVisible());
                    continue;
                }
                if (key instanceof RangeKeyFrame) {
                    typeOfKeyFrame.add("Range");
                    double duration = ((RangeKeyFrame)key).getDuration();
                    if (duration < 0.0) {
                        return;
                    }
                    if (duration == 0.0) {
                        pluginStateAtKeyframe.add(keyFrameList.getKeyAt(j).getState());
                        continue;
                    }
                    pluginStateAtKeyframe.add(((RangeKeyFrame)key).getState());
                    endTimeAtKeyframe.add(((RangeKeyFrame)key).getEndTime());
                    durationAtKeyframe.add(((RangeKeyFrame)key).getDuration());
                    continue;
                }
                typeOfKeyFrame.add("State");
                pluginStateAtKeyframe.add(key.getState());
            }
            this.keyFrameTypeArray.add(typeOfKeyFrame);
            this.pluginStateArray.add(pluginStateAtKeyframe);
            this.startTimeArray.add(startTimeAtKeyframe);
            this.endTimeArray.add(endTimeAtKeyframe);
            this.durationArray.add(durationAtKeyframe);
            this.visibilityArray.add(visibilityAtKeyframe);
        }
    }
}

