/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.timeline;

import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.timeline.KeyFrame;

public class VisibilityKeyFrame
extends KeyFrame {
    private PluginActors actors;
    private final boolean visibile;

    public VisibilityKeyFrame(double startTime, PluginActors actors, boolean visible) {
        super(startTime);
        this.actors = actors;
        this.visibile = visible;
    }

    @Override
    public void load() {
        if (this.visibile) {
            this.actors.visibilityOn();
        } else {
            this.actors.visibilityOff();
        }
    }

    public boolean isVisible() {
        return this.visibile;
    }

    @Override
    public VisibilityKeyFrame duplicate() {
        VisibilityKeyFrame key = new VisibilityKeyFrame(this.getStartTime(), this.actors, this.isVisible());
        return key;
    }

    @Override
    public String toString() {
        return "VisibilityKeyFrame(" + this.getStartTime() + "s, v=" + this.isVisible() + ")";
    }
}

