/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.timeline.camera;

import javax.swing.SwingUtilities;
import org.opensha.commons.util.ExceptionUtils;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.timeline.AnimationTimeListener;
import org.scec.vtk.timeline.KeyFrameList;
import org.scec.vtk.timeline.camera.CameraSplineCalculator;
import vtk.vtkCamera;
import vtk.vtkCardinalSpline;
import vtk.vtkKochanekSpline;
import vtk.vtkRenderer;
import vtk.vtkSCurveSpline;
import vtk.vtkSpline;

public class CameraAnimator
implements AnimationTimeListener {
    private KeyFrameList keys;
    private CameraSplineCalculator positionSpline;
    private CameraSplineCalculator focalSpline;
    private CameraSplineCalculator upSpline;
    private SplineType type;
    private vtkCamera cam;

    public CameraAnimator(KeyFrameList keys, SplineType type) {
        this.keys = keys;
        this.type = type;
        this.positionSpline = new CameraSplineCalculator(keys, SplineElement.POSITION, type);
        this.focalSpline = new CameraSplineCalculator(keys, SplineElement.FOCAL_POINT, type);
        this.upSpline = new CameraSplineCalculator(keys, SplineElement.VIEW_UP, type);
    }

    public void setSplineType(SplineType type) {
        this.type = type;
        this.positionSpline.setSplineType(type);
        this.focalSpline.setSplineType(type);
        this.upSpline.setSplineType(type);
    }

    public SplineType getSplineType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateTime(double time) {
        KeyFrameList keyFrameList = this.keys;
        synchronized (keyFrameList) {
            if (this.keys.isEmpty()) {
                return;
            }
            double[] position = this.positionSpline.getPoint(time);
            double[] focal = this.focalSpline.getPoint(time);
            double[] up = this.upSpline.getPoint(time);
            if (this.cam == null) {
                this.cam = new vtkCamera();
            }
            this.cam.SetPosition(position[0], position[1], position[2]);
            this.cam.SetFocalPoint(focal[0], focal[1], focal[2]);
            this.cam.SetViewUp(up[0], up[1], up[2]);
            this.cam.OrthogonalizeViewUp();
            CameraAnimator.setActiveCamera(this.cam);
        }
    }

    static void setActiveCamera(final vtkCamera cam) {
        final vtkRenderer renderer = MainGUI.getRenderWindow().getRenderWindow().GetRenderers().GetFirstRenderer();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                renderer.SetActiveCamera(cam);
                renderer.ResetCameraClippingRange();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (Exception e) {
                ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }
    }

    @Override
    public void animationTimeChanged(double curTime) {
        this.activateTime(curTime);
    }

    @Override
    public void animationBoundsChanged(double maxTime) {
    }

    public static enum SplineType {
        CARDINAL("Cardinal"){

            @Override
            vtkSpline instance() {
                return new vtkCardinalSpline();
            }
        }
        ,
        KOCHANEK("Kochanek"){

            @Override
            vtkSpline instance() {
                return new vtkKochanekSpline();
            }
        }
        ,
        S_CURVE("S Curve"){

            @Override
            vtkSpline instance() {
                return new vtkSCurveSpline();
            }
        };

        private String name;

        private SplineType(String name) {
            this.name = name;
        }

        abstract vtkSpline instance();

        public String toString() {
            return this.name;
        }
    }

    public static enum SplineElement {
        POSITION,
        FOCAL_POINT,
        VIEW_UP;

    }
}

