/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.timeline.camera;

import org.scec.vtk.timeline.KeyFrame;
import org.scec.vtk.timeline.camera.CameraAnimator;
import vtk.vtkCamera;

public class CameraKeyFrame
extends KeyFrame {
    private vtkCamera cam = new vtkCamera();
    private boolean pause;

    public CameraKeyFrame(double startTime, vtkCamera c, boolean pause) {
        super(startTime);
        this.cam.SetPosition(c.GetPosition()[0], c.GetPosition()[1], c.GetPosition()[2]);
        this.cam.SetFocalPoint(c.GetFocalPoint()[0], c.GetFocalPoint()[1], c.GetFocalPoint()[2]);
        this.cam.SetViewUp(c.GetViewUp()[0], c.GetViewUp()[1], c.GetViewUp()[2]);
        this.pause = pause;
    }

    public vtkCamera getCam() {
        return this.cam;
    }

    @Override
    public void load() {
        CameraAnimator.setActiveCamera(this.getCam());
    }

    public boolean isPause() {
        return this.pause;
    }

    @Override
    public KeyFrame duplicate() {
        return new CameraKeyFrame(this.getStartTime(), this.getCam(), this.isPause());
    }

    @Override
    public String toString() {
        return "CameraKeyFrame(" + this.getStartTime() + "s, pause=" + this.isPause() + ")";
    }
}

