/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.timeline.camera;

import com.google.common.base.Preconditions;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.scec.vtk.timeline.KeyFrame;
import org.scec.vtk.timeline.KeyFrameChangeListener;
import org.scec.vtk.timeline.KeyFrameList;
import org.scec.vtk.timeline.camera.CameraAnimator;
import org.scec.vtk.timeline.camera.CameraKeyFrame;
import vtk.vtkCamera;
import vtk.vtkSpline;

public class CameraSplineCalculator
implements KeyFrameChangeListener {
    private KeyFrameList keys;
    private CameraAnimator.SplineElement element;
    private CameraAnimator.SplineType type;
    private ArbitrarilyDiscretizedFunc timeMapFunc;
    private vtkSpline splineX;
    private vtkSpline splineY;
    private vtkSpline splineZ;

    public CameraSplineCalculator(KeyFrameList keys, CameraAnimator.SplineElement element, CameraAnimator.SplineType type) {
        this.keys = keys;
        this.element = element;
        this.type = type;
        keys.addKeyFrameChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getPoint(double time) {
        Preconditions.checkArgument((boolean)Double.isFinite(time));
        KeyFrameList keyFrameList = this.keys;
        synchronized (keyFrameList) {
            this.checkBuildSpline();
            if (this.keys.isEmpty()) {
                return null;
            }
            if (this.keys.size() == 1) {
                return this.getPoints((CameraKeyFrame)this.keys.getKeyAt(0));
            }
            double t = time <= this.timeMapFunc.getMinX() ? 0.0 : (time >= this.timeMapFunc.getMaxX() ? this.timeMapFunc.getMaxY() : this.timeMapFunc.getInterpolatedY(time));
            Preconditions.checkState((boolean)Double.isFinite(t));
            return new double[]{this.splineX.Evaluate(t), this.splineY.Evaluate(t), this.splineZ.Evaluate(t)};
        }
    }

    public void setSplineType(CameraAnimator.SplineType type) {
        this.type = type;
        this.clearSpline();
    }

    private void checkBuildSpline() {
        if (this.splineX == null && !this.keys.isEmpty()) {
            this.splineX = this.type.instance();
            this.splineY = this.type.instance();
            this.splineZ = this.type.instance();
            this.timeMapFunc = new ArbitrarilyDiscretizedFunc();
            double splineTime = 0.0;
            double prevTime = this.keys.getKeyAt(0).getStartTime();
            boolean paused = false;
            for (KeyFrame key : this.keys) {
                Preconditions.checkState((boolean)(key instanceof CameraKeyFrame));
                CameraKeyFrame camKey = (CameraKeyFrame)key;
                double time = camKey.getStartTime();
                if (!paused) {
                    splineTime += time - prevTime;
                }
                this.timeMapFunc.set(time, splineTime);
                prevTime = time;
                paused = camKey.isPause();
                double[] pts = this.getPoints(camKey);
                this.splineX.AddPoint(splineTime, pts[0]);
                this.splineY.AddPoint(splineTime, pts[1]);
                this.splineZ.AddPoint(splineTime, pts[2]);
            }
        }
    }

    private double[] getPoints(CameraKeyFrame camKey) {
        vtkCamera cam = camKey.getCam();
        switch (this.element) {
            case POSITION: {
                return cam.GetPosition();
            }
            case FOCAL_POINT: {
                return cam.GetFocalPoint();
            }
            case VIEW_UP: {
                return cam.GetViewUp();
            }
        }
        throw new IllegalStateException("Unknown spline element: " + String.valueOf((Object)this.element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSpline() {
        KeyFrameList keyFrameList = this.keys;
        synchronized (keyFrameList) {
            this.splineX = null;
            this.splineY = null;
            this.splineZ = null;
        }
    }

    @Override
    public void keyChanged(KeyFrame key) {
        this.clearSpline();
    }
}

