/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.timeline.gui;

import com.google.common.base.Stopwatch;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.dom4j.Element;
import org.scec.vtk.plugins.AnimatableChangeListener;
import org.scec.vtk.plugins.AnimatablePlugin;
import org.scec.vtk.plugins.Plugin;
import org.scec.vtk.plugins.PluginActors;
import org.scec.vtk.plugins.PluginInfo;
import org.scec.vtk.plugins.PluginState;
import org.scec.vtk.plugins.StatefulPlugin;
import org.scec.vtk.timeline.KeyFrame;
import org.scec.vtk.timeline.RangeKeyFrame;
import org.scec.vtk.timeline.Timeline;
import org.scec.vtk.timeline.VisibilityKeyFrame;
import org.scec.vtk.timeline.gui.TimelineGUI;

public class GUITests {
    public static void main(String[] args) {
        JFrame frame = new JFrame();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        final Timeline timeline = new Timeline();
        timeline.setLive(false);
        DummyPlugin normal = new DummyPlugin("Normal Plugin");
        DummyAnimatablePlugin animatable = new DummyAnimatablePlugin("Animatable Plugin");
        DummyStatefulPlugin stateful = new DummyStatefulPlugin("Stateful Plugin");
        timeline.addPlugin(normal, new PluginActors());
        timeline.addPlugin(animatable, new PluginActors());
        timeline.addPlugin(stateful, new PluginActors());
        timeline.addKeyFrame(0, (KeyFrame)new VisibilityKeyFrame(0.0, new PluginActors(), true));
        timeline.addKeyFrame(0, (KeyFrame)new VisibilityKeyFrame(5.0, new PluginActors(), false));
        timeline.addKeyFrame(1, (KeyFrame)new RangeKeyFrame(0.0, 3.0, new DummyState(), animatable));
        timeline.addKeyFrame(2, new KeyFrame(1.0, new DummyState()));
        timeline.addKeyFrame(2, new KeyFrame(4.0, new DummyState()));
        TimelineGUI gui = new TimelineGUI(timeline);
        panel.add((Component)gui, "Center");
        boolean play = false;
        long sleepTime = 100L;
        Thread playThread = new Thread(){

            @Override
            public void run() {
                Stopwatch watch = Stopwatch.createStarted();
                while (true) {
                    double time = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
                    double curMax = timeline.getMaxTime();
                    if (curMax > 0.0) {
                        double fract = time / curMax;
                        time = curMax * (fract - Math.floor(fract));
                        System.out.println("Rendering " + time);
                        timeline.activateTime(time);
                    }
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        };
        if (play) {
            playThread.start();
        }
        frame.setContentPane(panel);
        frame.setSize(800, 300);
        frame.setVisible(true);
        gui.updateSize();
        frame.setDefaultCloseOperation(3);
    }

    private static class DummyPlugin
    implements Plugin {
        private PluginInfo metadata = new PluginInfo();

        public DummyPlugin(String name) {
            this.metadata.setName(name);
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public void initialize(PluginInfo metadata, PluginActors pluginActors) {
        }

        @Override
        public void load() throws IOException {
        }

        @Override
        public void activate() {
        }

        @Override
        public void passivate() {
        }

        @Override
        public void unload() {
        }

        @Override
        public PluginInfo getMetadata() {
            return this.metadata;
        }

        @Override
        public PluginActors getPluginActors() {
            return null;
        }
    }

    private static class DummyAnimatablePlugin
    extends DummyStatefulPlugin
    implements AnimatablePlugin {
        public DummyAnimatablePlugin(String name) {
            super(name);
        }

        @Override
        public void animationStarted() {
        }

        @Override
        public void animationEnded() {
        }

        @Override
        public void animationTimeChanged(double fractionalTime) {
        }

        @Override
        public boolean isAnimatable() {
            return true;
        }

        @Override
        public void addAnimatableChangeListener(AnimatableChangeListener l) {
        }

        @Override
        public void removeAnimatableChangeListener(AnimatableChangeListener l) {
        }
    }

    private static class DummyStatefulPlugin
    extends DummyPlugin
    implements StatefulPlugin {
        public DummyStatefulPlugin(String name) {
            super(name);
        }

        @Override
        public PluginState getState() {
            return new DummyState();
        }
    }

    private static class DummyState
    implements PluginState {
        private DummyState() {
        }

        @Override
        public void load() {
        }

        @Override
        public void toXML(Element stateEl) {
        }

        @Override
        public void fromXML(Element stateEl) {
        }

        @Override
        public PluginState deepCopy() {
            return this;
        }
    }
}

