/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.timeline.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.scec.vtk.timeline.KeyFrame;
import org.scec.vtk.timeline.KeyFrameList;
import org.scec.vtk.timeline.RangeKeyFrame;
import org.scec.vtk.timeline.gui.TimelinePanel;

class KeyFrameLabel
extends JLabel
implements Icon {
    private Color fillColor;
    private Color dragColor;
    private Color normalOutlineColor;
    private Color selectedOutlineColor;
    private boolean selected = false;
    private boolean dragging = false;
    private TimelinePanel panel;
    private KeyFrame key;
    private KeyFrameList keys;

    KeyFrameLabel(TimelinePanel panel, KeyFrame key, KeyFrameList keys) {
        this(TimelinePanel.fillColorForKey(key));
        this.panel = panel;
        this.key = key;
        this.keys = keys;
    }

    KeyFrameLabel(Color fillColor) {
        this.setIcon(this);
        this.fillColor = fillColor;
        this.normalOutlineColor = TimelinePanel.keyOutlineColor;
        this.selectedOutlineColor = TimelinePanel.keyOutlineSelectedColor;
        this.dragColor = KeyFrameLabel.saturate(fillColor);
    }

    static Color saturate(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int saturationSteps = 2;
        for (int i = 0; i < saturationSteps; ++i) {
            r = (int)(0.5 * ((double)r + 255.0) + 0.5);
            g = (int)(0.5 * ((double)g + 255.0) + 0.5);
            b = (int)(0.5 * ((double)b + 255.0) + 0.5);
        }
        return new Color(r, g, b);
    }

    public KeyFrame getKeyFrame() {
        return this.key;
    }

    public KeyFrameList getKeyFrameList() {
        return this.keys;
    }

    public void dragTo(double time) {
        double locTime;
        this.dragging = true;
        if (time < 0.0) {
            time = 0.0;
        }
        if (time != (locTime = this.panel.getTime(this.getX() + 3))) {
            int x = this.panel.getPixelX(time) - 3;
            this.setLocation(x, this.getY());
        }
    }

    public void finalizeDrag() {
        this.dragging = false;
        int x = this.getX() + 3;
        double time = this.panel.getTime(x);
        if (time < 0.0) {
            time = 0.0;
        }
        this.key.setStartTime(time);
        System.out.println("Dragged to " + time);
        this.repaint();
    }

    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Color outlineColor = this.selected ? this.selectedOutlineColor : this.normalOutlineColor;
        Color myFillColor = this.dragging ? this.dragColor : this.fillColor;
        int width = 7;
        int height = 15;
        g.setColor(myFillColor);
        g.fillRect(x, y, width, height);
        g.setColor(outlineColor);
        g.drawRect(x, y, width, height);
        if (this.key instanceof RangeKeyFrame) {
            int x2 = x + this.panel.getPixelX(((RangeKeyFrame)this.key).getDuration());
            int middleY = y + 7;
            g.drawLine(x + width, middleY, x2, middleY);
            g.setColor(myFillColor);
            g.fillRect(x2, y, width, height);
            g.setColor(outlineColor);
            g.drawRect(x2, y, width, height);
        }
    }

    @Override
    public int getIconWidth() {
        if (this.key instanceof RangeKeyFrame) {
            return 7 + this.panel.getPixelX(((RangeKeyFrame)this.key).getDuration()) + 1;
        }
        return 8;
    }

    @Override
    public int getIconHeight() {
        return 16;
    }

    public void updateSize() {
        this.setSize(this.getIconWidth(), this.getIconHeight());
    }
}

