/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.timeline.gui;

import java.awt.Color;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.scec.vtk.timeline.AnimationTimeListener;
import org.scec.vtk.timeline.Timeline;
import org.scec.vtk.timeline.render.RenderStatusListener;
import org.scec.vtk.timeline.render.Renderer;

public class TimelineBottomPanel
extends JPanel
implements AnimationTimeListener,
RenderStatusListener {
    private static final int play_max = 100;
    private static final int play_min = 0;
    private JProgressBar playProgress;
    private JProgressBar renderProgress;
    private static final String playbackText = "Playback";
    private static final String renderingText = "Rendering";
    private static final String finalizeText = "Finalizing Render";
    private static final String renderDoneText = "Render Complete";
    private boolean rendering = false;
    private double maxTime;
    private static DecimalFormat timeDF = new DecimalFormat("0.0 s");
    private static DecimalFormat percentDF = new DecimalFormat("0 %");

    public TimelineBottomPanel(Timeline timeline) {
        this.setLayout(new GridLayout(1, 2));
        timeline.addAnimationTimeListener(this);
        for (Renderer r : timeline.getAvailableRenderers()) {
            r.setRenderStatusListener(this);
        }
        this.maxTime = timeline.getMaxTime();
        this.playProgress = TimelineBottomPanel.buildProgress(0, 100, playbackText, Color.BLUE);
        this.renderProgress = TimelineBottomPanel.buildProgress(0, 1, "", Color.RED);
        this.add(this.playProgress);
        this.add(this.renderProgress);
    }

    private static JProgressBar buildProgress(int min, int max, String text, Color color) {
        JProgressBar progress = new JProgressBar(min, max);
        progress.setValue(min);
        progress.setString(text);
        progress.setStringPainted(true);
        progress.setForeground(color);
        return progress;
    }

    @Override
    public void animationTimeChanged(final double curTime) {
        this.runOnEDT(new Runnable(){

            @Override
            public void run() {
                if (!TimelineBottomPanel.this.rendering) {
                    TimelineBottomPanel.this.renderProgress.setString("");
                    TimelineBottomPanel.this.renderProgress.setValue(0);
                }
                double fract = curTime / TimelineBottomPanel.this.maxTime;
                int p = (int)Math.round(fract * 100.0);
                TimelineBottomPanel.this.playProgress.setValue(p);
                TimelineBottomPanel.this.playProgress.setString("Playback: " + timeDF.format(curTime));
            }
        });
    }

    @Override
    public void animationBoundsChanged(double maxTime) {
        this.maxTime = maxTime;
    }

    @Override
    public void frameProcessed(final int index, final int count) {
        this.runOnEDT(new Runnable(){

            @Override
            public void run() {
                TimelineBottomPanel.this.rendering = true;
                int myIndex = index + 1;
                double fract = (double)myIndex / (double)count;
                TimelineBottomPanel.this.renderProgress.setString("Rendering: Frame " + myIndex + "/" + count + " (" + percentDF.format(fract) + ")");
                if (count != TimelineBottomPanel.this.renderProgress.getMaximum()) {
                    TimelineBottomPanel.this.renderProgress.setMaximum(count);
                }
                TimelineBottomPanel.this.renderProgress.setValue(myIndex);
            }
        });
    }

    @Override
    public void finalizeStarted() {
        this.runOnEDT(new Runnable(){

            @Override
            public void run() {
                TimelineBottomPanel.this.rendering = true;
                TimelineBottomPanel.this.renderProgress.setIndeterminate(true);
                TimelineBottomPanel.this.renderProgress.setString(TimelineBottomPanel.finalizeText);
            }
        });
    }

    @Override
    public void finalizeProgress(final int current, final int total) {
        this.runOnEDT(new Runnable(){

            @Override
            public void run() {
                TimelineBottomPanel.this.rendering = true;
                double fract = (double)current / (double)total;
                TimelineBottomPanel.this.renderProgress.setString("Finalizing Render: " + (current + 1) + "/" + total + " (" + percentDF.format(fract) + ")");
                if (total != TimelineBottomPanel.this.renderProgress.getMaximum()) {
                    TimelineBottomPanel.this.renderProgress.setMaximum(total);
                }
                TimelineBottomPanel.this.renderProgress.setValue(current + 1);
            }
        });
    }

    @Override
    public void finalizeCompleted() {
        this.runOnEDT(new Runnable(){

            @Override
            public void run() {
                TimelineBottomPanel.this.rendering = false;
                TimelineBottomPanel.this.renderProgress.setString(TimelineBottomPanel.renderDoneText);
                TimelineBottomPanel.this.renderProgress.setIndeterminate(false);
                TimelineBottomPanel.this.renderProgress.setValue(TimelineBottomPanel.this.renderProgress.getMaximum());
            }
        });
    }

    private void runOnEDT(Runnable run) {
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeLater(run);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

