/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.timeline.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import org.scec.vtk.timeline.Timeline;
import org.scec.vtk.timeline.gui.TimelineBottomPanel;
import org.scec.vtk.timeline.gui.TimelineLeftPanel;
import org.scec.vtk.timeline.gui.TimelinePanel;

public class TimelineGUI
extends JPanel {
    private CombinedPanel combinedPanel;
    private TimelinePanel centerPanel;
    private TimelineLeftPanel leftPanel;

    public TimelineGUI(Timeline timeline) {
        this.centerPanel = new TimelinePanel(timeline);
        this.leftPanel = new TimelineLeftPanel(timeline, this.centerPanel);
        this.combinedPanel = new CombinedPanel(this.leftPanel, this.centerPanel);
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.combinedPanel);
        scroll.setHorizontalScrollBarPolicy(31);
        scroll.setVerticalScrollBarPolicy(22);
        this.updateSize();
        scroll.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TimelineGUI.this.updateSize();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)scroll, "Center");
        this.add((Component)new TimelineBottomPanel(timeline), "South");
    }

    public void updateSize() {
        this.combinedPanel.updateSize();
    }

    public TimelinePanel getTimeLinePanel() {
        return this.centerPanel;
    }

    private class CombinedPanel
    extends JPanel
    implements Scrollable {
        private JScrollPane centerScroll;

        public CombinedPanel(TimelineLeftPanel leftPanel, TimelinePanel centerPanel) {
            this.setLayout(null);
            this.add(leftPanel);
            this.centerScroll = new JScrollPane(centerPanel, 21, 32);
            this.add(this.centerScroll);
            this.updateSize();
        }

        public void updateSize() {
            TimelineGUI.this.leftPanel.updateSize();
            TimelineGUI.this.centerPanel.updateSize();
            if (this.getParent() == null) {
                return;
            }
            int totWidth = this.getParent().getWidth();
            int minHeight = TimelineGUI.this.leftPanel.getPreferredSize().height + this.centerScroll.getHorizontalScrollBar().getHeight();
            int totHeight = this.getParent().getHeight();
            if (totHeight < minHeight) {
                totHeight = minHeight;
            }
            TimelineGUI.this.leftPanel.setBounds(0, 0, 270, totHeight);
            this.centerScroll.setBounds(270, 0, totWidth - 270, totHeight);
            Dimension mySize = new Dimension(totWidth, totHeight);
            this.setPreferredSize(mySize);
            this.setSize(mySize);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return null;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 5;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 30;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

