/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.timeline.gui;

import com.google.common.base.Preconditions;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.opensha.commons.util.ExceptionUtils;
import org.scec.vtk.plugins.AnimatableChangeListener;
import org.scec.vtk.plugins.AnimatablePlugin;
import org.scec.vtk.plugins.Plugin;
import org.scec.vtk.plugins.PluginState;
import org.scec.vtk.plugins.StatefulPlugin;
import org.scec.vtk.plugins.utils.components.FreezeButton;
import org.scec.vtk.plugins.utils.components.PauseButton;
import org.scec.vtk.plugins.utils.components.PlayButton;
import org.scec.vtk.plugins.utils.components.RemoveKeyFramesButton;
import org.scec.vtk.plugins.utils.components.RenderButton;
import org.scec.vtk.plugins.utils.components.ShowButton;
import org.scec.vtk.plugins.utils.components.StopButton;
import org.scec.vtk.timeline.AnimationTimeListener;
import org.scec.vtk.timeline.CueAnimator;
import org.scec.vtk.timeline.CueAnimatorListener;
import org.scec.vtk.timeline.KeyFrame;
import org.scec.vtk.timeline.RangeKeyFrame;
import org.scec.vtk.timeline.Timeline;
import org.scec.vtk.timeline.TimelinePluginChangeListener;
import org.scec.vtk.timeline.VisibilityKeyFrame;
import org.scec.vtk.timeline.camera.CameraAnimator;
import org.scec.vtk.timeline.gui.KeyFrameLabel;
import org.scec.vtk.timeline.gui.TimelinePanel;
import org.scec.vtk.timeline.gui.ViewerSizePanel;
import org.scec.vtk.timeline.render.Renderer;

class TimelineLeftPanel
extends JPanel
implements TimelinePluginChangeListener,
AnimationTimeListener {
    private Timeline timeline;
    private TimelinePanel tp;
    private TimePanel timePanel;
    private CameraPanel cameraPanel;
    private Map<Plugin, PluginPanel> pluginPanels;
    private double curTime;
    public double maxTime;
    public double fps;
    static final int panelWidth = 270;
    private static Dimension iconButtonSize = new Dimension(25, 25);
    private static Dimension keyButtonSize = new Dimension(18, 25);
    private static Dimension settingsButtonSize = new Dimension(90, 25);

    TimelineLeftPanel(Timeline timeline, TimelinePanel tp) {
        this.setLayout(null);
        this.timeline = timeline;
        this.tp = tp;
        this.updateSize();
        timeline.addTimelinePluginChangeListener(this);
        timeline.addAnimationTimeListener(this);
        this.timePanel = new TimePanel();
        this.animationTimeChanged(0.0);
        this.cameraPanel = new CameraPanel();
        this.rebuildPluginPanels();
    }

    private void rebuildPluginPanels() {
        this.removeAll();
        this.revalidate();
        this.add(this.timePanel);
        this.timePanel.setBounds(0, 0, 270, 30);
        this.add(this.cameraPanel);
        this.cameraPanel.setBounds(0, 30, 270, 30);
        if (this.pluginPanels == null) {
            this.pluginPanels = new HashMap<Plugin, PluginPanel>();
        }
        HashSet<PluginPanel> unusedPanels = new HashSet<PluginPanel>(this.pluginPanels.values());
        for (int index = 0; index < this.timeline.getNumPlugins(); ++index) {
            Plugin plugin = this.timeline.getPluginAt(index);
            PluginPanel p = this.pluginPanels.get(plugin);
            if (p == null) {
                p = new PluginPanel(this.timeline.getPluginAt(index));
            } else {
                unusedPanels.remove(p);
            }
            int pluginY = this.tp.yForPluginIndex(index);
            this.add(p);
            p.setBounds(0, pluginY, 270, 30);
        }
        for (PluginPanel unused : unusedPanels) {
            unused.removeListeners();
            Preconditions.checkNotNull((Object)this.pluginPanels.remove(unused.plugin));
        }
        this.updateSize();
        this.repaint();
    }

    void updateSize() {
        int height = 60 + this.timeline.getNumPlugins() * 30;
        Dimension size = new Dimension(270, height);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.setSize(size);
        this.revalidate();
    }

    @Override
    public void timelinePluginsChanged() {
        this.rebuildPluginPanels();
    }

    @Override
    public void animationTimeChanged(double curTime) {
        this.curTime = curTime;
        String label = TimelinePanel.timeMinorLabelFormat.format(curTime);
        this.timePanel.timeLabel.setText("  " + label);
        this.timePanel.timeLabel.repaint();
    }

    @Override
    public void animationBoundsChanged(double maxTime) {
    }

    private static void setButtonSize(JButton button, Dimension size) {
        button.setPreferredSize(size);
        button.setSize(size);
        button.setMaximumSize(size);
        button.setMinimumSize(size);
    }

    private class TimePanel
    extends JPanel
    implements ActionListener,
    CueAnimatorListener {
        private PlayButton playButton;
        private PauseButton pauseButton;
        private StopButton stopButton;
        private RenderButton renderButton;
        private JButton settingsButton;
        private TimelineSettingsPanel settingsPanel;
        private JLabel timeLabel;
        private CueAnimator animator;

        public TimePanel() {
            this.setLayout(new BoxLayout(this, 0));
            this.renderButton = new RenderButton(this, "Render");
            this.add(this.renderButton);
            TimelineLeftPanel.setButtonSize(this.renderButton, iconButtonSize);
            this.playButton = new PlayButton(this, "Play Animation");
            this.add(this.playButton);
            TimelineLeftPanel.setButtonSize(this.playButton, iconButtonSize);
            this.pauseButton = new PauseButton(this, "Pause Animation");
            this.add(this.pauseButton);
            TimelineLeftPanel.setButtonSize(this.pauseButton, iconButtonSize);
            this.stopButton = new StopButton(this, "Stop Animation");
            this.add(this.stopButton);
            TimelineLeftPanel.setButtonSize(this.stopButton, iconButtonSize);
            this.settingsButton = new JButton("Settings");
            this.settingsButton.addActionListener(this);
            this.add(this.settingsButton);
            TimelineLeftPanel.setButtonSize(this.settingsButton, settingsButtonSize);
            this.timeLabel = new JLabel();
            this.add(this.timeLabel);
            final TimePanel parent = this;
            this.timeLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    String timeStr;
                    if (e.getClickCount() == 2 && (timeStr = JOptionPane.showInputDialog(parent, "Go to time", TimelinePanel.timeMinorLabelFormat.format(TimelineLeftPanel.this.curTime).replaceAll("s", ""))) != null) {
                        try {
                            double time = Double.parseDouble(timeStr);
                            TimelineLeftPanel.this.timeline.activateTime(time);
                        }
                        catch (Exception e1) {
                            JOptionPane.showMessageDialog(parent, "Could not parse time: " + timeStr, "Error Parsing Time", 0);
                        }
                    }
                }
            });
            this.setButtonsEnabled();
        }

        private void setButtonsEnabled() {
            if (this.animator == null) {
                this.playButton.setEnabled(true);
                this.renderButton.setEnabled(true);
                this.pauseButton.setEnabled(false);
                this.stopButton.setEnabled(true);
            } else {
                if (this.animator.isRendering()) {
                    this.playButton.setEnabled(false);
                    this.renderButton.setEnabled(!this.animator.isScenePlaying());
                } else {
                    this.playButton.setEnabled(!this.animator.isScenePlaying());
                    this.renderButton.setEnabled(false);
                }
                this.pauseButton.setEnabled(this.animator.isScenePlaying());
                this.stopButton.setEnabled(true);
            }
        }

        private void setButtonsEnabledEDT() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TimePanel.this.setButtonsEnabled();
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.renderButton) {
                if (this.animator != null) {
                    Preconditions.checkState((boolean)this.animator.isRendering());
                } else {
                    this.animator = new CueAnimator(TimelineLeftPanel.this.timeline, this);
                }
                if (!this.animator.render()) {
                    this.animator = null;
                }
            } else if (e.getSource() == this.playButton) {
                if (this.animator == null) {
                    this.animator = new CueAnimator(TimelineLeftPanel.this.timeline, this);
                }
                this.animator.play(TimelineLeftPanel.this.curTime);
                this.pauseButton.requestFocus();
            } else if (e.getSource() == this.pauseButton) {
                Preconditions.checkNotNull((Object)this.animator);
                this.animator.pause();
                this.runWhenStopped(new Runnable(){

                    @Override
                    public void run() {
                        TimePanel.this.setButtonsEnabled();
                    }
                });
                this.playButton.requestFocus();
            } else if (e.getSource() == this.stopButton) {
                if (this.animator != null) {
                    this.animator.pause();
                    this.runWhenStopped(new Runnable(){

                        @Override
                        public void run() {
                            TimePanel.this.animator = null;
                            TimelineLeftPanel.this.timeline.activateTime(0.0);
                            TimePanel.this.setButtonsEnabled();
                        }
                    });
                } else {
                    TimelineLeftPanel.this.timeline.activateTime(0.0);
                    this.setButtonsEnabled();
                }
                this.playButton.requestFocus();
            } else if (e.getSource() == this.settingsButton) {
                if (this.settingsPanel == null) {
                    this.settingsPanel = new TimelineSettingsPanel();
                } else {
                    this.settingsPanel.updateFromTimeline();
                }
                int ret = JOptionPane.showConfirmDialog(this, this.settingsPanel, "Render settings", 2);
                if (ret == 0) {
                    try {
                        this.settingsPanel.updateTimeline();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        JOptionPane.showMessageDialog(this, e1.getMessage(), "Error Updating Settings", 0);
                    }
                }
            }
        }

        private void runWhenStopped(final Runnable run) {
            new Thread(){

                @Override
                public void run() {
                    while (TimePanel.this.animator != null && TimePanel.this.animator.isScenePlaying()) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    try {
                        SwingUtilities.invokeAndWait(run);
                    }
                    catch (Exception e) {
                        ExceptionUtils.throwAsRuntimeException((Throwable)e);
                    }
                }
            }.start();
        }

        @Override
        public void animationStarted(boolean rendering) {
            System.out.println("Started");
            this.setButtonsEnabledEDT();
            this.resetState();
        }

        @Override
        public void animationPaused(boolean rendering) {
            System.out.println("Paused");
            this.setButtonsEnabledEDT();
        }

        @Override
        public void animationFinished(boolean rendering) {
            System.out.println("Finished");
            this.animator = null;
            this.setButtonsEnabledEDT();
            this.resetState();
        }

        public void resetState() {
            for (Plugin plugin : TimelineLeftPanel.this.timeline.plugins) {
                TimelineLeftPanel.this.timeline.setDisplayed(plugin, true);
            }
        }
    }

    private class CameraPanel
    extends JPanel
    implements ActionListener {
        private KeyFrameButton camKeyButton;
        private KeyFrameButton camPauseKeyButton;
        private RemoveKeyFramesButton removeButton;

        public CameraPanel() {
            this.camKeyButton = new KeyFrameButton(TimelinePanel.cameraKeyColor, "Create new camera position KeyFrame");
            this.camPauseKeyButton = new KeyFrameButton(TimelinePanel.cameraKeyPauseColor, "Create new camera pause KeyFrame");
            this.setLayout(new BoxLayout(this, 0));
            this.camKeyButton.addActionListener(this);
            this.add(this.camKeyButton);
            this.camPauseKeyButton.addActionListener(this);
            this.add(this.camPauseKeyButton);
            this.removeButton = new RemoveKeyFramesButton(this, "Remove All KeyFrames");
            this.removeButton.setEnabled(true);
            TimelineLeftPanel.setButtonSize(this.removeButton, iconButtonSize);
            this.add(this.removeButton);
            JLabel label = new JLabel("  Camera");
            this.add(label);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            double time = TimelineLeftPanel.this.tp.getRoundedTime(TimelineLeftPanel.this.curTime);
            if (e.getSource() == this.camKeyButton) {
                TimelineLeftPanel.this.tp.addCameraKey(time, false);
            } else if (e.getSource() == this.camPauseKeyButton) {
                TimelineLeftPanel.this.tp.addCameraKey(time, true);
            } else if (e.getSource() == this.removeButton) {
                TimelineLeftPanel.this.tp.clearCameraKeys();
            }
        }
    }

    private class PluginPanel
    extends JPanel
    implements ActionListener,
    AnimatableChangeListener {
        private Plugin plugin;
        private ShowButton displayButton;
        private Icon displayedIcon;
        private Icon hiddenIcon;
        private FreezeButton freezeButton;
        private Icon frozenIcon;
        private Icon unfrozenIcon;
        private RemoveKeyFramesButton removeButton;
        private KeyFrameButton visiblityOnButton;
        private KeyFrameButton visiblityOffButton;
        private KeyFrameButton normalKeyButton;
        private KeyFrameButton rangeKeyButton;

        public PluginPanel(Plugin plugin) {
            this.visiblityOnButton = new KeyFrameButton(TimelinePanel.visibilityKeyOnColor, "Create new visibility on KeyFrame");
            this.visiblityOffButton = new KeyFrameButton(TimelinePanel.visibilityKeyOffColor, "Create new visibility off KeyFrame");
            this.normalKeyButton = new KeyFrameButton(TimelinePanel.normalKeyColor, "Create normal KeyFrame, only enabled for stateful plugins");
            this.rangeKeyButton = new KeyFrameButton(TimelinePanel.rangeKeyColor, "Create range KeyFrame, only enabled for animatable plugins that are currently configured to display an animation");
            this.setLayout(new BoxLayout(this, 0));
            this.plugin = plugin;
            this.displayButton = new ShowButton(this, "Show/Hide entire plugin");
            this.displayButton.setEnabled(true);
            this.displayedIcon = this.displayButton.getIcon();
            this.hiddenIcon = this.displayButton.getDisabledIcon();
            TimelineLeftPanel.setButtonSize(this.displayButton, iconButtonSize);
            this.add(this.displayButton);
            this.freezeButton = new FreezeButton(this, "Freeze plugin to ignore KeyFrames until unfrozen");
            this.freezeButton.setEnabled(true);
            this.frozenIcon = this.freezeButton.getIcon();
            this.unfrozenIcon = this.freezeButton.getDisabledIcon();
            this.freezeButton.setIcon(this.unfrozenIcon);
            TimelineLeftPanel.setButtonSize(this.freezeButton, iconButtonSize);
            this.add(this.freezeButton);
            this.removeButton = new RemoveKeyFramesButton(this, "Remove All KeyFrames");
            this.removeButton.setEnabled(true);
            TimelineLeftPanel.setButtonSize(this.removeButton, iconButtonSize);
            this.add(this.removeButton);
            this.normalKeyButton.addActionListener(this);
            this.normalKeyButton.setEnabled(false);
            this.add(this.normalKeyButton);
            this.rangeKeyButton.addActionListener(this);
            this.rangeKeyButton.setEnabled(false);
            this.add(this.rangeKeyButton);
            if (plugin instanceof StatefulPlugin) {
                this.normalKeyButton.setEnabled(true);
                if (plugin instanceof AnimatablePlugin) {
                    AnimatablePlugin animPlugin = (AnimatablePlugin)plugin;
                    animPlugin.addAnimatableChangeListener(this);
                    this.animatableChanged(animPlugin, animPlugin.isAnimatable());
                }
            }
            this.visiblityOnButton.addActionListener(this);
            this.add(this.visiblityOnButton);
            this.visiblityOffButton.addActionListener(this);
            this.add(this.visiblityOffButton);
            JLabel label = new JLabel("  " + plugin.getMetadata().getName());
            label.setToolTipText(plugin.getMetadata().getName());
            int buttonsWidth = 4 * TimelineLeftPanel.keyButtonSize.width;
            Dimension labelSize = new Dimension(270 - (buttonsWidth + 5), 30);
            label.setPreferredSize(labelSize);
            label.setMaximumSize(labelSize);
            label.setMinimumSize(labelSize);
            this.add(label);
        }

        @Override
        public synchronized void actionPerformed(ActionEvent e) {
            double time = TimelineLeftPanel.this.tp.getRoundedTime(TimelineLeftPanel.this.curTime);
            if (e.getSource() == this.visiblityOnButton) {
                TimelineLeftPanel.this.tp.addPluginKey(this.plugin, new VisibilityKeyFrame(time, TimelineLeftPanel.this.timeline.getActorsForPlugin(this.plugin), true));
            } else if (e.getSource() == this.visiblityOffButton) {
                TimelineLeftPanel.this.tp.addPluginKey(this.plugin, new VisibilityKeyFrame(time, TimelineLeftPanel.this.timeline.getActorsForPlugin(this.plugin), false));
            } else if (e.getSource() == this.normalKeyButton) {
                Preconditions.checkState((boolean)(this.plugin instanceof StatefulPlugin));
                StatefulPlugin statePlugin = (StatefulPlugin)this.plugin;
                PluginState state = statePlugin.getState().deepCopy();
                TimelineLeftPanel.this.tp.addPluginKey(this.plugin, new KeyFrame(time, state));
            } else if (e.getSource() == this.rangeKeyButton) {
                Preconditions.checkState((boolean)TimelinePanel.isAnimatable(this.plugin));
                AnimatablePlugin animPlugin = (AnimatablePlugin)this.plugin;
                PluginState state = animPlugin.getState().deepCopy();
                double duration = TimelineLeftPanel.this.tp.showDurationDialog(false);
                if (duration > 0.0) {
                    TimelineLeftPanel.this.tp.addPluginKey(this.plugin, new RangeKeyFrame(time, time + duration, state, animPlugin));
                }
            } else if (e.getSource() == this.displayButton) {
                boolean displayed;
                boolean bl = displayed = !TimelineLeftPanel.this.timeline.isDisplayed(this.plugin);
                if (displayed) {
                    this.displayButton.setIcon(this.displayedIcon);
                } else {
                    this.displayButton.setIcon(this.hiddenIcon);
                }
                TimelineLeftPanel.this.timeline.setDisplayed(this.plugin, displayed);
                TimelineLeftPanel.this.tp.repaint();
            } else if (e.getSource() == this.freezeButton) {
                boolean frozen;
                boolean bl = frozen = !TimelineLeftPanel.this.timeline.isFrozen(this.plugin);
                if (frozen) {
                    this.freezeButton.setIcon(this.frozenIcon);
                } else {
                    this.freezeButton.setIcon(this.unfrozenIcon);
                }
                TimelineLeftPanel.this.timeline.setFrozen(this.plugin, frozen);
                TimelineLeftPanel.this.tp.repaint();
            } else if (e.getSource() == this.removeButton) {
                TimelineLeftPanel.this.tp.clearPluginKeys(this.plugin);
            }
        }

        @Override
        public void animatableChanged(AnimatablePlugin plugin, boolean isAnimatable) {
            Preconditions.checkState((plugin == this.plugin ? 1 : 0) != 0);
            this.rangeKeyButton.setEnabled(isAnimatable);
        }

        public void removeListeners() {
            if (this.plugin instanceof AnimatablePlugin) {
                ((AnimatablePlugin)this.plugin).removeAnimatableChangeListener(this);
            }
        }
    }

    private class KeyFrameButton
    extends JButton {
        public KeyFrameButton(Color color, String toolTip) {
            Color disabledColor = KeyFrameLabel.saturate(color);
            this.setIcon(new KeyFrameLabel(color));
            this.setDisabledIcon(new KeyFrameLabel(disabledColor));
            TimelineLeftPanel.setButtonSize(this, keyButtonSize);
            this.setToolTipText(toolTip);
        }
    }

    private class TimelineSettingsPanel
    extends JPanel
    implements ItemListener {
        private JTextField timeField;
        private JTextField frameRateField;
        private JComboBox<CameraAnimator.SplineType> splineBox;
        private JComboBox<Renderer> renderBox;
        private JPanel renderSettingsPanel;
        private ViewerSizePanel sizePanel;

        public TimelineSettingsPanel() {
            this.setLayout(new BoxLayout(this, 1));
            JLabel timeLabel = new JLabel("Total time (s):  ");
            this.timeField = new JTextField(10);
            this.addRow(timeLabel, this.timeField);
            JLabel frameRateLabel = new JLabel("Frames Per Second:  ");
            this.frameRateField = new JTextField(10);
            this.addRow(frameRateLabel, this.frameRateField);
            JLabel splineLabel = new JLabel("Camera Spline Type:  ");
            this.splineBox = new JComboBox<CameraAnimator.SplineType>(CameraAnimator.SplineType.values());
            this.addRow(splineLabel, this.splineBox);
            this.add(new JSeparator(0));
            JLabel renderLabel = new JLabel("Renderer:  ");
            this.renderBox = new JComboBox();
            this.renderBox.addItemListener(this);
            this.addRow(renderLabel, this.renderBox);
            this.renderSettingsPanel = new JPanel();
            this.renderSettingsPanel.setLayout(new CardLayout());
            this.renderSettingsPanel.setMinimumSize(new Dimension(200, 30));
            for (Renderer r : TimelineLeftPanel.this.timeline.getAvailableRenderers()) {
                JComponent renderPanel = r.getSettingsComponent();
                if (renderPanel == null) {
                    renderPanel = new JPanel();
                    renderPanel.setPreferredSize(new Dimension(200, 30));
                    renderPanel.setMinimumSize(renderPanel.getPreferredSize());
                    renderPanel.setSize(renderPanel.getPreferredSize());
                }
                this.renderSettingsPanel.add((Component)renderPanel, r.getName());
            }
            this.add(this.renderSettingsPanel);
            this.add(new JSeparator(0));
            this.sizePanel = new ViewerSizePanel(TimelineLeftPanel.this.timeline);
            this.add(this.sizePanel);
            this.updateFromTimeline();
        }

        public void updateFromTimeline() {
            this.timeField.setText(TimelinePanel.timeMinorLabelFormat.format(TimelineLeftPanel.this.timeline.getMaxTime()).replaceAll("s", ""));
            this.frameRateField.setText("" + (float)TimelineLeftPanel.this.timeline.getFamerate());
            this.splineBox.setSelectedItem((Object)TimelineLeftPanel.this.timeline.getCameraSplineType());
            if (this.renderBox.getItemCount() == 0) {
                this.renderBox.setModel(new DefaultComboBoxModel<Renderer>(TimelineLeftPanel.this.timeline.getAvailableRenderers().toArray(new Renderer[0])));
            }
            this.renderBox.setSelectedItem(TimelineLeftPanel.this.timeline.getRenderer());
            this.updateRenderPanel();
            this.sizePanel.updateFromTimeline();
        }

        private void updateRenderPanel() {
            CardLayout cl = (CardLayout)this.renderSettingsPanel.getLayout();
            cl.show(this.renderSettingsPanel, this.renderBox.getItemAt(this.renderBox.getSelectedIndex()).getName());
            this.invalidate();
            this.validate();
        }

        public void updateTimeline() {
            TimelineLeftPanel.this.maxTime = Double.parseDouble(this.timeField.getText());
            System.out.println("maxTime: " + TimelineLeftPanel.this.maxTime);
            Preconditions.checkState((TimelineLeftPanel.this.maxTime >= 0.1 ? 1 : 0) != 0, (Object)"Max time must be >= 0.1");
            TimelineLeftPanel.this.fps = Double.parseDouble(this.frameRateField.getText());
            System.out.println("fps: " + TimelineLeftPanel.this.fps);
            Preconditions.checkState((TimelineLeftPanel.this.fps > 1.0 ? 1 : 0) != 0, (Object)"Framerate must be >= 1 fps");
            CameraAnimator.SplineType type = (CameraAnimator.SplineType)((Object)this.splineBox.getSelectedItem());
            Preconditions.checkNotNull((Object)((Object)type), (Object)"Null SplineType");
            TimelineLeftPanel.this.timeline.setMaxTime(TimelineLeftPanel.this.maxTime);
            TimelineLeftPanel.this.timeline.setFramerate(TimelineLeftPanel.this.fps);
            TimelineLeftPanel.this.timeline.setCameraSplineType(type);
            TimelineLeftPanel.this.timeline.setRenderer(this.renderBox.getItemAt(this.renderBox.getSelectedIndex()));
            this.sizePanel.updateTimeline();
        }

        private void addRow(Component ... components) {
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 0));
            for (Component component : components) {
                panel.add(component);
            }
            this.add(panel);
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            this.updateRenderPanel();
        }
    }
}

