/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.timeline.gui;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.AnimatablePlugin;
import org.scec.vtk.plugins.Plugin;
import org.scec.vtk.plugins.PluginState;
import org.scec.vtk.plugins.StatefulPlugin;
import org.scec.vtk.timeline.AnimationTimeListener;
import org.scec.vtk.timeline.KeyFrame;
import org.scec.vtk.timeline.KeyFrameList;
import org.scec.vtk.timeline.RangeKeyFrame;
import org.scec.vtk.timeline.Timeline;
import org.scec.vtk.timeline.TimelinePluginChangeListener;
import org.scec.vtk.timeline.VisibilityKeyFrame;
import org.scec.vtk.timeline.camera.CameraKeyFrame;
import org.scec.vtk.timeline.gui.KeyFrameLabel;
import vtk.vtkCamera;

public class TimelinePanel
extends JPanel
implements MouseListener,
MouseMotionListener,
AnimationTimeListener,
TimelinePluginChangeListener,
Scrollable {
    private int pixelsPerSecond = 100;
    private double secondsPerPixel = 1.0 / (double)this.pixelsPerSecond;
    private double curTime;
    public static final int headerHeight = 30;
    private static final double majorTickInterval = 1.0;
    static final double minorTickInterval = 0.1;
    private static final int majorTickHeight = 12;
    private static final int minorTickHeight = 6;
    static final DecimalFormat timeMajorLabelFormat = new DecimalFormat("0s");
    static final DecimalFormat timeMinorLabelFormat = new DecimalFormat("0.0s");
    private static final Font timeLabelFont = new Font("SansSerif", 0, 14);
    private static final int timeLabelLowerPad = 3;
    private static final Color lineColor = Color.BLACK;
    private static final Color tickColor = Color.BLACK;
    static final Color pluginDividerColor = Color.LIGHT_GRAY;
    private static final Color tickGridColor = new Color(225, 225, 225);
    private static final Color tickGridMajorColor = Color.LIGHT_GRAY;
    static final int heightPerPlugin = 30;
    static final int keyWidth = 7;
    static final int keyHeight = 15;
    static final int halfKeyWidth = 3;
    static final int keyYRelative = 7;
    static final int halfKeyHeight = 7;
    static final int halfPluginHeight = 15;
    private static final Color pluginHiddenColor = KeyFrameLabel.saturate(Color.LIGHT_GRAY);
    private static final Color pluginFrozenColor = KeyFrameLabel.saturate(KeyFrameLabel.saturate(Color.CYAN));
    static final Color keyOutlineColor = Color.BLACK;
    static final Color keyOutlineSelectedColor = Color.BLACK;
    static final int cameraHeight = 30;
    static final int cameraMaxY = 60;
    private static final int INDEX_TAG_HEADER = -1;
    private static final int INDEX_TAG_CAMERA = -2;
    private Timeline timeline;
    static final Color visibilityKeyOnColor = Color.BLUE;
    static final Color visibilityKeyOffColor = Color.GRAY;
    static final Color rangeKeyColor = Color.GREEN;
    static final Color cameraKeyColor = Color.ORANGE;
    static final Color cameraKeyPauseColor = Color.GRAY;
    static final Color normalKeyColor = Color.RED;

    public TimelinePanel(Timeline timeline) {
        this.setLayout(null);
        this.setBackground(Color.WHITE);
        this.timeline = timeline;
        timeline.addAnimationTimeListener(this);
        timeline.addTimelinePluginChangeListener(this);
        this.addMouseListener(this);
        this.rebuildKeyLabels();
    }

    private synchronized void rebuildKeyLabels() {
        this.removeAll();
        KeyFrameList camKeys = this.timeline.getCameraKeys();
        for (KeyFrame key : camKeys) {
            KeyFrameLabel label = this.buildKeyLabel(key, camKeys);
            int x = this.getPixelX(key.getStartTime()) - 3;
            int y = 37;
            this.add(label);
            label.setLocation(x, y);
            label.updateSize();
        }
        for (int index = 0; index < this.timeline.getNumPlugins(); ++index) {
            KeyFrameList keys = this.timeline.getKeysForPlugin(index);
            int pluginY = this.yForPluginIndex(index);
            for (KeyFrame key : keys) {
                KeyFrameLabel label = this.buildKeyLabel(key, keys);
                int x = this.getPixelX(key.getStartTime()) - 3;
                int y = pluginY + 7;
                this.add(label);
                label.setLocation(x, y);
                label.updateSize();
            }
        }
        this.repaint();
    }

    private Dimension calculateSize() {
        int maxY = 60 + this.timeline.getNumPlugins() * 30;
        int width = this.getPixelX(this.timeline.getMaxTime()) + 3;
        return new Dimension(width, maxY);
    }

    public void updateSize() {
        Dimension size = this.calculateSize();
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.setSize(size);
        this.revalidate();
    }

    private KeyFrameLabel buildKeyLabel(KeyFrame key, KeyFrameList keys) {
        KeyFrameLabel label = new KeyFrameLabel(this, key, keys);
        label.addMouseListener(this);
        label.addMouseMotionListener(this);
        return label;
    }

    @Override
    protected synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        int panelHeight = this.getHeight();
        int panelWidth = this.getWidth();
        int y = 30;
        g.setColor(pluginDividerColor);
        g.drawLine(0, y, panelWidth, y);
        g.drawLine(0, y += 30, panelWidth, y);
        for (int index = 0; index < this.timeline.getNumPlugins(); ++index) {
            if (!this.timeline.isDisplayed(index)) {
                g.setColor(pluginHiddenColor);
                g.fillRect(0, y + 1, panelWidth, 29);
                g.setColor(pluginDividerColor);
            } else if (this.timeline.isFrozen(index)) {
                g.setColor(pluginFrozenColor);
                g.fillRect(0, y + 1, panelWidth, 29);
                g.setColor(pluginDividerColor);
            }
            g.drawLine(0, y += 30, panelWidth, y);
        }
        double curMaxTime = this.getCurrentTotalTime();
        this.drawTicks(g, 0.1, 6, panelWidth, panelHeight, curMaxTime, false);
        this.drawTicks(g, 1.0, 12, panelWidth, panelHeight, curMaxTime, true);
        g.setColor(lineColor);
        int curTimePixel = this.getPixelX(this.curTime);
        g.drawLine(curTimePixel, 0, curTimePixel, panelHeight);
    }

    static Color fillColorForKey(KeyFrame key) {
        if (key instanceof VisibilityKeyFrame) {
            VisibilityKeyFrame v = (VisibilityKeyFrame)key;
            if (v.isVisible()) {
                return visibilityKeyOnColor;
            }
            return visibilityKeyOffColor;
        }
        if (key instanceof RangeKeyFrame) {
            return rangeKeyColor;
        }
        if (key instanceof CameraKeyFrame) {
            CameraKeyFrame c = (CameraKeyFrame)key;
            if (c.isPause()) {
                return cameraKeyPauseColor;
            }
            return cameraKeyColor;
        }
        return normalKeyColor;
    }

    private void drawTicks(Graphics g, double interval, int tickHeight, int panelWidth, int panelHeight, double maxTime, boolean major) {
        if (major) {
            g.setFont(timeLabelFont);
        }
        g.setColor(tickColor);
        for (double time = 0.0; time <= maxTime; time += interval) {
            int x = this.getPixelX(time);
            Color gridColor = major ? tickGridMajorColor : tickGridColor;
            if (gridColor != null) {
                g.setColor(gridColor);
                g.drawLine(x, 0, x, panelHeight);
                g.setColor(tickColor);
            }
            g.drawLine(x, 0, x, tickHeight);
            if (!major || !(time < this.timeline.getMaxTime())) continue;
            g.drawString(timeMajorLabelFormat.format(time), x, 27);
        }
    }

    int getPixelX(double time) {
        return (int)(time * (double)this.pixelsPerSecond + 0.5);
    }

    double getTime(int x) {
        double time = (double)x * this.secondsPerPixel;
        return this.getRoundedTime(time);
    }

    double getRoundedTime(double time) {
        return (double)Math.round(time / 0.1) * 0.1;
    }

    int pluginIndexForY(int y) {
        if (y < 30) {
            return -1;
        }
        if (y < 60) {
            return -2;
        }
        return (y - 60) / 30;
    }

    int yForPluginIndex(int index) {
        return 60 + 30 * index;
    }

    double getCurrentTotalTime() {
        return (double)this.getWidth() * this.secondsPerPixel;
    }

    private double getTime(MouseEvent e) {
        int x = e.getSource() == this ? e.getX() : e.getX() + e.getComponent().getX();
        return this.getTime(x);
    }

    private void removeKey(KeyFrameLabel label) {
        label.getKeyFrameList().removeKeyFrame(label.getKeyFrame());
        this.remove(label);
        this.repaint();
    }

    static boolean isAnimatable(Plugin plugin) {
        return plugin instanceof AnimatablePlugin && ((AnimatablePlugin)plugin).isAnimatable();
    }

    double showDurationDialog(boolean allowZero) {
        String defaultVal;
        String message;
        if (allowZero) {
            message = "Duration (min: 0.1, 0 for standard KeyFrame)";
            defaultVal = "0";
        } else {
            message = "Duration (min: 0.1)";
            defaultVal = "1";
        }
        String durStr = JOptionPane.showInputDialog(this, message, defaultVal);
        if (durStr == null) {
            return -1.0;
        }
        try {
            double duration = Double.parseDouble(durStr);
            if (allowZero && duration == 0.0) {
                return 0.0;
            }
            Preconditions.checkState((duration > 0.1 ? 1 : 0) != 0);
            return duration;
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(this, "Could not parse duration: " + durStr, "Error Parsing Duration", 0);
            return -1.0;
        }
    }

    private void addKey(double time, int pluginIndex, boolean forceVisibilityKey) {
        KeyFrame key;
        Plugin plugin = this.timeline.getPluginAt(pluginIndex);
        if (!forceVisibilityKey && plugin instanceof StatefulPlugin) {
            PluginState state = ((StatefulPlugin)plugin).getState().deepCopy();
            if (TimelinePanel.isAnimatable(plugin)) {
                double duration = this.showDurationDialog(true);
                if (duration < 0.0) {
                    return;
                }
                key = duration == 0.0 ? new KeyFrame(time, state) : new RangeKeyFrame(time, time + duration, state, (AnimatablePlugin)plugin);
            } else {
                key = new KeyFrame(time, state);
            }
        } else {
            JCheckBox check = new JCheckBox("Visible?");
            check.setSelected(true);
            String title = plugin instanceof StatefulPlugin ? "New Visibility KeyFrame" : "Plugin Only Supports Visibility Animation";
            int ret = JOptionPane.showConfirmDialog(this, check, title, 2);
            if (ret == 0) {
                key = new VisibilityKeyFrame(time, this.timeline.getActorsForPlugin(pluginIndex), check.isSelected());
            } else {
                return;
            }
        }
        this.timeline.addKeyFrame(pluginIndex, key);
        this.rebuildKeyLabels();
    }

    void addCameraKey(double time, boolean pause) {
        vtkCamera cam = MainGUI.getRenderWindow().getRenderer().GetActiveCamera();
        CameraKeyFrame key = new CameraKeyFrame(time, cam, pause);
        this.timeline.addCameraKeyFrame(key);
        this.rebuildKeyLabels();
    }

    void addPluginKey(Plugin plugin, KeyFrame key) {
        this.timeline.addKeyFrame(plugin, key);
        this.rebuildKeyLabels();
    }

    void clearPluginKeys(Plugin plugin) {
        this.timeline.clearKeys(plugin);
        this.rebuildKeyLabels();
    }

    void clearCameraKeys() {
        this.timeline.clearCameraKeys();
        this.rebuildKeyLabels();
    }

    @Override
    public synchronized void mouseClicked(MouseEvent e) {
        block18: {
            if (e.getSource() instanceof KeyFrameLabel) {
                KeyFrameLabel label = (KeyFrameLabel)e.getSource();
                KeyFrame key = label.getKeyFrame();
                boolean remove = false;
                if (e.getClickCount() == 2 && e.getSource() instanceof KeyFrameLabel && !(key instanceof RangeKeyFrame)) {
                    int ret = JOptionPane.showConfirmDialog(this, "Delete Key Frame?", "Delete?", 2);
                    remove = ret == 0;
                } else if (e.getButton() == 2) {
                    remove = true;
                }
                if (remove) {
                    this.removeKey(label);
                } else if (e.getClickCount() == 2 && label.getKeyFrame() instanceof RangeKeyFrame) {
                    RangeKeyFrame range = (RangeKeyFrame)label.getKeyFrame();
                    String durStr = JOptionPane.showInputDialog(this, "Update Duration (min: 0.1, 0 to delete)", "" + range.getDuration());
                    if (durStr == null) {
                        return;
                    }
                    try {
                        double duration = Double.parseDouble(durStr);
                        if (duration == 0.0) {
                            this.removeKey(label);
                            break block18;
                        }
                        Preconditions.checkState((duration > 0.1 ? 1 : 0) != 0);
                        range.setDuration(duration);
                        label.updateSize();
                        label.repaint();
                    }
                    catch (Exception e1) {
                        JOptionPane.showMessageDialog(this, "Could not parse duration: " + durStr, "Error Setting Duration", 0);
                    }
                }
            } else if (e.getSource() == this && e.getClickCount() == 2) {
                int pluginIndex = this.pluginIndexForY(e.getY());
                double time = this.getTime(e.getX());
                if (pluginIndex == -1) {
                    System.out.println("Going to time " + (float)time);
                    this.timeline.activateTime(time);
                } else if (pluginIndex == -2) {
                    this.addCameraKey(time, e.isShiftDown());
                } else if (pluginIndex < this.timeline.getNumPlugins()) {
                    Preconditions.checkState((pluginIndex >= 0 ? 1 : 0) != 0);
                    System.out.println("Adding KeyFrame at time " + time + ", plugin " + pluginIndex);
                    this.addKey(time, pluginIndex, e.isShiftDown());
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        KeyFrameLabel label;
        if (e.getSource() instanceof KeyFrameLabel && (label = (KeyFrameLabel)e.getSource()).isDragging()) {
            label.finalizeDrag();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        KeyFrameLabel label;
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        Preconditions.checkState((boolean)(e.getSource() instanceof KeyFrameLabel));
        double time = this.getTime(e);
        if (time > this.timeline.getMaxTime()) {
            time = this.timeline.getMaxTime();
        }
        if (time < 0.0) {
            time = 0.0;
        }
        if ((label = (KeyFrameLabel)e.getSource()).isDragging() || time != label.getKeyFrame().getStartTime()) {
            if (e.isShiftDown() && !label.isDragging()) {
                KeyFrame dupKey = label.getKeyFrame().duplicate();
                label.getKeyFrameList().addKeyFrame(dupKey);
                KeyFrameLabel dupLabel = this.buildKeyLabel(dupKey, label.getKeyFrameList());
                this.add(dupLabel);
                dupLabel.setLocation(label.getX(), label.getY());
                dupLabel.updateSize();
            }
            label.dragTo(time);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void animationTimeChanged(double curTime) {
        this.curTime = curTime;
        this.repaint();
    }

    @Override
    public void animationBoundsChanged(double maxTime) {
        this.updateSize();
    }

    @Override
    public void timelinePluginsChanged() {
        this.rebuildKeyLabels();
        this.repaint();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.calculateSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 30;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 100;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    public Timeline getTimeline() {
        return this.timeline;
    }
}

