/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.timeline.gui;

import com.google.common.base.Preconditions;
import com.jogamp.opengl.awt.GLJPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.scec.vtk.main.Info;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.timeline.Timeline;
import org.scec.vtk.tools.Prefs;

public class ViewerSizePanel
extends JPanel
implements ActionListener,
ItemListener,
DocumentListener {
    private Timeline timeline;
    private JComboBox<String> presetBox;
    private JTextField widthField;
    private JTextField heightField;
    private JButton resizeButton;
    private JCheckBox customSizeCheck;
    private static final String CUSTOM_LABEL = "(custom)";
    private boolean internalUpdate = false;

    public ViewerSizePanel(Timeline timeline) {
        this.timeline = timeline;
        this.setLayout(new BoxLayout(this, 1));
        if (timeline != null) {
            this.customSizeCheck = new JCheckBox("Custom Render Size", false);
            this.addRow(this.customSizeCheck);
            this.customSizeCheck.addItemListener(this);
        }
        this.resizeButton = new JButton("Resize Window To Match");
        if (timeline == null) {
            this.addRow(new JLabel("Render Resolution    "));
        } else {
            this.addRow(new JLabel("Render Resolution    "), this.resizeButton);
        }
        this.resizeButton.addActionListener(this);
        ArrayList<String> presets = new ArrayList<String>();
        for (SizePreset preset : SizePreset.values()) {
            presets.add(preset.label);
        }
        presets.add(CUSTOM_LABEL);
        this.presetBox = new JComboBox<String>(presets.toArray(new String[0]));
        this.presetBox.addItemListener(this);
        this.addRow(new JLabel("Preset:  "), this.presetBox);
        this.widthField = new JTextField(10);
        this.widthField.getDocument().addDocumentListener(this);
        this.addRow(new JLabel("Width:  "), this.widthField);
        this.heightField = new JTextField(10);
        this.heightField.getDocument().addDocumentListener(this);
        this.addRow(new JLabel("Height:  "), this.heightField);
        if (this.customSizeCheck != null) {
            this.setEnabled(this.customSizeCheck.isSelected());
        }
        if (timeline == null) {
            this.updateFromWindow();
        } else {
            this.updateFromTimeline();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.resizeButton.setEnabled(enabled);
        this.presetBox.setEnabled(enabled);
        this.widthField.setEnabled(enabled);
        this.heightField.setEnabled(enabled);
    }

    private void addRow(Component ... components) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        for (Component component : components) {
            panel.add(component);
        }
        this.add(panel);
    }

    public void updateFromWindow() {
        int height;
        int width = ((GLJPanel)MainGUI.getRenderWindow().getComponent()).getWidth();
        SizePreset preset = SizePreset.forSize(width, height = ((GLJPanel)MainGUI.getRenderWindow().getComponent()).getHeight());
        if (preset == null) {
            this.presetBox.setSelectedItem(CUSTOM_LABEL);
            this.updateInternal(width, height);
        } else {
            this.presetBox.setSelectedItem(preset.label);
        }
    }

    public void updateFromTimeline() {
        SizePreset preset;
        Dimension dims = this.timeline.getRenderDimensions();
        this.customSizeCheck.setSelected(dims != null);
        if (dims == null) {
            int height;
            int width;
            if (this.timeline.isLive()) {
                width = ((GLJPanel)MainGUI.getRenderWindow().getComponent()).getWidth();
                height = ((GLJPanel)MainGUI.getRenderWindow().getComponent()).getHeight();
            } else {
                width = SizePreset.DEFAULT_VIEW.width;
                height = SizePreset.DEFAULT_VIEW.height;
            }
            dims = new Dimension(width, height);
        }
        if ((preset = SizePreset.forSize(dims.width, dims.height)) == null) {
            this.presetBox.setSelectedItem(CUSTOM_LABEL);
            this.updateInternal(dims.width, dims.height);
        } else {
            this.presetBox.setSelectedItem(preset.label);
        }
    }

    public void updateTimeline() {
        Preconditions.checkNotNull((Object)this.timeline);
        if (this.customSizeCheck.isSelected()) {
            Dimension dims = this.getCurDims();
            this.timeline.setRenderDimensions(dims);
        } else {
            this.timeline.setRenderDimensions(null);
        }
    }

    public Dimension getCurDims() {
        int curWidth = Integer.parseInt(this.widthField.getText());
        int curHeight = Integer.parseInt(this.heightField.getText());
        return new Dimension(curWidth, curHeight);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Dimension dims = this.getCurDims();
        Info.getMainGUI().resizeViewer(dims.width, dims.height);
    }

    private synchronized void updateInternal(int width, int height) {
        this.internalUpdate = true;
        this.updateIfNecessary(this.widthField, width);
        this.updateIfNecessary(this.heightField, height);
        this.internalUpdate = false;
    }

    @Override
    public synchronized void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.presetBox) {
            SizePreset preset = SizePreset.forLabel(this.presetBox.getItemAt(this.presetBox.getSelectedIndex()));
            if (preset != null) {
                this.updateInternal(preset.width, preset.height);
            }
        } else if (e.getSource() == this.customSizeCheck) {
            this.setEnabled(this.customSizeCheck.isSelected());
        }
    }

    private void updateIfNecessary(JTextField field, int val) {
        String strVal = "" + val;
        if (!field.getText().equals(strVal)) {
            field.setText(strVal);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.textUpdated();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.textUpdated();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.textUpdated();
    }

    private void textUpdated() {
        if (this.internalUpdate) {
            return;
        }
        try {
            Dimension dims = this.getCurDims();
            SizePreset preset = SizePreset.forSize(dims.width, dims.height);
            if (preset == null) {
                this.presetBox.setSelectedItem(CUSTOM_LABEL);
            } else {
                this.presetBox.setSelectedItem(preset.label);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static enum SizePreset {
        HD("HD (720p)", 1280, 720),
        FHD("Full HD (1080p)", 1920, 1080),
        FOUR_K("4K UHD", 3840, 2160),
        DEFAULT_VIEW("Default", Prefs.getMainWidth(), Prefs.getMainHeight());

        private String label;
        private int width;
        private int height;

        private SizePreset(String label, int width, int height) {
            this.label = label;
            this.width = width;
            this.height = height;
        }

        public boolean equals(int width, int height) {
            return width == this.width && height == this.height;
        }

        public static SizePreset forSize(int width, int height) {
            for (SizePreset preset : SizePreset.values()) {
                if (!preset.equals(width, height)) continue;
                return preset;
            }
            return null;
        }

        public static SizePreset forLabel(String label) {
            for (SizePreset preset : SizePreset.values()) {
                if (!preset.label.equals(label)) continue;
                return preset;
            }
            return null;
        }
    }
}

