/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.timeline.render;

import com.google.common.base.Preconditions;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import org.jcodec.common.Codec;
import org.jcodec.common.MuxerTrack;
import org.jcodec.common.VideoCodecMeta;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Packet;
import org.jcodec.common.model.Rational;
import org.jcodec.common.model.Size;
import org.jcodec.containers.mp4.Brand;
import org.jcodec.containers.mp4.muxer.MP4Muxer;
import org.scec.vtk.timeline.render.AbstractThreadedRenderer;

public abstract class AbstractMP4Renderer
extends AbstractThreadedRenderer {
    private static final boolean D = true;
    private int width;
    private int height;
    private SeekableByteChannel ch;
    private MP4Muxer muxer;
    private MuxerTrack outTrack;
    private int frameNo;
    private int timestamp;
    private Rational fps;
    private static double rational_accuracy = 1.0E-6;

    @Override
    protected void doInit(File outputFile, int width, int height, double fps, int count) throws IOException {
        this.width = width - width % 2;
        this.height = height - height % 2;
        System.out.println("Creating MP4 encoder, size=" + this.width + "x" + this.height + " (orig " + width + "x" + height + ")");
        this.fps = AbstractMP4Renderer.getRationalFPS(fps);
        System.out.println("Input fps=" + fps + ". Rational: " + this.fps.getNum() + "/" + this.fps.getDen());
        this.ch = NIOUtils.writableChannel(outputFile);
        this.timestamp = 0;
        this.frameNo = 0;
        this.outTrack = null;
        this.muxer = MP4Muxer.createMP4Muxer(this.ch, Brand.MP4);
    }

    protected int getWidth() {
        return this.width;
    }

    protected int getHeight() {
        return this.height;
    }

    protected abstract ColorSpace getColorSpace();

    protected abstract Codec getCodec();

    @Override
    protected final void doProcessFrame(BufferedImage img) throws IOException {
        System.out.print("Processing frame " + this.frameNo + "...");
        if (this.outTrack == null) {
            Size size = new Size(img.getWidth(), img.getHeight());
            this.outTrack = this.muxer.addVideoTrack(this.getCodec(), new VideoCodecMeta(size, this.getColorSpace()));
        }
        Preconditions.checkState((img.getHeight() >= this.height ? 1 : 0) != 0, (Object)(img.getWidth() >= this.width ? 1 : 0));
        if (img.getHeight() > this.height || img.getWidth() > this.width) {
            img = img.getSubimage(0, 0, this.width, this.height);
        }
        this.outTrack.addFrame(this.createPacket(img, this.timestamp, this.fps.getNum(), this.fps.getDen(), this.frameNo));
        this.timestamp += this.fps.getDen();
        ++this.frameNo;
        System.out.println("DONE");
    }

    protected abstract Packet createPacket(BufferedImage var1, long var2, int var4, long var5, long var7) throws IOException;

    @Override
    protected void doFinalize() throws IOException {
        System.out.print("Finalizing...");
        this.muxer.finish();
        NIOUtils.closeQuietly(this.ch);
        System.out.println("DONE");
    }

    private static Rational getRationalFPS(double value) {
        int middle_n;
        int middle_d;
        Preconditions.checkState((value > 0.0 ? 1 : 0) != 0);
        int n = (int)Math.floor(value);
        value -= (double)n;
        if (value < rational_accuracy) {
            return new Rational(n, 1);
        }
        if (1.0 - rational_accuracy < value) {
            return new Rational(n + 1, 1);
        }
        int lower_n = 0;
        int lower_d = 1;
        int upper_n = 1;
        int upper_d = 1;
        while (true) {
            if ((double)(middle_d = lower_d + upper_d) * (value + rational_accuracy) < (double)(middle_n = lower_n + upper_n)) {
                upper_n = middle_n;
                upper_d = middle_d;
                continue;
            }
            if (!((double)middle_n < (value - rational_accuracy) * (double)middle_d)) break;
            lower_n = middle_n;
            lower_d = middle_d;
        }
        return new Rational(n * middle_d + middle_n, middle_d);
    }

    @Override
    public final String getExtension() {
        return "mp4";
    }
}

