/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.timeline.render;

import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.opensha.commons.util.ExceptionUtils;
import org.scec.vtk.timeline.render.RenderStatusListener;
import org.scec.vtk.timeline.render.Renderer;

public abstract class AbstractThreadedRenderer
implements Renderer {
    private ExecutorService exec;
    private List<Future<?>> futures;
    private RenderStatusListener l;
    private int index;
    private int count;
    private boolean threadLocalProcessing = false;
    private static final int MAX_FRAMES_PENDING = 100;

    @Override
    public final void init(File outputFile, int width, int height, double fps, int count) throws IOException {
        this.exec = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LimitedQueue<Runnable>(100));
        this.futures = Lists.newArrayList();
        this.doInit(outputFile, width, height, fps, count);
        this.index = 0;
        this.count = count;
    }

    protected abstract void doInit(File var1, int var2, int var3, double var4, int var6) throws IOException;

    @Override
    public final void processFrame(BufferedImage img) throws IOException {
        ProcessRunnable run = new ProcessRunnable(img, this.index++);
        if (this.threadLocalProcessing) {
            run.run();
        } else {
            this.futures.add(this.exec.submit(run));
        }
    }

    public void setThreadLocalProcessing(boolean threadLocalProcessing) {
        this.threadLocalProcessing = threadLocalProcessing;
    }

    protected abstract void doProcessFrame(BufferedImage var1) throws IOException;

    @Override
    public void finalize() throws IOException {
        for (Future<?> future : this.futures) {
            try {
                future.get();
            }
            catch (Exception e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }
        if (this.l != null) {
            this.l.finalizeStarted();
        }
        this.doFinalize();
        if (this.l != null) {
            this.l.finalizeCompleted();
        }
    }

    protected abstract void doFinalize() throws IOException;

    @Override
    public void setRenderStatusListener(RenderStatusListener l) {
        this.l = l;
    }

    public String toString() {
        return this.getName();
    }

    public static class LimitedQueue<E>
    extends LinkedBlockingQueue<E> {
        public LimitedQueue(int maxSize) {
            super(maxSize);
        }

        @Override
        public boolean offer(E e) {
            try {
                this.put(e);
                return true;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
    }

    private class ProcessRunnable
    implements Runnable {
        private BufferedImage img;
        private int index;

        private ProcessRunnable(BufferedImage img, int index) {
            this.img = img;
            this.index = index;
        }

        @Override
        public void run() {
            try {
                AbstractThreadedRenderer.this.doProcessFrame(this.img);
                if (AbstractThreadedRenderer.this.l != null) {
                    AbstractThreadedRenderer.this.l.frameProcessed(this.index, AbstractThreadedRenderer.this.count);
                }
            }
            catch (IOException e) {
                ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }
    }
}

