/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.timeline.render;

import com.google.common.base.Preconditions;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.scec.vtk.timeline.render.AbstractThreadedRenderer;

public class AnimatedGIFRenderer
extends AbstractThreadedRenderer {
    private static String NAME = "Animated GIF";
    private static String EXT = "gif";
    private ImageWriter writer;
    private ImageWriteParam imageWriteParam;
    private IIOMetadata imageMetaData;
    private FileImageOutputStream output;
    private JCheckBox loopCheck = new JCheckBox("Loop continuously?", true);
    private JPanel settingsPanel = new JPanel();

    public AnimatedGIFRenderer() {
        this.settingsPanel.setLayout(new BoxLayout(this.settingsPanel, 1));
        this.settingsPanel.add(this.loopCheck);
        this.settingsPanel.add(new JLabel("NOTE: FPS should be an even divisor of 100"));
    }

    @Override
    public JComponent getSettingsComponent() {
        return this.settingsPanel;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getExtension() {
        return EXT;
    }

    public void setLoop(boolean loop) {
        this.loopCheck.setSelected(loop);
        this.loopCheck.invalidate();
    }

    @Override
    protected void doInit(File outputFile, int width, int height, double fps, int count) throws IOException {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersBySuffix(EXT);
        Preconditions.checkArgument((boolean)iter.hasNext(), (Object)"No GIF image writers available!");
        this.writer = iter.next();
        this.imageWriteParam = this.writer.getDefaultWriteParam();
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(1);
        this.imageMetaData = this.writer.getDefaultImageMetadata(imageTypeSpecifier, this.imageWriteParam);
        String metaFormatName = this.imageMetaData.getNativeMetadataFormatName();
        IIOMetadataNode root = (IIOMetadataNode)this.imageMetaData.getAsTree(metaFormatName);
        IIOMetadataNode graphicsControlExtensionNode = AnimatedGIFRenderer.getNode(root, "GraphicControlExtension");
        int delayTime = (int)(100.0 / fps);
        graphicsControlExtensionNode.setAttribute("disposalMethod", "none");
        graphicsControlExtensionNode.setAttribute("userInputFlag", "FALSE");
        graphicsControlExtensionNode.setAttribute("transparentColorFlag", "FALSE");
        graphicsControlExtensionNode.setAttribute("delayTime", "" + delayTime);
        graphicsControlExtensionNode.setAttribute("transparentColorIndex", "0");
        IIOMetadataNode commentsNode = AnimatedGIFRenderer.getNode(root, "CommentExtensions");
        commentsNode.setAttribute("CommentExtension", "Created by SCEC-VDO");
        IIOMetadataNode appEntensionsNode = AnimatedGIFRenderer.getNode(root, "ApplicationExtensions");
        IIOMetadataNode child = new IIOMetadataNode("ApplicationExtension");
        child.setAttribute("applicationID", "NETSCAPE");
        child.setAttribute("authenticationCode", "2.0");
        int loop = this.loopCheck.isSelected() ? 0 : 1;
        child.setUserObject(new byte[]{1, (byte)(loop & 0xFF), (byte)(loop >> 8 & 0xFF)});
        appEntensionsNode.appendChild(child);
        this.imageMetaData.setFromTree(metaFormatName, root);
        this.output = new FileImageOutputStream(outputFile);
        this.writer.setOutput(this.output);
        this.writer.prepareWriteSequence(this.imageMetaData);
    }

    private static IIOMetadataNode getNode(IIOMetadataNode rootNode, String nodeName) {
        int nNodes = rootNode.getLength();
        for (int i = 0; i < nNodes; ++i) {
            if (rootNode.item(i).getNodeName().compareToIgnoreCase(nodeName) != 0) continue;
            return (IIOMetadataNode)rootNode.item(i);
        }
        IIOMetadataNode node = new IIOMetadataNode(nodeName);
        rootNode.appendChild(node);
        return node;
    }

    @Override
    protected void doProcessFrame(BufferedImage img) throws IOException {
        this.writer.writeToSequence(new IIOImage(img, null, this.imageMetaData), this.imageWriteParam);
    }

    @Override
    protected void doFinalize() throws IOException {
        this.writer.endWriteSequence();
        this.output.close();
    }

    private static void mergeGifs(File gif1, File gif2, File outputFile, boolean vertical, boolean loop) throws IOException {
        AnimatedGIFRenderer writer = new AnimatedGIFRenderer();
        writer.setLoop(loop);
        ImageReader reader1 = ImageIO.getImageReadersByFormatName("gif").next();
        ImageReader reader2 = ImageIO.getImageReadersByFormatName("gif").next();
        ImageInputStream stream1 = ImageIO.createImageInputStream(gif1);
        reader1.setInput(stream1, false);
        ImageInputStream stream2 = ImageIO.createImageInputStream(gif2);
        reader2.setInput(stream2, false);
        int noi = reader1.getNumImages(true);
        Preconditions.checkState((noi == reader2.getNumImages(true) ? 1 : 0) != 0);
        int width = -1;
        int height = -1;
        for (int i = 0; i < noi; ++i) {
            int offsetY;
            int offsetX;
            System.out.println("Frame " + i + "/" + noi);
            BufferedImage img1 = reader1.read(i);
            BufferedImage img2 = reader2.read(i);
            if (i == 0) {
                if (vertical) {
                    width = img1.getWidth();
                    if (img2.getWidth() > img1.getWidth()) {
                        width = img2.getWidth();
                    }
                    height = img1.getHeight() + img2.getHeight();
                } else {
                    height = img1.getHeight();
                    if (img2.getHeight() > img1.getHeight()) {
                        height = img2.getHeight();
                    }
                    width = img1.getWidth() + img2.getWidth();
                }
                IIOMetadataNode root = (IIOMetadataNode)reader1.getImageMetadata(i).getAsTree("javax_imageio_gif_image_1.0");
                IIOMetadataNode gce = (IIOMetadataNode)root.getElementsByTagName("GraphicControlExtension").item(0);
                int delay = Integer.valueOf(gce.getAttribute("delayTime"));
                double fps = 100.0 / (double)delay;
                System.out.println("Delay=" + delay + ", fps=" + fps);
                writer.init(outputFile, width, height, fps, noi);
                System.out.println("Image1 dimensions: " + img1.getWidth() + "x" + img1.getHeight());
                System.out.println("Image2 dimensions: " + img2.getWidth() + "x" + img2.getHeight());
                System.out.println("Output dimensions: " + width + "x" + height);
            }
            BufferedImage combined = new BufferedImage(width, height, 1);
            for (int x = 0; x < img1.getWidth(); ++x) {
                for (int y = 0; y < img1.getHeight(); ++y) {
                    combined.setRGB(x, y, img1.getRGB(x, y));
                }
            }
            if (vertical) {
                offsetX = 0;
                offsetY = img1.getHeight();
            } else {
                offsetX = img1.getWidth();
                offsetY = 0;
            }
            for (int x = 0; x < img2.getWidth(); ++x) {
                for (int y = 0; y < img2.getHeight(); ++y) {
                    combined.setRGB(x + offsetX, y + offsetY, img2.getRGB(x, y));
                }
            }
            writer.processFrame(combined);
        }
        writer.finalize();
        System.out.println("DONE");
        stream1.close();
        stream2.close();
    }

    public static void main(String[] args) throws IOException {
        File gif1 = new File("/home/kevin/Documents/2018_SSA/figures/event_1670183_slip_anim.gif");
        File gif2 = new File("/home/kevin/Documents/2018_SSA/figures/event_1670183_vel_anim.gif");
        File outputFileLoop = new File("/home/kevin/Documents/2018_SSA/figures/event_1670183_combined_anim.gif");
        AnimatedGIFRenderer.mergeGifs(gif1, gif2, outputFileLoop, true, true);
        System.exit(0);
    }
}

