/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.timeline.render;

import com.google.common.base.Preconditions;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import javax.swing.JComponent;
import org.jcodec.codecs.h264.H264Encoder;
import org.jcodec.codecs.h264.encode.RateControl;
import org.jcodec.codecs.h264.io.model.SliceType;
import org.jcodec.common.Codec;
import org.jcodec.common.VideoEncoder;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Packet;
import org.jcodec.common.model.Picture8Bit;
import org.jcodec.scale.ColorUtil;
import org.jcodec.scale.Transform8Bit;
import org.scec.vtk.timeline.render.AbstractMP4Renderer;
import org.scec.vtk.timeline.render.QualitySlider;

public class H264Renderer
extends AbstractMP4Renderer {
    private static final boolean D = true;
    private Picture8Bit toEncode;
    private Transform8Bit transform;
    private H264Encoder encoder;
    private ByteBuffer _out;
    private static final int default_buffer_mult = 12;
    private static final int max_buffer_mult = 12000;
    private int bufferMult = 12;
    private QualitySlider qualitySlider;
    private static final int min_qp = 4;
    private static final int max_qp = 30;
    private static final int qp_delta = 26;

    public H264Renderer() {
        this(100);
    }

    public H264Renderer(int quality) {
        this.qualitySlider = new QualitySlider(quality);
    }

    private static int qualityToQP(int quality) {
        double q = (100.0 - (double)quality) / 100.0;
        double qp = 4.0 + q * 26.0;
        return (int)Math.round(qp);
    }

    @Override
    protected void doInit(File outputFile, int width, int height, double fps, int count) throws IOException {
        super.doInit(outputFile, width, height, fps, count);
        this.bufferMult = 12;
        this.toEncode = null;
        this.buildBuffer();
        int quality = this.qualitySlider.getValue();
        int QP = H264Renderer.qualityToQP(quality);
        System.out.println("Translated quality=" + quality + " to QP=" + QP);
        CustomDumbRateControl rc = new CustomDumbRateControl(QP);
        this.encoder = new H264Encoder(rc);
        this.transform = ColorUtil.getTransform8Bit(ColorSpace.RGB, this.encoder.getSupportedColorSpaces()[0]);
    }

    private void buildBuffer() {
        Preconditions.checkState((this.bufferMult > 0 ? 1 : 0) != 0);
        this._out = ByteBuffer.allocate(this.getWidth() * this.getHeight() * this.bufferMult);
    }

    @Override
    protected ColorSpace getColorSpace() {
        return this.encoder.getSupportedColorSpaces()[0];
    }

    @Override
    protected Codec getCodec() {
        return Codec.H264;
    }

    @Override
    protected Packet createPacket(BufferedImage img, long pts, int timescale, long duration, long frameNo) {
        Picture8Bit pic = H264Renderer.fromBufferedImageRGB8Bit(img);
        if (this.toEncode == null) {
            this.toEncode = Picture8Bit.create(pic.getWidth(), pic.getHeight(), this.encoder.getSupportedColorSpaces()[0]);
        }
        this.transform.transform(pic, this.toEncode);
        this._out.clear();
        VideoEncoder.EncodedFrame ef = null;
        while (ef == null) {
            try {
                ef = this.encoder.encodeFrame8Bit(this.toEncode, this._out);
            }
            catch (BufferOverflowException e) {
                int mult = this.bufferMult;
                int cap = this._out.capacity();
                this.bufferMult *= 2;
                if (this.bufferMult > 12000) {
                    System.out.println("Buffer has reached maximum size, try reducing quality");
                    throw e;
                }
                this.buildBuffer();
                System.out.println("Increased buffer size from dim*" + mult + "=" + cap + " to dim*" + this.bufferMult + "=" + this._out.capacity());
            }
        }
        ByteBuffer result = ef.getData();
        return Packet.createPacket(result, pts, timescale, duration, frameNo, ef.isKeyFrame() ? Packet.FrameType.KEY : Packet.FrameType.INTER, null);
    }

    @Override
    protected void doFinalize() throws IOException {
        this._out = null;
        super.doFinalize();
    }

    private static Picture8Bit fromBufferedImageRGB8Bit(BufferedImage src) {
        Picture8Bit dst = Picture8Bit.create(src.getWidth(), src.getHeight(), ColorSpace.RGB);
        H264Renderer.fromBufferedImage8Bit(src, dst);
        return dst;
    }

    private static void fromBufferedImage8Bit(BufferedImage src, Picture8Bit dst) {
        byte[] dstData = dst.getPlaneData(0);
        int off = 0;
        for (int i = 0; i < src.getHeight(); ++i) {
            for (int j = 0; j < src.getWidth(); ++j) {
                int rgb1 = src.getRGB(j, i);
                dstData[off++] = (byte)((rgb1 >> 16 & 0xFF) - 128);
                dstData[off++] = (byte)((rgb1 >> 8 & 0xFF) - 128);
                dstData[off++] = (byte)((rgb1 & 0xFF) - 128);
            }
        }
    }

    @Override
    public JComponent getSettingsComponent() {
        return this.qualitySlider;
    }

    @Override
    public String getName() {
        return "MPEG-4, H.246, Lossy";
    }

    private class CustomDumbRateControl
    implements RateControl {
        final int QP;

        public CustomDumbRateControl(int QP) {
            this.QP = QP;
        }

        @Override
        public int getInitQp(SliceType sliceType) {
            return this.QP + (sliceType == SliceType.P ? 6 : 0);
        }

        @Override
        public int getQpDelta() {
            return 0;
        }

        @Override
        public boolean accept(int bits) {
            return true;
        }

        @Override
        public void reset() {
        }
    }
}

