/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.timeline.render;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.JComponent;
import org.scec.vtk.timeline.render.AbstractThreadedRenderer;
import org.scec.vtk.timeline.render.QualitySlider;

public class ImageSequenceRenderer
extends AbstractThreadedRenderer {
    private static final boolean D = true;
    private String extension;
    private String name;
    private QualitySlider qualitySilder;
    private File outputDir;
    private String prefix;
    private int digits;
    private int index;
    private ImageWriter writer;
    private ImageWriteParam writeParam;

    public static ImageSequenceRenderer getPNG() {
        return new ImageSequenceRenderer("png", "PNG Sequence", false, 0);
    }

    public static ImageSequenceRenderer getJPEG() {
        return new ImageSequenceRenderer("jpg", "JPEG Sequence", true, 90);
    }

    ImageSequenceRenderer(String extension, String name, boolean showQuality, int defaultQuality) {
        this.extension = extension;
        this.name = name;
        if (showQuality) {
            this.qualitySilder = new QualitySlider(defaultQuality);
        }
    }

    @Override
    public JComponent getSettingsComponent() {
        return this.qualitySilder;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    protected void doInit(File outputFile, int width, int height, double fps, int count) throws IOException {
        this.digits = ("" + (count + 1)).length();
        this.index = 0;
        this.outputDir = outputFile.getParentFile();
        this.prefix = outputFile.getName();
        if (this.prefix.toLowerCase().endsWith("." + this.extension.toLowerCase())) {
            this.prefix = this.prefix.substring(0, this.prefix.length() - (this.extension.length() + 1));
        }
        if (this.prefix.endsWith("_" + this.getNumStr(0))) {
            this.prefix = this.prefix.substring(0, this.prefix.lastIndexOf("_"));
        }
        System.out.println("Output dir: " + this.outputDir.getAbsolutePath());
        System.out.println("Output prefix: " + this.prefix);
        this.writer = ImageIO.getImageWritersByFormatName(this.extension).next();
        this.writeParam = this.writer.getDefaultWriteParam();
        if (this.qualitySilder != null) {
            this.writeParam.setCompressionMode(2);
            this.writeParam.setCompressionQuality((float)this.qualitySilder.getValue() / 100.0f);
        }
    }

    private String getNumStr(int index) {
        String numStr = "" + index;
        while (numStr.length() < this.digits) {
            numStr = "0" + numStr;
        }
        return numStr;
    }

    @Override
    protected void doProcessFrame(BufferedImage img) throws IOException {
        File outputFile = new File(this.outputDir, this.prefix + "_" + this.getNumStr(this.index) + "." + this.extension);
        System.out.print("Writing frame " + this.index + " to " + outputFile.getName());
        FileImageOutputStream outputStream = new FileImageOutputStream(outputFile);
        this.writer.setOutput(outputStream);
        IIOImage outputImage = new IIOImage(img, null, null);
        this.writer.write(null, outputImage, this.writeParam);
        ++this.index;
        System.out.println("DONE");
    }

    @Override
    protected void doFinalize() throws IOException {
        this.writer.dispose();
    }
}

