/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.timeline.render;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.imageio.ImageIO;
import org.opensha.commons.util.FileNameComparator;
import org.scec.vtk.timeline.render.AbstractMP4Renderer;
import org.scec.vtk.timeline.render.AbstractThreadedRenderer;
import org.scec.vtk.timeline.render.H264Renderer;
import org.scec.vtk.timeline.render.MP4JPEGSequenceRenderer;
import org.scec.vtk.timeline.render.MP4PNGSequenceRenderer;
import org.scec.vtk.timeline.render.Renderer;

public class RenderBatchTests {
    public static void main(String[] args) throws IOException {
        int[] qualities;
        File inDir = new File("/home/kevin/vdo/render_tests/input_sequence");
        File outDir = inDir.getParentFile();
        double fps = 30.0;
        ArrayList<BufferedImage> images = new ArrayList<BufferedImage>();
        File[] files = inDir.listFiles();
        Arrays.sort(files, new FileNameComparator());
        for (File file : files) {
            if (!file.getName().endsWith(".png")) continue;
            images.add(ImageIO.read(file));
            System.out.println("Processing jpeg");
        }
        System.out.println("Loaded " + images.size() + " frames");
        int width = ((BufferedImage)images.get(0)).getWidth();
        int height = ((BufferedImage)images.get(0)).getHeight();
        ArrayList<AbstractMP4Renderer> renderers = new ArrayList<AbstractMP4Renderer>();
        ArrayList<Object> fileNames = new ArrayList<Object>();
        for (int quality : qualities = new int[]{100, 90, 80, 70, 60, 50}) {
            renderers.add(new H264Renderer(quality));
            fileNames.add("h264_q" + quality);
            renderers.add(new MP4JPEGSequenceRenderer(quality));
            fileNames.add("jpeg_seq_q" + quality);
        }
        renderers.add(new MP4PNGSequenceRenderer());
        fileNames.add("png_seq");
        for (int i = 0; i < renderers.size(); ++i) {
            Renderer r = (Renderer)renderers.get(i);
            if (r instanceof AbstractThreadedRenderer) {
                ((AbstractThreadedRenderer)r).setThreadLocalProcessing(true);
            }
            File outputFile = new File(outDir, (String)fileNames.get(i) + "." + r.getExtension());
            System.out.println("Processing " + outputFile.getName());
            r.init(outputFile, width, height, fps, images.size());
            for (BufferedImage img : images) {
                r.processFrame(img);
            }
            r.finalize();
        }
    }
}

