/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.tools;

import java.awt.Color;
import java.awt.Insets;
import java.awt.Toolkit;
import java.io.File;
import java.util.prefs.Preferences;

public class Prefs {
    public static final Color DEFAULT_MATERIAL_AMBIENT = new Color(0.3f, 0.3f, 0.3f);
    public static final Color DEFAULT_MATERIAL_EMISSIVE = new Color(0.0f, 0.0f, 0.0f);
    public static final Color DEFAULT_MATERIAL_DIFFUSE = new Color(0.8f, 0.8f, 0.8f);
    public static final Color DEFAULT_MATERIAL_SPECULAR = new Color(0.0f, 0.0f, 0.0f);
    public static final float DEFAULT_MATERIAL_SHININESS = 100.0f;
    private static Preferences prefs = Preferences.userNodeForPackage(Prefs.class);
    private static String defaultLibLocation;
    private static int defaultStriping_r;
    private static int defaultStriping_g;
    private static int defaultStriping_b;
    private static int defaultPluginWidth;
    private static int defaultPluginHeight;
    private static int defaultMainWidth;
    private static int defaultMainHeight;
    private static int os;
    private static int platformActionKey;
    private static String platformFileSeparator;
    private static Insets platformIconInset;
    public static final int OSX = 1;
    public static final int WINDOWS = 2;
    public static final float Unrecorded_Depth_Flag = 10.991234f;
    private static boolean initialized;

    public static void init() {
        String system = System.getProperty("os.name");
        if (system.equals("Mac OS X")) {
            os = 1;
        } else if (system.indexOf("Windows") != -1) {
            os = 2;
        }
        platformActionKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        platformFileSeparator = File.separator;
        platformIconInset = os == 1 ? new Insets(3, 4, 3, 4) : new Insets(3, 4, 2, 3);
        defaultLibLocation = System.getProperty("user.home") + platformFileSeparator + ".scec_vdo";
        initialized = true;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static void setPluginWidth(int width) {
        prefs.putInt("PLUGIN_WIDTH", width);
    }

    public static int getPluginWidth() {
        return prefs.getInt("PLUGIN_WIDTH", defaultPluginWidth);
    }

    public static void setPluginHeight(int height) {
        prefs.putInt("PLUGIN_HEIGHT", height);
    }

    public static int getPluginHeight() {
        return prefs.getInt("PLUGIN_HEIGHT", defaultPluginHeight);
    }

    public static void setMainHeight(int height) {
        prefs.putInt("MAIN_HEIGHT", height);
    }

    public static int getMainHeight() {
        return prefs.getInt("MAIN_HEIGHT", defaultMainHeight);
    }

    public static void setMainWidth(int width) {
        prefs.putInt("MAIN_WIDTH", width);
    }

    public static int getMainWidth() {
        return prefs.getInt("MAIN_WIDTH", defaultMainWidth);
    }

    public static void setTotalWidth(int width) {
        prefs.putInt("MAIN_WIDTH", width - defaultPluginWidth);
    }

    public static int getTotalWidth() {
        return prefs.getInt("MAIN_WIDTH", defaultMainWidth) + prefs.getInt("PLUGIN_WIDTH", defaultPluginWidth);
    }

    public static void setLibLoc(String location) {
        prefs.put("LIB", location);
    }

    public static String getLibLoc() {
        return prefs.get("LIB", defaultLibLocation);
    }

    public static String getDefaultLocation() {
        return defaultLibLocation;
    }

    public static void setStripingColor(Color color) {
        prefs.putInt("STRIPE_COLOR_R", color.getRed());
        prefs.putInt("STRIPE_COLOR_G", color.getGreen());
        prefs.putInt("STRIPE_COLOR_B", color.getBlue());
    }

    public static Color getStripingColor() {
        int r = prefs.getInt("STRIPE_COLOR_R", defaultStriping_r);
        int g = prefs.getInt("STRIPE_COLOR_G", defaultStriping_g);
        int b = prefs.getInt("STRIPE_COLOR_B", defaultStriping_b);
        Color c = new Color(r, g, b);
        return c;
    }

    public static void moveLib() {
    }

    public static int getOS() {
        return os;
    }

    public static int getActionKey() {
        return platformActionKey;
    }

    public static String getFS() {
        return platformFileSeparator;
    }

    public static Insets getIconInset() {
        return platformIconInset;
    }

    static {
        defaultStriping_r = 240;
        defaultStriping_g = 240;
        defaultStriping_b = 255;
        defaultPluginWidth = 500;
        defaultPluginHeight = 650;
        defaultMainWidth = 720;
        defaultMainHeight = 830;
        initialized = false;
    }
}

