/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.tools;

public class Transform {
    public static final double re = 6378.14;
    public static final double rp = 6356.755;
    private static final double PIBy2 = 1.5707963267948966;

    public static double calcRadius(double lat) {
        double radius = 6378.14 * Math.pow(1.0 + 0.006739593092323296 * (Math.sin(Math.toRadians(lat)) * Math.sin(Math.toRadians(lat))), -0.5);
        return radius;
    }

    public static double[] transformLatLonHeight(double lat, double lon, double height) {
        return Transform.customTransform(new double[]{Transform.calcRadius(lat) + height, lat, lon});
    }

    public static double[] transformLatLon(double lat, double lon) {
        return Transform.customTransform(new double[]{Transform.calcRadius(lat), lat, lon});
    }

    public static double[] customTransform(double[] latlon) {
        double phi = latlon[1];
        double theta = latlon[2];
        theta = theta > 180.0 ? 180.0 : theta;
        theta = theta < -180.0 ? -180.0 : theta;
        phi = phi > 90.0 ? 90.0 : phi;
        phi = phi < -90.0 ? -90.0 : phi;
        double tmp = Math.cos(Math.toRadians(phi));
        double n0 = -tmp * Math.sin(Math.toRadians(theta));
        double n1 = tmp * Math.cos(Math.toRadians(theta));
        double n2 = Math.sin(Math.toRadians(phi));
        double[] x = new double[]{n0 * latlon[0], n1 * latlon[0], n2 * latlon[0]};
        return x;
    }

    public static double[] WorldPointToLatLonHeight(double[] x) {
        double height;
        double[] latLon = new double[3];
        double rho = Math.sqrt(x[0] * x[0] + x[1] * x[1] + x[2] * x[2]);
        double S = Math.sqrt(x[0] * x[0] + x[1] * x[1]);
        double phi = Math.acos(x[2] / rho);
        double theta = 0.0;
        theta = x[0] >= 0.0 ? Math.asin(x[1] / S) : Math.PI - Math.asin(x[1] / S);
        phi = Math.toDegrees(1.5707963267948966 - phi);
        theta = Math.toDegrees(theta - 1.5707963267948966);
        latLon[0] = Math.round(phi);
        latLon[1] = Math.round(theta);
        double radius = Transform.calcRadius(latLon[0]);
        latLon[2] = height = rho - radius;
        return latLon;
    }
}

