/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import vtk.vtkActor;
import vtk.vtkDataSetMapper;
import vtk.vtkMapper;
import vtk.vtkNativeLibrary;
import vtk.vtkObject;
import vtk.vtkPanel;
import vtk.vtkProp;
import vtk.vtkReferenceInformation;
import vtk.vtkRenderer;
import vtk.vtkShrinkFilter;
import vtk.vtkSphereSource;

public class VTKDemo
extends JPanel {
    private static final long serialVersionUID = 1L;
    private vtkPanel panel3d = new vtkPanel();
    private JCheckBox runGC;
    private JCheckBox debugMode;
    private JLabel gcStatus = new JLabel("");
    private int NUMBER_OF_PIPLINE_TO_BUILD = 120;
    private int nbSeconds;
    private final CompletionService<vtkActor> exec;

    public VTKDemo() {
        super(new BorderLayout());
        this.runGC = new JCheckBox("Enable GC", false);
        this.debugMode = new JCheckBox("Debug mode", false);
        this.exec = new ExecutorCompletionService<vtkActor>(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
        JPanel statusBar = new JPanel();
        statusBar.setLayout(new BoxLayout(statusBar, 0));
        statusBar.add(this.runGC);
        statusBar.add(this.debugMode);
        statusBar.add(Box.createHorizontalGlue());
        statusBar.add(this.gcStatus);
        this.add((Component)this.panel3d, "Center");
        this.add((Component)statusBar, "South");
        this.setupWorkers();
        this.nbSeconds = 0;
        new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                vtkRenderer renderer;
                if (VTKDemo.this.nbSeconds++ < 10) {
                    VTKDemo.this.panel3d.resetCamera();
                }
                if ((renderer = VTKDemo.this.panel3d.GetRenderer()).GetNumberOfPropsRendered() > 1) {
                    renderer.RemoveActor(renderer.GetActors().GetLastProp());
                }
                if (VTKDemo.this.runGC.isSelected()) {
                    vtkReferenceInformation info = vtkObject.JAVA_OBJECT_MANAGER.gc(VTKDemo.this.debugMode.isSelected());
                    if (VTKDemo.this.debugMode.isSelected()) {
                        System.out.println(info.listKeptReferenceToString());
                        System.out.println(info.listRemovedReferenceToString());
                    }
                    VTKDemo.this.gcStatus.setText(info.toString());
                } else {
                    VTKDemo.this.gcStatus.setText("");
                }
                VTKDemo.this.panel3d.Render();
            }
        }).start();
    }

    private void setupGC() {
        vtkObject.JAVA_OBJECT_MANAGER.getAutoGarbageCollector().SetScheduleTime(1L, TimeUnit.SECONDS);
        this.runGC.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                vtkObject.JAVA_OBJECT_MANAGER.getAutoGarbageCollector().SetAutoGarbageCollection(VTKDemo.this.runGC.isSelected());
            }
        });
        this.debugMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                vtkObject.JAVA_OBJECT_MANAGER.getAutoGarbageCollector().SetDebug(VTKDemo.this.debugMode.isSelected());
            }
        });
    }

    private void setupWorkers() {
        final AddActorRunnable adderRunnable = new AddActorRunnable();
        adderRunnable.setRenderer(this.panel3d);
        new Thread(){

            @Override
            public void run() {
                for (int i = 0; i < VTKDemo.this.NUMBER_OF_PIPLINE_TO_BUILD; ++i) {
                    try {
                        adderRunnable.setActor(VTKDemo.this.exec.take().get());
                        SwingUtilities.invokeAndWait(adderRunnable);
                        VTKDemo.this.panel3d.repaint();
                        continue;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    catch (ExecutionException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
    }

    public void startWorking() {
        for (int i = 0; i < this.NUMBER_OF_PIPLINE_TO_BUILD; ++i) {
            this.exec.submit(new PipelineBuilder());
        }
    }

    public static void main(String[] args) throws InterruptedException, InvocationTargetException {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VTKDemo app = new VTKDemo();
                JFrame f = new JFrame("Concurrency test");
                f.getContentPane().setLayout(new BorderLayout());
                f.getContentPane().add((Component)app, "Center");
                f.setDefaultCloseOperation(3);
                f.setSize(400, 400);
                f.setVisible(true);
                f.validate();
                app.startWorking();
            }
        });
    }

    static {
        if (!vtkNativeLibrary.LoadAllNativeLibraries()) {
            for (vtkNativeLibrary lib : vtkNativeLibrary.values()) {
                if (lib.IsLoaded()) continue;
                System.out.println(lib.GetLibraryName() + " not loaded");
            }
        }
        vtkNativeLibrary.DisableOutputWindow(null);
    }

    public static class AddActorRunnable
    implements Runnable {
        private vtkActor actorToAdd;
        private vtkRenderer renderer;
        private vtkPanel panel;

        void setRenderer(vtkPanel panel) {
            this.renderer = panel.GetRenderer();
            this.panel = panel;
        }

        void setActor(vtkActor a) {
            this.actorToAdd = a;
        }

        @Override
        public void run() {
            this.renderer.AddActor((vtkProp)this.actorToAdd);
            this.panel.Render();
        }
    }

    public static class PipelineBuilder
    implements Callable<vtkActor> {
        private vtkActor actor;
        private vtkDataSetMapper mapper;
        private vtkShrinkFilter shrink;
        private vtkSphereSource sphere;

        @Override
        public vtkActor call() throws Exception {
            this.actor = new vtkActor();
            this.mapper = new vtkDataSetMapper();
            this.shrink = new vtkShrinkFilter();
            this.sphere = new vtkSphereSource();
            this.sphere.SetPhiResolution(60);
            this.sphere.SetThetaResolution(60);
            double[] center = new double[3];
            this.sphere.SetCenter(this.GetRandomCenter(center));
            this.actor.GetProperty().SetColor(Math.random(), Math.random(), Math.random());
            this.actor.SetMapper((vtkMapper)this.mapper);
            this.mapper.SetInputConnection(this.shrink.GetOutputPort());
            this.shrink.SetInputConnection(this.sphere.GetOutputPort());
            this.mapper.Update();
            Thread.sleep((long)(Math.random() * 500.0));
            return this.actor;
        }

        public double[] GetRandomCenter(double[] center) {
            for (int i = 0; i < 3; ++i) {
                center[i] = Math.random() * 10.0;
            }
            return center;
        }
    }
}

