/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.tools.picking;

import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Map;
import org.scec.vtk.tools.picking.PickEnabledActor;
import org.scec.vtk.tools.picking.PickHandler;
import vtk.vtkCellPicker;

public class PointPickEnabledActor<E>
extends PickEnabledActor<E> {
    private Map<Integer, E> pointIDreferenceMap = new HashMap<Integer, E>();

    public PointPickEnabledActor(PickHandler<E> handler) {
        super(handler, null);
    }

    public void registerPointID(int pointID, E reference) {
        this.pointIDreferenceMap.put(pointID, reference);
    }

    public E unregisterPointID(int pointID) {
        return this.pointIDreferenceMap.remove(pointID);
    }

    public int getNumRegisteredPoints() {
        return this.pointIDreferenceMap.size();
    }

    @Override
    public void picked(vtkCellPicker picker, MouseEvent e) {
        if (this.handler == null) {
            return;
        }
        Integer pointID = (int)picker.GetPointId();
        E reference = this.pointIDreferenceMap.get(pointID);
        this.handler.actorPicked(this, reference, picker, e);
    }
}

