/*
 * Decompiled with CFR 0.152.
 */
package org.scec.vtk.tools.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.log4j.Logger;
import org.scec.vtk.main.MainGUI;
import org.scec.vtk.plugins.PluginInfo;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class Plugins {
    public static final String PLUGIN_DESCRIPTOR_SCHEMA = "plugin.xsd";
    public static final String PLUGIN_DESCRIPTOR = "plugin.xml";
    public static final String PLUGIN_PROPERTIES = "plugin.properties";
    public static String DEFAULT_PLUGIN_DIRECTORY = String.valueOf(MainGUI.getCWD()) + File.separator + "plugins";
    private static final Logger log = Logger.getLogger(Plugins.class);

    private Plugins() {
    }

    public static Map<String, PluginInfo> getAvailablePlugins() throws IOException {
        return Plugins.getAvailablePlugins(new File(DEFAULT_PLUGIN_DIRECTORY));
    }

    public static Map<String, PluginInfo> getAvailablePlugins(File pluginDirectory) throws IOException {
        if (!pluginDirectory.exists() || !pluginDirectory.isDirectory()) {
            throw new IOException("Plugin directory " + String.valueOf(pluginDirectory) + " not found");
        }
        HashMap<String, PluginInfo> availablePlugins = new HashMap<String, PluginInfo>();
        File[] fds = pluginDirectory.listFiles();
        for (int i = 0; i < fds.length; ++i) {
            File fd = fds[i];
            if (fd.isDirectory()) {
                File pluginxml = new File(fd, PLUGIN_DESCRIPTOR);
                if (!pluginxml.exists() || !pluginxml.isFile()) continue;
                List<PluginInfo> plugins = null;
                try {
                    FileInputStream fis = new FileInputStream(pluginxml);
                    plugins = Plugins.parseDescriptor(fis);
                    fis.close();
                }
                catch (IOException ioe) {
                    IOException e = new IOException("Unable to load plugin from directory: " + fd.getName());
                    e.initCause(ioe);
                    throw e;
                }
                Properties props = new Properties();
                File pluginprops = new File(fd, PLUGIN_PROPERTIES);
                if (pluginprops.exists()) {
                    FileInputStream in = new FileInputStream(pluginprops);
                    props.load(in);
                    in.close();
                }
                for (PluginInfo plugin : plugins) {
                    log.debug((Object)("Found plugin: " + plugin.getName() + " (" + plugin.getId() + ")"));
                    plugin.setProperties(props);
                    availablePlugins.put(plugin.getId(), plugin);
                }
                continue;
            }
            if (!fd.isFile() || !fd.getName().endsWith(".jar")) continue;
            try {
                JarFile jar = new JarFile(fd);
                ZipEntry pluginxml = jar.getEntry(PLUGIN_DESCRIPTOR);
                if (pluginxml != null) {
                    List<PluginInfo> plugins = Plugins.parseDescriptor(jar.getInputStream(pluginxml));
                    Properties props = new Properties();
                    ZipEntry pluginprops = jar.getEntry(PLUGIN_PROPERTIES);
                    if (pluginprops != null) {
                        props.load(jar.getInputStream(pluginprops));
                    }
                    for (PluginInfo plugin : plugins) {
                        log.debug((Object)("Found plugin: " + plugin.getName() + " (" + plugin.getId() + ")"));
                        plugin.setProperties(props);
                        availablePlugins.put(plugin.getId(), plugin);
                    }
                }
                jar.close();
                continue;
            }
            catch (IOException ioe) {
                IOException e = new IOException("Unable to load plugin from jar: " + fd.getName());
                e.initCause(ioe);
                throw e;
            }
        }
        return availablePlugins;
    }

    private static List<PluginInfo> parseDescriptor(InputStream is) throws IOException {
        try {
            PluginDescriptorParser parser = new PluginDescriptorParser();
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(parser);
            reader.setEntityResolver(parser);
            reader.setErrorHandler(parser);
            reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            reader.parse(new InputSource(is));
            return parser.getPlugins();
        }
        catch (Exception e) {
            IOException ioe = new IOException("Unable to parse plugin descriptor");
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static class PluginDescriptorParser
    extends DefaultHandler {
        private LinkedList<PluginInfo> plugins = new LinkedList();
        private PluginInfo current = null;

        public List<PluginInfo> getPlugins() {
            return this.plugins;
        }

        @Override
        public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
            if ("plugin".equals(qname)) {
                this.current = new PluginInfo();
                this.current.setId(attributes.getValue("id"));
                this.current.setName(attributes.getValue("name"));
                this.current.setShortName(attributes.getValue("short-name"));
                this.current.setCreator(attributes.getValue("creator"));
                this.current.setVersion(attributes.getValue("version"));
                this.current.setPluginClass(attributes.getValue("plugin-class"));
            } else if ("menu-item".equals(qname)) {
                this.current.setMenu(true);
                this.current.setMenuName(attributes.getValue("menu"));
                this.current.setSubmenuName(attributes.getValue("submenu"));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qname) throws SAXException {
            if ("plugin".equals(qname)) {
                this.plugins.add(this.current);
                this.current = null;
            }
        }

        @Override
        public InputSource resolveEntity(String publicID, String systemID) throws IOException, SAXException {
            if (systemID.endsWith(Plugins.PLUGIN_DESCRIPTOR_SCHEMA)) {
                URL url = Plugins.class.getResource(Plugins.PLUGIN_DESCRIPTOR_SCHEMA);
                return new InputSource(url.openStream());
            }
            return null;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            exception.printStackTrace();
        }
    }
}

