/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.earthquake.event;

import gov.usgs.earthquake.event.EventInfo;
import java.math.BigDecimal;
import java.math.MathContext;

public class EventComparison {
    private final BigDecimal locationDifference;
    private final BigDecimal magnitudeDifference;
    private final BigDecimal depthDifference;
    private final BigDecimal timeDifference;

    public EventComparison(EventInfo a, EventInfo b) {
        MathContext roundContext = new MathContext(5);
        BigDecimal distance = EventComparison.getDistance(a, b);
        this.locationDifference = distance == null ? null : distance.round(roundContext);
        this.magnitudeDifference = a.getMagnitude() == null || b.getMagnitude() == null ? null : a.getMagnitude().subtract(b.getMagnitude()).abs().round(roundContext);
        this.depthDifference = a.getDepth() == null || b.getDepth() == null ? null : a.getDepth().subtract(b.getDepth()).abs().round(roundContext);
        this.timeDifference = a.getTime() == null || b.getTime() == null ? null : new BigDecimal(a.getTime().getTime() - b.getTime().getTime()).abs().divide(new BigDecimal("1000")).round(roundContext);
    }

    public EventComparison(BigDecimal timeDifference, BigDecimal locationDifference, BigDecimal depthDifference, BigDecimal magnitudeDifference) {
        this.timeDifference = timeDifference;
        this.locationDifference = locationDifference;
        this.depthDifference = depthDifference;
        this.magnitudeDifference = magnitudeDifference;
    }

    public BigDecimal getLocationDifference() {
        return this.locationDifference;
    }

    public BigDecimal getMagnitudeDifference() {
        return this.magnitudeDifference;
    }

    public BigDecimal getDepthDifference() {
        return this.depthDifference;
    }

    public BigDecimal getTimeDifference() {
        return this.timeDifference;
    }

    public static BigDecimal getDistance(EventInfo a, EventInfo b) {
        try {
            return new BigDecimal(EventComparison.getDistance(a.getLongitude().doubleValue(), b.getLongitude().doubleValue(), a.getLatitude().doubleValue(), b.getLatitude().doubleValue()));
        }
        catch (NullPointerException npe) {
            return null;
        }
    }

    public static double getDistance(double lona, double lonb, double lata, double latb) {
        double R = 6367.0;
        lona = Math.toRadians(lona);
        lonb = Math.toRadians(lonb);
        lata = Math.toRadians(lata);
        latb = Math.toRadians(latb);
        double dlon = lonb - lona;
        double dlat = latb - lata;
        double A = Math.pow(Math.sin(dlat / 2.0), 2.0);
        return R * 2.0 * Math.asin(Math.min(1.0, Math.sqrt(A += Math.cos(lata) * Math.cos(latb) * Math.pow(Math.sin(dlon / 2.0), 2.0))));
    }
}

