/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.earthquake.event;

import gov.usgs.earthquake.event.DefaultEventInfo;
import gov.usgs.earthquake.event.EventComparison;
import gov.usgs.earthquake.event.EventInfo;
import gov.usgs.earthquake.event.EventQuery;
import gov.usgs.earthquake.event.EventSanityCheck;
import gov.usgs.earthquake.event.EventWebService;
import gov.usgs.earthquake.event.ISO8601;
import gov.usgs.earthquake.event.JsonEvent;
import gov.usgs.earthquake.event.JsonEventInfo;
import gov.usgs.earthquake.event.JsonEventInfoComparator;
import java.math.BigDecimal;
import java.math.MathContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class EventIDAssociator {
    public static final BigDecimal KILOMETERS_PER_DEGREE = new BigDecimal("111.2");
    public static final BigDecimal DEFAULT_TIME_DIFFERENCE = new BigDecimal("16");
    public static final BigDecimal DEFAULT_LOCATION_DIFFERENCE = new BigDecimal("100");
    public static final BigDecimal DEFAULT_MAGNITUDE_DIFFERENCE = null;
    public static final BigDecimal DEFAULT_DEPTH_DIFFERENCE = null;
    private EventWebService service;
    private EventComparison nearbyCriteria;
    private EventSanityCheck sanityCheck;
    public static final int EXIT_SUCCESS = 0;
    public static final int EXIT_EVENT_NOT_FOUND = 1;
    public static final int EXIT_EVENT_NOT_SANE = 2;
    public static final int EXIT_MULTIPLE_EVENTS_FOUND = 4;
    public static final int EXIT_USAGE = 255;
    public static final String SERVICE_URL_ARGUMENT = "--url=";
    public static final String DEFAULT_SERVICE_URL = "http://comcat.cr.usgs.gov/fdsnws/event/1/";
    public static final String TIME_ARGUMENT = "--time=";
    public static final String LATITUDE_ARGUMENT = "--latitude=";
    public static final String LONGITUDE_ARGUMENT = "--longitude=";
    public static final String DEPTH_ARGUMENT = "--depth=";
    public static final String MAGNITUDE_ARGUMENT = "--magnitude=";
    public static final String NETWORK_ARGUMENT = "--network=";
    public static final String TIME_DIFFERENCE_ARGUMENT = "--timeSearch";
    public static final String LOCATION_DIFFERENCE_ARGUMENT = "--locationSearch=";
    public static final String DEPTH_DIFFERENCE_ARGUMENT = "--depthSearch=";
    public static final String MAGNITUDE_DIFFERENCE_ARGUMENT = "--magnitudeSearch=";
    public static final String TIME_CHECK_ARGUMENT = "--timeCheck";
    public static final String LOCATION_CHECK_ARGUMENT = "--locationCheck=";
    public static final String DEPTH_CHECK_ARGUMENT = "--depthCheck=";
    public static final String MAGNITUDE_CHECK_ARGUMENT = "--magnitudeCheck=";

    public EventIDAssociator() throws MalformedURLException {
        this(new EventWebService(new URL(DEFAULT_SERVICE_URL)), new EventComparison(DEFAULT_TIME_DIFFERENCE, DEFAULT_LOCATION_DIFFERENCE, DEFAULT_DEPTH_DIFFERENCE, DEFAULT_MAGNITUDE_DIFFERENCE), new EventSanityCheck());
    }

    public EventIDAssociator(EventWebService service, EventComparison nearbyCriteria, EventSanityCheck sanityCheck) {
        this.service = service;
        this.nearbyCriteria = nearbyCriteria;
        this.sanityCheck = sanityCheck;
    }

    public List<JsonEvent> getNearbyEvents(Date time, BigDecimal latitude, BigDecimal longitude, BigDecimal depth, BigDecimal magnitude, String network) throws Exception {
        return this.getNearbyEvents(new DefaultEventInfo(null, time, latitude, longitude, depth, magnitude), network);
    }

    public List<JsonEvent> getNearbyEvents(EventInfo info, String network) throws Exception {
        Date time = info.getTime();
        BigDecimal latitude = info.getLatitude();
        BigDecimal longitude = info.getLongitude();
        BigDecimal depth = info.getDepth();
        BigDecimal magnitude = info.getMagnitude();
        boolean anySet = false;
        EventQuery query = new EventQuery();
        query.setCatalog(network);
        if (time != null && this.nearbyCriteria.getTimeDifference() != null) {
            long milliseconds = this.nearbyCriteria.getTimeDifference().multiply(new BigDecimal("1000")).longValue();
            query.setStartTime(new Date(time.getTime() - milliseconds));
            query.setEndTime(new Date(time.getTime() + milliseconds));
            anySet = true;
        }
        if (latitude != null && longitude != null && this.nearbyCriteria.getLocationDifference() != null) {
            query.setLatitude(latitude);
            query.setLongitude(longitude);
            query.setMaxRadius(this.nearbyCriteria.getLocationDifference().divide(KILOMETERS_PER_DEGREE, MathContext.DECIMAL32));
            anySet = true;
        }
        if (depth != null && this.nearbyCriteria.getDepthDifference() != null) {
            query.setMinDepth(info.getDepth().subtract(this.nearbyCriteria.getDepthDifference()));
            query.setMaxDepth(info.getDepth().add(this.nearbyCriteria.getDepthDifference()));
            anySet = true;
        }
        if (magnitude != null && this.nearbyCriteria.getMagnitudeDifference() != null) {
            query.setMinMagnitude(info.getMagnitude().subtract(this.nearbyCriteria.getMagnitudeDifference()));
            query.setMaxMagnitude(info.getMagnitude().add(this.nearbyCriteria.getMagnitudeDifference()));
            anySet = true;
        }
        if (!anySet) {
            throw new IllegalArgumentException("no parameters set");
        }
        return this.service.getEvents(query);
    }

    public List<JsonEventInfo> sortEvents(List<JsonEvent> events, EventInfo referenceEvent) {
        TreeSet<JsonEventInfo> sortedEvents = new TreeSet<JsonEventInfo>(new JsonEventInfoComparator(this.sanityCheck, referenceEvent));
        Iterator<JsonEvent> iter = events.iterator();
        while (iter.hasNext()) {
            JsonEventInfo info = new JsonEventInfo(iter.next());
            sortedEvents.add(info);
        }
        return new ArrayList<JsonEventInfo>(sortedEvents);
    }

    public List<JsonEventInfo> getSortedNearbyEvents(EventInfo info, String network) throws Exception {
        return this.sortEvents(this.getNearbyEvents(info, network), info);
    }

    public static void main(String[] args) throws Exception {
        EventInfo referenceEvent = EventIDAssociator.parseReferenceEvent(args);
        String network = EventIDAssociator.parseNetwork(args);
        EventIDAssociator associator = EventIDAssociator.parseEventIDAssociator(args);
        if (referenceEvent.getTime() == null && (referenceEvent.getLatitude() == null || referenceEvent.getLongitude() == null)) {
            System.err.println("Usage: java EventIDAssociator [--time=ISO8601] [--latitude=LAT --longitude=LON] [--depth=DEPTH] [--magnitude=MAG] [--network=NET] [--url=SERVICE_URL] [--timeSearch" + DEFAULT_TIME_DIFFERENCE + "]" + " [" + LOCATION_DIFFERENCE_ARGUMENT + DEFAULT_LOCATION_DIFFERENCE + "]" + " [" + DEPTH_DIFFERENCE_ARGUMENT + DEFAULT_DEPTH_DIFFERENCE + "]" + " [" + MAGNITUDE_DIFFERENCE_ARGUMENT + DEFAULT_MAGNITUDE_DIFFERENCE + "]" + " [ " + TIME_CHECK_ARGUMENT + EventSanityCheck.TIME_THRESHOLD + "]" + " [ " + LOCATION_CHECK_ARGUMENT + EventSanityCheck.DISTANCE_THRESHOLD + "]" + " [ " + DEPTH_CHECK_ARGUMENT + EventSanityCheck.DEPTH_THRESHOLD + "]" + " [ " + MAGNITUDE_CHECK_ARGUMENT + EventSanityCheck.MAGNITUDE_THRESHOLD + "]");
            System.err.println();
            System.err.println("Time, or latitude and longitude, are required");
            System.err.println("Exit values:");
            System.err.println("\t0 - one event found");
            System.err.println("\t1 - no events found");
            System.err.println("\t2 - event significantly different");
            System.err.println("\t4 - multiple events found");
            System.err.println("\t255 - usage error");
            System.exit(255);
        }
        List<JsonEventInfo> events = associator.getSortedNearbyEvents(referenceEvent, network);
        System.out.println(associator.formatOutput(referenceEvent, network, events));
        int exitCode = associator.getExitCode(events);
        if (exitCode != 0) {
            System.exit(exitCode);
        }
    }

    protected static EventInfo parseReferenceEvent(String[] args) {
        Date time = null;
        BigDecimal latitude = null;
        BigDecimal longitude = null;
        BigDecimal depth = null;
        BigDecimal magnitude = null;
        for (String arg : args) {
            if (arg.startsWith(TIME_ARGUMENT)) {
                time = ISO8601.parse(arg.replace(TIME_ARGUMENT, ""));
                continue;
            }
            if (arg.startsWith(LATITUDE_ARGUMENT)) {
                latitude = new BigDecimal(arg.replace(LATITUDE_ARGUMENT, ""));
                continue;
            }
            if (arg.startsWith(LONGITUDE_ARGUMENT)) {
                longitude = new BigDecimal(arg.replace(LONGITUDE_ARGUMENT, ""));
                continue;
            }
            if (arg.startsWith(DEPTH_ARGUMENT)) {
                depth = new BigDecimal(arg.replace(DEPTH_ARGUMENT, ""));
                continue;
            }
            if (!arg.startsWith(MAGNITUDE_ARGUMENT)) continue;
            magnitude = new BigDecimal(arg.replace(MAGNITUDE_ARGUMENT, ""));
        }
        return new DefaultEventInfo(null, time, latitude, longitude, depth, magnitude);
    }

    protected static String parseNetwork(String[] args) {
        String network = null;
        for (String arg : args) {
            if (!arg.startsWith(NETWORK_ARGUMENT)) continue;
            network = arg.replace(NETWORK_ARGUMENT, "");
        }
        return network;
    }

    protected static EventIDAssociator parseEventIDAssociator(String[] args) throws MalformedURLException {
        URL serviceUrl = new URL(DEFAULT_SERVICE_URL);
        BigDecimal timeDifference = DEFAULT_TIME_DIFFERENCE;
        BigDecimal locationDifference = DEFAULT_LOCATION_DIFFERENCE;
        BigDecimal depthDifference = DEFAULT_DEPTH_DIFFERENCE;
        BigDecimal magnitudeDifference = DEFAULT_MAGNITUDE_DIFFERENCE;
        BigDecimal timeCheck = EventSanityCheck.TIME_THRESHOLD;
        BigDecimal locationCheck = EventSanityCheck.DISTANCE_THRESHOLD;
        BigDecimal depthCheck = EventSanityCheck.DEPTH_THRESHOLD;
        BigDecimal magnitudeCheck = EventSanityCheck.MAGNITUDE_THRESHOLD;
        for (String arg : args) {
            if (arg.startsWith(SERVICE_URL_ARGUMENT)) {
                serviceUrl = new URL(arg.replace(SERVICE_URL_ARGUMENT, ""));
                continue;
            }
            if (arg.startsWith(TIME_DIFFERENCE_ARGUMENT)) {
                timeDifference = new BigDecimal(arg.replace(TIME_DIFFERENCE_ARGUMENT, ""));
                continue;
            }
            if (arg.startsWith(LOCATION_DIFFERENCE_ARGUMENT)) {
                locationDifference = new BigDecimal(arg.replace(LOCATION_DIFFERENCE_ARGUMENT, ""));
                continue;
            }
            if (arg.startsWith(DEPTH_DIFFERENCE_ARGUMENT)) {
                depthDifference = new BigDecimal(arg.replace(DEPTH_DIFFERENCE_ARGUMENT, ""));
                continue;
            }
            if (arg.startsWith(MAGNITUDE_DIFFERENCE_ARGUMENT)) {
                magnitudeDifference = new BigDecimal(arg.replace(MAGNITUDE_DIFFERENCE_ARGUMENT, ""));
                continue;
            }
            if (arg.startsWith(TIME_CHECK_ARGUMENT)) {
                timeCheck = new BigDecimal(arg.replace(TIME_CHECK_ARGUMENT, ""));
                continue;
            }
            if (arg.startsWith(LOCATION_CHECK_ARGUMENT)) {
                locationCheck = new BigDecimal(arg.replace(LOCATION_CHECK_ARGUMENT, ""));
                continue;
            }
            if (arg.startsWith(DEPTH_CHECK_ARGUMENT)) {
                depthCheck = new BigDecimal(arg.replace(DEPTH_CHECK_ARGUMENT, ""));
                continue;
            }
            if (!arg.startsWith(MAGNITUDE_CHECK_ARGUMENT)) continue;
            magnitudeCheck = new BigDecimal(arg.replace(MAGNITUDE_CHECK_ARGUMENT, ""));
        }
        return new EventIDAssociator(new EventWebService(serviceUrl), new EventComparison(timeDifference, locationDifference, depthDifference, magnitudeDifference), new EventSanityCheck(timeCheck, locationCheck, depthCheck, magnitudeCheck));
    }

    protected int getExitCode(List<JsonEventInfo> events) {
        if (events.size() == 0) {
            return 1;
        }
        if (events.size() > 1) {
            return 4;
        }
        if (this.getEventSanityCheck().isMatch(events.get(0).getEventComparison()) != null) {
            return 2;
        }
        return 0;
    }

    protected String formatOutput(EventInfo referenceEvent, String network, List<JsonEventInfo> events) {
        JSONObject jsonMetadata = new JSONObject();
        jsonMetadata.put("count", events.size());
        jsonMetadata.put("time", ISO8601.format(referenceEvent.getTime()));
        jsonMetadata.put("latitude", referenceEvent.getLatitude());
        jsonMetadata.put("longitude", referenceEvent.getLongitude());
        jsonMetadata.put("depth", referenceEvent.getDepth());
        jsonMetadata.put("magnitude", referenceEvent.getMagnitude());
        jsonMetadata.put("network", network);
        JSONArray jsonEvents = new JSONArray();
        for (JsonEventInfo next : events) {
            JSONObject diff = new JSONObject();
            EventComparison comparison = next.getEventComparison();
            diff.put("magnitude", comparison.getMagnitudeDifference());
            diff.put("location", comparison.getLocationDifference());
            diff.put("depth", comparison.getDepthDifference());
            diff.put("time", comparison.getTimeDifference());
            diff.put("errorMessage", this.sanityCheck.isMatch(comparison));
            diff.put("variance", next.getDistance());
            JSONObject jsonEvent = new JSONObject((Map)next.getEvent());
            jsonEvent.put("difference", diff);
            jsonEvents.add(jsonEvent);
        }
        JSONObject output = new JSONObject();
        output.put("type", "FeatureCollection");
        output.put("metadata", jsonMetadata);
        output.put("features", jsonEvents);
        return output.toJSONString().replace("\\/", "/");
    }

    public EventWebService getEventWebService() {
        return this.service;
    }

    public void setEventWebService(EventWebService service) {
        this.service = service;
    }

    public EventComparison getNearbyCriteria() {
        return this.nearbyCriteria;
    }

    public void setNearbyCriteria(EventComparison nearbyCriteria) {
        this.nearbyCriteria = nearbyCriteria;
    }

    public EventSanityCheck getEventSanityCheck() {
        return this.sanityCheck;
    }

    public void setEventSanityCheck(EventSanityCheck sanityCheck) {
        this.sanityCheck = sanityCheck;
    }
}

