/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.earthquake.event;

import gov.usgs.earthquake.event.EventComparison;
import java.math.BigDecimal;

public class EventSanityCheck {
    public static final BigDecimal DISTANCE_THRESHOLD = new BigDecimal("30");
    private final BigDecimal distanceThreshold;
    public static final BigDecimal MAGNITUDE_THRESHOLD = new BigDecimal(".4");
    private final BigDecimal magnitudeThreshold;
    public static final BigDecimal DEPTH_THRESHOLD = new BigDecimal("30");
    private final BigDecimal depthThreshold;
    public static final BigDecimal TIME_THRESHOLD = new BigDecimal("5");
    private final BigDecimal timeThreshold;

    public EventSanityCheck() {
        this(TIME_THRESHOLD, DISTANCE_THRESHOLD, DEPTH_THRESHOLD, MAGNITUDE_THRESHOLD);
    }

    public EventSanityCheck(BigDecimal timeThreshold, BigDecimal distanceThreshold, BigDecimal depthThreshold, BigDecimal magnitudeThreshold) {
        this.timeThreshold = timeThreshold;
        this.distanceThreshold = distanceThreshold;
        this.depthThreshold = depthThreshold;
        this.magnitudeThreshold = magnitudeThreshold;
    }

    public String isMatch(EventComparison c) {
        StringBuffer errors = new StringBuffer();
        if (this.distanceThreshold != null && c.getLocationDifference() != null && c.getLocationDifference().compareTo(this.distanceThreshold) == 1) {
            errors.append("Distance of " + c.getLocationDifference() + " kilometers exceeds threshold of " + this.distanceThreshold + ".\n");
        }
        if (this.magnitudeThreshold != null && c.getMagnitudeDifference() != null && c.getMagnitudeDifference().compareTo(this.magnitudeThreshold) == 1) {
            errors.append("Magnitude difference of " + c.getMagnitudeDifference() + " exceeded threshold of " + this.magnitudeThreshold + ".\n");
        }
        if (this.depthThreshold != null && c.getDepthDifference() != null && c.getDepthDifference().compareTo(this.depthThreshold) == 1) {
            errors.append("Depth difference of " + c.getDepthDifference() + " kilometers exceeds threshold of " + this.depthThreshold + ".\n");
        }
        if (this.timeThreshold != null && c.getTimeDifference() != null && c.getTimeDifference().compareTo(this.timeThreshold) == 1) {
            errors.append("Time difference of " + c.getTimeDifference() + " seconds exceeds threshold of " + this.timeThreshold + ".\n");
        }
        if (errors.length() == 0) {
            return null;
        }
        return errors.toString().trim();
    }

    public double getDistance(EventComparison c) {
        double distance;
        double diff = 0.0;
        if (c.getLocationDifference() != null && this.distanceThreshold != null) {
            distance = c.getLocationDifference().doubleValue() / this.distanceThreshold.doubleValue();
            diff += distance * distance;
        }
        if (c.getTimeDifference() != null && this.timeThreshold != null) {
            distance = c.getTimeDifference().doubleValue() / this.timeThreshold.doubleValue();
            diff += distance * distance;
        }
        if (c.getMagnitudeDifference() != null && this.magnitudeThreshold != null) {
            distance = c.getMagnitudeDifference().doubleValue() / this.magnitudeThreshold.doubleValue();
            diff += distance * distance;
        }
        if (c.getDepthDifference() != null && this.depthThreshold != null) {
            distance = c.getDepthDifference().doubleValue() / this.depthThreshold.doubleValue();
            diff += distance * distance;
        }
        return Math.sqrt(diff);
    }

    public BigDecimal getTimeThreshold() {
        return this.timeThreshold;
    }

    public BigDecimal getDistanceThreshold() {
        return this.distanceThreshold;
    }

    public BigDecimal getDepthThreshold() {
        return this.depthThreshold;
    }

    public BigDecimal getMagnitudeThreshold() {
        return this.magnitudeThreshold;
    }
}

