/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.earthquake.event;

import gov.usgs.earthquake.event.EventQuery;
import gov.usgs.earthquake.event.Format;
import gov.usgs.earthquake.event.ISO8601;
import gov.usgs.earthquake.event.JsonEvent;
import gov.usgs.earthquake.event.JsonUtil;
import gov.usgs.earthquake.event.UrlUtil;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class EventWebService {
    private final URL serviceURL;

    public EventWebService(URL serviceURL) {
        this.serviceURL = serviceURL;
    }

    public URL getUrl(EventQuery query, Format format) throws MalformedURLException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("alertlevel", (Object)query.getAlertLevel());
        params.put("catalog", query.getCatalog());
        params.put("contributor", query.getContributor());
        params.put("endtime", ISO8601.format(query.getEndTime()));
        params.put("eventid", query.getEventId());
        params.put("eventtype", query.getEventType());
        params.put("format", (Object)(format == null ? query.getFormat() : format));
        params.put("includeallmagnitudes", query.getIncludeAllMagnitudes());
        params.put("includeallorigins", query.getIncludeAllOrigins());
        params.put("includearrivals", query.getIncludeArrivals());
        params.put("kmlanimated", query.getKmlAnimated());
        params.put("kmlcolorby", (Object)query.getKmlColorBy());
        params.put("latitude", query.getLatitude());
        params.put("limit", query.getLimit());
        params.put("longitude", query.getLongitude());
        params.put("magnitudetype", query.getMagnitudeType());
        params.put("maxcdi", query.getMaxCdi());
        params.put("maxdepth", query.getMaxDepth());
        params.put("maxgap", query.getMaxGap());
        params.put("maxlatitude", query.getMaxLatitude());
        params.put("maxlongitude", query.getMaxLongitude());
        params.put("maxmagnitude", query.getMaxMagnitude());
        params.put("maxmmi", query.getMaxMmi());
        params.put("maxradius", query.getMaxRadius());
        params.put("maxsig", query.getMaxSig());
        params.put("mincdi", query.getMinCdi());
        params.put("mindepth", query.getMinDepth());
        params.put("minfelt", query.getMinFelt());
        params.put("mingap", query.getMinGap());
        params.put("minlatitude", query.getMinLatitude());
        params.put("minlongitude", query.getMinLongitude());
        params.put("minmagnitude", query.getMinMagnitude());
        params.put("minmmi", query.getMinMmi());
        params.put("minradius", query.getMinRadius());
        params.put("minsig", query.getMinSig());
        params.put("offset", query.getOffset());
        params.put("orderby", (Object)query.getOrderBy());
        params.put("producttype", query.getProductType());
        params.put("reviewstatus", (Object)query.getReviewStatus());
        params.put("starttime", ISO8601.format(query.getStartTime()));
        params.put("updatedafter", ISO8601.format(query.getUpdatedAfter()));
        String queryString = UrlUtil.getQueryString(params);
        return new URL(this.serviceURL, "query" + queryString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JsonEvent> getEvents(EventQuery query) throws Exception {
        InputStream result = null;
        List<JsonEvent> events = null;
        try {
            result = UrlUtil.getInputStream(this.getUrl(query, Format.GEOJSON));
            events = this.parseJsonEventCollection(result);
        }
        finally {
            try {
                result.close();
            }
            catch (NullPointerException npx) {}
        }
        return events;
    }

    protected List<JsonEvent> parseJsonEventCollection(InputStream input) throws Exception {
        JSONParser parser = new JSONParser();
        JSONObject feed = JsonUtil.getJsonObject(parser.parse(new InputStreamReader(input)));
        if (feed == null) {
            throw new Exception("Expected feed object");
        }
        String type = JsonUtil.getString(feed.get("type"));
        if (type == null) {
            throw new Exception("Expected geojson type");
        }
        ArrayList<JsonEvent> events = new ArrayList<JsonEvent>();
        if (type.equals("Feature")) {
            events.add(new JsonEvent(feed));
        } else if (type.equals("FeatureCollection")) {
            JSONArray features = JsonUtil.getJsonArray(feed.get("features"));
            if (features == null) {
                throw new Exception("Expected features");
            }
            Iterator iter = features.iterator();
            while (iter.hasNext()) {
                JSONObject next = JsonUtil.getJsonObject(iter.next());
                if (next == null) {
                    throw new Exception("Expected feature");
                }
                events.add(new JsonEvent(next));
            }
        }
        return events;
    }

    public URL getServiceUrl() {
        return this.serviceURL;
    }
}

