/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.earthquake.event;

import gov.usgs.earthquake.event.EventId;
import gov.usgs.earthquake.event.JsonUtil;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class JsonEvent
extends JSONObject {
    private static final long serialVersionUID = 1L;

    public JsonEvent(JSONObject json) {
        super((Map)json);
    }

    private JSONObject getProperties() {
        return JsonUtil.getJsonObject(this.get("properties"));
    }

    private JSONArray getCoordinates() {
        JSONObject geometry = JsonUtil.getJsonObject(this.get("geometry"));
        return JsonUtil.getJsonArray(geometry.get("coordinates"));
    }

    public EventId getEventId() {
        try {
            return new EventId(this.getNet(), this.getCode());
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public BigDecimal getMag() {
        return JsonUtil.getBigDecimal(this.getProperties().get("mag"));
    }

    public BigDecimal getCdi() {
        return JsonUtil.getBigDecimal(this.getProperties().get("cdi"));
    }

    public BigDecimal getMmi() {
        return JsonUtil.getBigDecimal(this.getProperties().get("mmi"));
    }

    public BigDecimal getDmin() {
        return JsonUtil.getBigDecimal(this.getProperties().get("dmin"));
    }

    public BigDecimal getRms() {
        return JsonUtil.getBigDecimal(this.getProperties().get("rms"));
    }

    public BigDecimal getGap() {
        return JsonUtil.getBigDecimal(this.getProperties().get("gap"));
    }

    public BigDecimal getLongitude() {
        return JsonUtil.getBigDecimal(this.getCoordinates().get(0));
    }

    public BigDecimal getLatitude() {
        return JsonUtil.getBigDecimal(this.getCoordinates().get(1));
    }

    public BigDecimal getDepth() {
        return JsonUtil.getBigDecimal(this.getCoordinates().get(2));
    }

    public String getPlace() {
        return JsonUtil.getString(this.getProperties().get("place"));
    }

    public String getUrl() {
        return JsonUtil.getString(this.getProperties().get("url"));
    }

    public String getDetail() {
        return JsonUtil.getString(this.getProperties().get("detail"));
    }

    public String getAlert() {
        return JsonUtil.getString(this.getProperties().get("alert"));
    }

    public String getStatus() {
        return JsonUtil.getString(this.getProperties().get("status"));
    }

    public String getNet() {
        return JsonUtil.getString(this.getProperties().get("net"));
    }

    public String getCode() {
        return JsonUtil.getString(this.getProperties().get("code"));
    }

    public String getIds() {
        return JsonUtil.getString(this.getProperties().get("ids"));
    }

    public String getSources() {
        return JsonUtil.getString(this.getProperties().get("sources"));
    }

    public String getTypes() {
        return JsonUtil.getString(this.getProperties().get("types"));
    }

    public String getType() {
        return JsonUtil.getString(this.getProperties().get("type"));
    }

    public String getMagType() {
        return JsonUtil.getString(this.getProperties().get("magType"));
    }

    public Date getTime() {
        return JsonUtil.getDate(this.getProperties().get("time"));
    }

    public Date getUpdated() {
        return JsonUtil.getDate(this.getProperties().get("updated"));
    }

    public Integer getTz() {
        return JsonUtil.getInteger(this.getProperties().get("tz"));
    }

    public Integer getFelt() {
        return JsonUtil.getInteger(this.getProperties().get("felt"));
    }

    public Integer getTsunami() {
        return JsonUtil.getInteger(this.getProperties().get("tsunami"));
    }

    public Integer getSig() {
        return JsonUtil.getInteger(this.getProperties().get("sig"));
    }

    public Integer getNst() {
        return JsonUtil.getInteger(this.getProperties().get("nst"));
    }
}

