/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.earthquake.event;

import gov.usgs.earthquake.event.EventComparison;
import gov.usgs.earthquake.event.EventInfo;
import gov.usgs.earthquake.event.EventSanityCheck;
import gov.usgs.earthquake.event.JsonEventInfo;
import java.util.Comparator;

public class JsonEventInfoComparator
implements Comparator<JsonEventInfo> {
    private EventSanityCheck sanityRules;
    private EventInfo referenceEvent;

    public JsonEventInfoComparator(EventSanityCheck sanityRules, EventInfo referenceEvent) {
        this.sanityRules = sanityRules;
        this.referenceEvent = referenceEvent;
    }

    @Override
    public int compare(JsonEventInfo event1, JsonEventInfo event2) {
        if (event1.getEventComparison() == null) {
            event1.setEventComparison(new EventComparison(this.referenceEvent, event1));
            event1.setDistance(this.sanityRules.getDistance(event1.getEventComparison()));
        }
        if (event2.getEventComparison() == null) {
            event2.setEventComparison(new EventComparison(this.referenceEvent, event2));
            event2.setDistance(this.sanityRules.getDistance(event2.getEventComparison()));
        }
        Double event1Distance = event1.getDistance();
        Double event2Distance = event2.getDistance();
        if (event1Distance < event2Distance) {
            return -1;
        }
        if (event1Distance > event2Distance) {
            return 1;
        }
        return 0;
    }
}

