/*
 * Decompiled with CFR 0.152.
 */
package gov.usgs.earthquake.event;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;

public class UrlUtil {
    public static final String GZIP_ENCODING = "gzip";

    public static InputStream getInputStream(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.addRequestProperty("Accept-encoding", GZIP_ENCODING);
        conn.connect();
        InputStream in = conn.getInputStream();
        if (GZIP_ENCODING.equals(conn.getContentEncoding())) {
            in = new GZIPInputStream(in);
        }
        return in;
    }

    public static String getQueryString(HashMap<String, Object> params) {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (String key : new TreeSet<String>(params.keySet())) {
            Object value = params.get(key);
            if (value == null) continue;
            if (first) {
                buf.append("?");
                first = false;
            } else {
                buf.append("&");
            }
            buf.append(key).append("=").append(value.toString());
        }
        return buf.toString();
    }
}

