/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.jdesktop.jxlayer.plaf.LayerUI;

public final class JXLayer<V extends Component>
extends JComponent
implements Scrollable,
PropertyChangeListener,
Accessible {
    private V view;
    private LayerUI<? super V> layerUI;
    private JPanel glassPane;
    private boolean isPainting;
    private static final DefaultLayerLayout sharedLayoutInstance = new DefaultLayerLayout();
    private long eventMask;
    private static final LayerEventController eventController = new LayerEventController();
    private static final long ACCEPTED_EVENTS = 231487L;

    public JXLayer() {
        this(null);
    }

    public JXLayer(V v) {
        this(v, null);
    }

    public JXLayer(V v, LayerUI<V> layerUI) {
        super.setLayout(sharedLayoutInstance);
        this.setGlassPane(this.createGlassPane());
        this.setView(v);
        this.setUI(layerUI);
    }

    public V getView() {
        return this.view;
    }

    public void setView(V v) {
        V v2 = this.getView();
        if (v2 != null) {
            super.remove((Component)v2);
        }
        if (v != null) {
            super.addImpl((Component)v, null, this.getComponentCount());
        }
        this.view = v;
        this.firePropertyChange("view", v2, v);
        this.revalidate();
        this.repaint();
    }

    public void setUI(LayerUI<? super V> layerUI) {
        this.layerUI = layerUI;
        super.setUI(layerUI);
    }

    @Override
    public LayerUI<? super V> getUI() {
        return this.layerUI;
    }

    public JPanel getGlassPane() {
        return this.glassPane;
    }

    public void setGlassPane(JPanel jPanel) {
        JPanel jPanel2 = this.getGlassPane();
        if (jPanel2 != null) {
            super.remove(jPanel2);
        }
        if (jPanel != null) {
            super.addImpl(jPanel, null, 0);
        }
        this.glassPane = jPanel;
        this.firePropertyChange("glassPane", jPanel2, jPanel);
        this.revalidate();
        this.repaint();
    }

    public JPanel createGlassPane() {
        return new DefaultLayerGlassPane();
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        throw new UnsupportedOperationException("Adding components to JXLayer is not supported, use setView() or setGlassPane() instead");
    }

    @Override
    public void remove(Component component) {
        if (component == this.getView()) {
            this.setView(null);
        } else if (component == this.getGlassPane()) {
            this.setGlassPane(null);
        } else {
            super.remove(component);
        }
    }

    @Override
    public void removeAll() {
        this.setView(null);
        this.setGlassPane(null);
    }

    @Override
    public void paint(Graphics graphics) {
        if (!this.isPainting && this.getUI() != null) {
            this.isPainting = true;
            super.paintComponent(graphics);
            this.isPainting = false;
        } else {
            super.paint(graphics);
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return !this.glassPane.isVisible();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.getUI() != null) {
            this.getUI().handlePropertyChangeEvent(propertyChangeEvent, this);
        }
    }

    public void setLayerEventMask(long l) {
        if (l != (l & 0x3883FL)) {
            throw new IllegalArgumentException("The event bitmask contains unsupported event types");
        }
        long l2 = this.getLayerEventMask();
        this.eventMask = l;
        this.firePropertyChange("layerEventMask", l2, l);
        if (l != l2) {
            this.disableEvents(l2);
            this.enableEvents(this.eventMask);
            JXLayer.eventController.updateAWTEventListener(this);
        }
    }

    public long getLayerEventMask() {
        return this.eventMask;
    }

    @Override
    public void updateUI() {
        if (this.getUI() != null) {
            this.getUI().updateUI(this);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        if (this.getUI() != null) {
            return this.getUI().getPreferredScrollableViewportSize(this);
        }
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (this.getUI() != null) {
            return this.getUI().getScrollableBlockIncrement(this, rectangle, n, n2);
        }
        return n == 1 ? rectangle.height : rectangle.width;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getUI() != null) {
            return this.getUI().getScrollableTracksViewportHeight(this);
        }
        if (this.getParent() instanceof JViewport) {
            return this.getParent().getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        if (this.getUI() != null) {
            return this.getUI().getScrollableTracksViewportWidth(this);
        }
        if (this.getParent() instanceof JViewport) {
            return this.getParent().getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (this.getUI() != null) {
            return this.getUI().getScrollableUnitIncrement(this, rectangle, n, n2);
        }
        return 1;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.getUI() != null) {
            this.setUI(this.getUI());
        }
        if (this.getLayerEventMask() != 0L) {
            JXLayer.eventController.updateAWTEventListener(this);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }
            };
        }
        return this.accessibleContext;
    }

    private static class DefaultLayerGlassPane
    extends JPanel {
        public DefaultLayerGlassPane() {
            this.setOpaque(false);
        }

        @Override
        public boolean contains(int n, int n2) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                Point point = SwingUtilities.convertPoint(this, new Point(n, n2), component);
                if (!component.isVisible() || !component.contains(point)) continue;
                return true;
            }
            if (this.getMouseListeners().length == 0 && this.getMouseMotionListeners().length == 0 && this.getMouseWheelListeners().length == 0 && !this.isCursorSet()) {
                return false;
            }
            return super.contains(n, n2);
        }
    }

    private static class DefaultLayerLayout
    implements LayoutManager,
    Serializable {
        private DefaultLayerLayout() {
        }

        @Override
        public void layoutContainer(Container container) {
            JXLayer jXLayer = (JXLayer)container;
            Object v = jXLayer.getView();
            JPanel jPanel = jXLayer.getGlassPane();
            if (v != null) {
                Insets insets = jXLayer.getInsets();
                ((Component)v).setLocation(insets.left, insets.top);
                ((Component)v).setSize(jXLayer.getWidth() - insets.left - insets.right, jXLayer.getHeight() - insets.top - insets.bottom);
            }
            if (jPanel != null) {
                jPanel.setLocation(0, 0);
                jPanel.setSize(jXLayer.getWidth(), jXLayer.getHeight());
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            JXLayer jXLayer = (JXLayer)container;
            Insets insets = jXLayer.getInsets();
            Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
            Object v = jXLayer.getView();
            if (v != null) {
                Dimension dimension2 = ((Component)v).getMinimumSize();
                dimension.width += dimension2.width;
                dimension.height += dimension2.height;
            }
            if (dimension.width == 0 || dimension.height == 0) {
                dimension.height = 4;
                dimension.width = 4;
            }
            return dimension;
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            JXLayer jXLayer = (JXLayer)container;
            Insets insets = jXLayer.getInsets();
            Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
            Object v = jXLayer.getView();
            if (v != null) {
                Dimension dimension2 = ((Component)v).getPreferredSize();
                if (dimension2.width > 0 && dimension2.height > 0) {
                    dimension.width += dimension2.width;
                    dimension.height += dimension2.height;
                }
            }
            return dimension;
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }
    }

    private static class LayerEventController
    implements AWTEventListener {
        private ArrayList<WeakReference<JXLayer>> layerList = new ArrayList();
        private long currentEventMask;

        private LayerEventController() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            Object object = aWTEvent.getSource();
            if (object instanceof Component) {
                for (Component component = (Component)object; component != null; component = component.getParent()) {
                    JXLayer jXLayer;
                    LayerUI layerUI;
                    if (!(component instanceof JXLayer) || (layerUI = (jXLayer = (JXLayer)component).getUI()) == null || !this.isEventEnabled(jXLayer.getLayerEventMask(), aWTEvent.getID())) continue;
                    layerUI.eventDispatched(aWTEvent, jXLayer);
                }
            }
        }

        private boolean layerListContains(JXLayer jXLayer) {
            for (WeakReference<JXLayer> weakReference : this.layerList) {
                if (weakReference.get() != jXLayer) continue;
                return true;
            }
            return false;
        }

        private void updateAWTEventListener(JXLayer jXLayer) {
            if (!this.layerListContains(jXLayer) && jXLayer.getLayerEventMask() != 0L) {
                this.layerList.add(new WeakReference<JXLayer>(jXLayer));
            }
            long l = 0L;
            Iterator<WeakReference<JXLayer>> iterator = this.layerList.iterator();
            while (iterator.hasNext()) {
                WeakReference<JXLayer> weakReference = iterator.next();
                JXLayer jXLayer2 = (JXLayer)weakReference.get();
                if (jXLayer2 == null) {
                    iterator.remove();
                    continue;
                }
                l |= jXLayer2.getLayerEventMask();
            }
            if (l == 0L) {
                this.removeAWTEventListener();
                this.layerList.clear();
            } else if (this.getCurrentEventMask() != l) {
                this.removeAWTEventListener();
                this.addAWTEventListener(l);
            }
        }

        private long getCurrentEventMask() {
            return this.currentEventMask;
        }

        private void addAWTEventListener(final long l) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Toolkit.getDefaultToolkit().addAWTEventListener(LayerEventController.this, l);
                    return null;
                }
            });
            this.currentEventMask = l;
        }

        private void removeAWTEventListener() {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(LayerEventController.this);
                    return null;
                }
            });
            this.currentEventMask = 0L;
        }

        private boolean isEventEnabled(long l, int n) {
            return (l & 1L) != 0L && n >= 100 && n <= 103 || (l & 2L) != 0L && n >= 300 && n <= 301 || (l & 4L) != 0L && n >= 1004 && n <= 1005 || (l & 8L) != 0L && n >= 400 && n <= 402 || (l & 0x20000L) != 0L && n == 507 || (l & 0x20L) != 0L && (n == 503 || n == 506) || (l & 0x10L) != 0L && n != 503 && n != 506 && n != 507 && n >= 500 && n <= 507 || (l & 0x800L) != 0L && n >= 1100 && n <= 1101 || (l & 0x8000L) != 0L && n == 1400 || (l & 0x10000L) != 0L && (n == 1401 || n == 1402);
        }
    }
}

