/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.plaf;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractBufferedLayerUI;
import org.jdesktop.jxlayer.plaf.effect.LayerEffect;

public class BufferedLayerUI<V extends JComponent>
extends AbstractBufferedLayerUI<V> {
    private LayerEffect[] effects = new LayerEffect[0];
    private Shape clip;
    private Composite composite;
    private Map<RenderingHints.Key, Object> renderingHints = new HashMap<RenderingHints.Key, Object>(0);
    private AffineTransform transform;
    private boolean incrementalUpdate = true;

    public LayerEffect[] getLayerEffects() {
        LayerEffect[] layerEffectArray = new LayerEffect[this.effects.length];
        System.arraycopy(this.effects, 0, layerEffectArray, 0, layerEffectArray.length);
        return layerEffectArray;
    }

    @Override
    protected LayerEffect[] getLayerEffects(JXLayer<? extends V> jXLayer) {
        return this.getLayerEffects();
    }

    public void setLayerEffects(LayerEffect ... layerEffectArray) {
        LayerEffect[] layerEffectArray2 = this.getLayerEffects();
        if (layerEffectArray == null) {
            layerEffectArray = new LayerEffect[]{};
        }
        for (LayerEffect layerEffect : this.getLayerEffects()) {
            layerEffect.removePropertyChangeListener(this);
        }
        this.effects = new LayerEffect[layerEffectArray.length];
        System.arraycopy(layerEffectArray, 0, this.effects, 0, layerEffectArray.length);
        for (LayerEffect layerEffect : layerEffectArray) {
            layerEffect.addPropertyChangeListener(this);
        }
        this.firePropertyChange("layerEffects", layerEffectArray2, layerEffectArray);
    }

    public Shape getClip() {
        return this.clip;
    }

    @Override
    protected Shape getClip(JXLayer<? extends V> jXLayer) {
        return this.getClip();
    }

    public void setClip(Shape shape) {
        Shape shape2 = this.getClip();
        this.clip = shape;
        this.firePropertyChange("clip", shape2, shape);
    }

    public Composite getComposite() {
        return this.composite;
    }

    @Override
    protected Composite getComposite(JXLayer<? extends V> jXLayer) {
        return this.getComposite();
    }

    public void setComposite(Composite composite) {
        Composite composite2 = this.getComposite();
        this.composite = composite;
        this.firePropertyChange("composite", composite2, composite);
    }

    public float getAlpha() {
        if (this.composite instanceof AlphaComposite) {
            AlphaComposite alphaComposite = (AlphaComposite)this.composite;
            return alphaComposite.getAlpha();
        }
        return 1.0f;
    }

    public void setAlpha(float f) {
        this.setComposite(AlphaComposite.getInstance(3, f));
    }

    public Map<RenderingHints.Key, Object> getRenderingHints() {
        return Collections.unmodifiableMap(this.renderingHints);
    }

    @Override
    protected Map<RenderingHints.Key, Object> getRenderingHints(JXLayer<? extends V> jXLayer) {
        return this.getRenderingHints();
    }

    public void setRenderingHints(Map<RenderingHints.Key, Object> map) {
        Map<RenderingHints.Key, Object> map2 = this.getRenderingHints();
        if (map == null) {
            map = new HashMap<RenderingHints.Key, Object>();
        }
        this.renderingHints = map;
        this.firePropertyChange("renderingHints", map2, map);
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    @Override
    protected AffineTransform getTransform(JXLayer<? extends V> jXLayer) {
        return this.getTransform();
    }

    public void setTransform(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = this.getTransform();
        this.transform = affineTransform;
        this.firePropertyChange("transform", affineTransform2, affineTransform);
    }

    public boolean isIncrementalUpdate() {
        return this.incrementalUpdate;
    }

    @Override
    protected boolean isIncrementalUpdate(JXLayer<? extends V> jXLayer) {
        return this.isIncrementalUpdate();
    }

    public void setIncrementalUpdate(boolean bl) {
        boolean bl2 = this.isIncrementalUpdate();
        this.incrementalUpdate = bl;
        this.firePropertyChange("incrementalUpdate", bl2, bl);
    }
}

